// -*- mode: C++; c-file-style: "Stroustrup" -*-
//
// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with the package.



#ifndef KROT_DIALOG_SELECT_SET_H
#define KROT_DIALOG_SELECT_SET_H


#include <qdialog.h>

class DataSet;
class KRotData;
class QLabel;
class QListBox;
class QString;



/**
 * This is a general dialog for the selection of a single set. There is one static instance,
 * which's member function getSelection returns the name of the selected set.
 *
 * @short General set-selection dialog.
 * @author Jochen Kpper
 * @version 1999/01/17
 */
class DialogSelectSet : public QDialog
{
    Q_OBJECT

public:
    
    DialogSelectSet( KRotData *krotdata, QWidget* parent=0, const char* name=0);
 
    /**
     * @return Name of selected DataSet.
     */
    const QString getSelectionString() const;

    /**
     * @return Pointer to selected DataSet.
     *         Zero if non is selected.
     */
    DataSet *getSelection();

    /**
     * Overloaded execution routine for convenience,
     * sets the dialogs message and enters the dialogs local event loop.
     *
     * @param msg Message to display in the dialog
     * @return How did we finish ? See \ref QDialog::exec
     */
    int exec( const QString& msg = QString() );
    

protected slots:

    void help() const;

    void select(const char *);


protected:

    /**
     * Refresh list contenst
     */
    void refresh();
    

protected:

    KRotData *krotData;

    QLabel *label;

    QListBox *list;

    QPushButton *ok;
};



#endif
