c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1998 Arnim Westphal
c     Copyright (C) 1997-1999 Jochen Kpper
c
c     If you use this program for your scientific work, please cite it according to
c     the file CITATION included with this package.
c
c     krot-arnirot
c     a program to calculate rotational resolved vibrational/vibronic bands


#include "arni.h"

      subroutine wriham( hammat, dm, J, kind, frame, lngbar, lstars )
c     output hamiltonian matrix for a given J block, designed for J <= 10

      implicit none

      integer        dm
      integer        i, J, row, col
      integer        ket(-10:10)
      integer        strlen
      real*8         hammat(dm,dm)
      character*9    kind
      character*10   frame
      character*81   lstars
      character*220  lngbar

      ARNIROT_LAUNCH ( "Launching wriham." )

      write(*,'(a)') lstars
      write(*,'(a,i3,a,/)') 'J =',J,' block:'
      write(*,'(4a,/)') frame(1:strlen(frame)),' frame ',kind(1:strlen(kind)),' hamiltonian matrix [MHz]:'
      write(*,'(a,/)') '| Kz> / | Kz>'

c     ket: array of integers to hold quantum number count
c     define ket values
      do i = -J, J, 1
         ket(i) = i
      end do

c     write out the basis set kets across the top
      if (J.eq. 0) write(*,'(10x, 1(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      if (J.eq. 1) write(*,'(10x, 3(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      if (J.eq. 2) write(*,'(10x, 5(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      if (J.eq. 3) write(*,'(10x, 7(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      if (J.eq. 4) write(*,'(10x, 9(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      if (J.eq. 5) write(*,'(10x,11(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      if (J.eq. 6) write(*,'(10x,13(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      if (J.eq. 7) write(*,'(10x,15(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      if (J.eq. 8) write(*,'(10x,17(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      if (J.eq. 9) write(*,'(10x,19(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      if (J.eq.10) write(*,'(10x,21(''|'',i3,''>'',4x))') (ket(i), i = -J, J, 1)
      write(*,'(7x,a)') lngbar(1:(2*J+1)*9)

      do row = 1, 2*J+1, 1
         write(*,'(''|'',i3,''> |'',21(f9.1))') ket(row-J-1), (hammat(row,col), col = 1, 2*J+1, 1)
      end do

      return
      end


c------------------------------------------------------------------------------
      subroutine wrivec( vecmat, dmham, J, icqn, dmeval, kind, lngbar, ldash )
c     output eigenvectors of a given J block, designed for J <= 10

      implicit none

      integer        dmham, dmeval
      integer        i, col, row, iept, J, l
      integer        ket(-10:10)
      integer        icqn(dmeval,3)
      integer        strlen
      real*8         vecmat(dmham,dmham)
      character*9    kind
      character*81   ldash
      character*220  lngbar

      ARNIROT_LAUNCH ( "Launching wrivec." )

      write(*,'(a)') ldash
      write(*,'(2a,/)') kind(1:strlen(kind)),' eigenvector matrix:'

c     ket: array of integers to hold quantum number count
c     define ket values
      do i = -J, J, 1
         ket(i) = i
      end do

      iept = J*J
      write(*,'(''| Kz> / |J KaKc>'',/)')
      if (J.eq. 0) write(*,'(8x, 1(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      if (J.eq. 1) write(*,'(8x, 3(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      if (J.eq. 2) write(*,'(8x, 5(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      if (J.eq. 3) write(*,'(8x, 7(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      if (J.eq. 4) write(*,'(8x, 9(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      if (J.eq. 5) write(*,'(8x,11(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      if (J.eq. 6) write(*,'(8x,13(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      if (J.eq. 7) write(*,'(8x,15(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      if (J.eq. 8) write(*,'(8x,17(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      if (J.eq. 9) write(*,'(8x,19(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      if (J.eq.10) write(*,'(8x,21(''|'',3(i2),''>'',2x))') ((icqn(iept+i,l), l = 1,3,1), i = 1, 2*J+1, 1)
      write(*,'(7x,a)') lngbar(1:(2*J+1)*10-1)

      do row = 1, 2*J+1, 1
         write(*,'(''|'',i3,''> | '',21(f8.5,2x))') ket(row-J-1), (vecmat(row,col), col = 1, 2*J+1, 1)
      end do

      return
      end
