c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1998 Arnim Westphal
c     Copyright (C) 1997-1999 Jochen Kpper
c
c     If you use this program for your scientific work, please cite it according to
c     the file CITATION included with this package.
c
c     krot-arnirot
c     a program to calculate rotational resolved vibrational/vibronic bands


#include "arni.h"


      subroutine rotham( rraxsw, k, rotcog, rotcoe, npar, cState, tran, tranin,
     *                   swang, shorti, lstars, lbars )
c     rotate hamiltonian for axis switching;
c     k=1: ground state, k=2 : excited state

      implicit none

      integer        npar
      integer        k
      integer        i, icount, j, l
      integer        shorti
      integer        strlen

      real*8         rraxsw(6,2)
      real*8         rotcog(npar), rotcoe(npar)
      real*8         tran(3,3), tranin(3,3)
      real*8         con(3), ham(3,3), hamcen(3,3), hamor(3,3)
      real*8         swang(3,2)

      character*7    cState(2)
      character*81   lstars, lbars

      ARNIROT_LAUNCH ( "Launching rotham." )

c     zero matrix work spaces
      call smat0( ham, 3, 3 )
      call smat0( hamcen, 3, 3 )
      call smat0( hamor, 3, 3 )

c     generate the F to g rotation matrix, ZARE p.81 eq.(3.36)
      call fgmat( tranin, swang, k, 3, 2 )

c     fill con vector with either ground or excited state rigid rotor terms
      icount = 3
      if ( k .eq. 1 ) then
         do i = 1, 3, 1
            con(i) = rotcog(icount)
            icount = icount - 1
         end do
      else
         do i = 1, 3, 1
            con(i) = rotcoe(icount)
            icount = icount - 1
         end do
      end if

c     fill transformation matrix by <i,j> <j,i> term exchange
      call matinv( tranin, tran, 3, 3 )
      if ( shorti .eq. 0 ) then
         write(*,'(a)') lstars
         write(*,'(2a)') cState(k)(1:strlen(cState(k))), ' state tensor transformation matrices'
         write(*,'(a)') lbars
         write(*,'(a,18x,a,/)') 'transformation matrix:','inverse transformation matrix:'
         do i = 1, 3, 1
            write(*,'(3(f8.5,2x),10x,3(f8.5,2x))') (tran(i,j), j=1,3,1), (tranin(i,j), j=1,3,1)
         end do
      end if

c     define the hamiltonian matrix in terms of input rotational constants
c     Note: this program uses prolate I**r representation to identify
c     cartesian coordinates x,y,z with rotational constants b,c,a

c     save original hamiltonian for print out
      do i = 1, 3, 1
         hamor(i,i) = con(i)
      end do

c     define hamiltonian to be transformed x,y,z  b,c,a axis
      hamcen(1,1) = con(2)
      hamcen(2,2) = con(1)
      hamcen(3,3) = con(3)

c     transform molecule counter clockwise = transform hamiltonian operator clockwise = R H R**-1
      call thrmat( tran, hamcen, tranin, ham, 3, 3 )

c     output old and new hamiltonia
      if ( shorti .eq. 0 ) then
         write(*,'(a)') lbars
         write(*,'(''hamiltonian '',a7,'' state:'',14x,''transformed hamiltonian '',a7,'' state:'',/)') cState(k), cState(k)
         do i = 1, 3, 1
            write(*,'(3(f9.3,2x),7x,3(f9.3,2x))') (hamor(i,j), j = 1,3,1), (ham(i,l), l = 1,3,1)
         end do
      end if

c     define the axis switched rigid rotor terms
      rraxsw(1,k) = ham(3,3)
      rraxsw(2,k) = ham(1,1)
      rraxsw(3,k) = ham(2,2)
c     JzJy term = JaJc term
      rraxsw(4,k) = ham(2,3)
c     JzJx term = JaJb term
      rraxsw(5,k) = ham(1,3)
c     JyJx term = JcJb term
      rraxsw(6,k) = ham(1,2)

c     output rotated rigid rotor hamiltonian
      if ( shorti .eq. 0 ) then
         write(*,'(a)') lbars
         write(*,'(''rotated '',a,'' state rigid rotor hamiltonian:'',/)') cState(k)(1:strlen(cState(k)))
         write(*,'(f12.5,'' Jz**2'')') rraxsw(1,k)
         write(*,'(f12.5,'' Jx**2'')') rraxsw(2,k)
         write(*,'(f12.5,'' Jy**2'',/)') rraxsw(3,k)
         write(*,'(f12.5,'' JzJy+JyJz = JaJc+JcJa'')') rraxsw(4,k)
         write(*,'(f12.5,'' JzJx+JxJz = JaJb+JbJa'')') rraxsw(5,k)
         write(*,'(f12.5,'' JyJx+JxJy = JcJb+JbJc'')') rraxsw(6,k)
         write(*,'(a)') lstars
      end if

      return
      end


c------------------------------------------------------------------------------
      subroutine matinv( mat, invmat, dm, iact )
c     fill inverse transformation matrix by <i,j> <j,i> term exchange

      implicit none

      integer        row, col, iact, dm
      real*8         mat(dm,dm), invmat(dm,dm)

      ARNIROT_LAUNCH ( "Launching matinv." )

      do col = 1, iact, 1
         do row = 1, iact, 1
            invmat(row,col) = mat(col,row)
         end do
      end do

      return
      end


c------------------------------------------------------------------------------
      subroutine fgmat(tran, swang, k, nrow, ncol)
c     calculate the F to g rotation matrix, phi gF

      implicit none

      integer        k, nrow, ncol
      real*8         tran(nrow,nrow), swang(nrow,ncol)
      real*8         cosdeg, sindeg

      ARNIROT_LAUNCH ( "Launching fgmat." )

c     cc convention theta, phi, chi F to g inverse rotation matrix, ZARE, p.81 eq.(3.36) phi gF
      tran(1,1) =  cosdeg(swang(2,k))*cosdeg(swang(1,k))*cosdeg(swang(3,k)) - sindeg(swang(2,k))*sindeg(swang(3,k))
      tran(1,2) = -cosdeg(swang(2,k))*cosdeg(swang(1,k))*sindeg(swang(3,k)) - sindeg(swang(2,k))*cosdeg(swang(3,k))
      tran(1,3) =  cosdeg(swang(2,k))*sindeg(swang(1,k))
      tran(2,1) =  sindeg(swang(2,k))*cosdeg(swang(1,k))*cosdeg(swang(3,k)) + cosdeg(swang(2,k))*sindeg(swang(3,k))
      tran(2,2) = -sindeg(swang(2,k))*cosdeg(swang(1,k))*sindeg(swang(3,k)) + cosdeg(swang(2,k))*cosdeg(swang(3,k))
      tran(2,3) =  sindeg(swang(2,k))*sindeg(swang(1,k))
      tran(3,1) = -sindeg(swang(1,k))*cosdeg(swang(3,k))
      tran(3,2) =  sindeg(swang(1,k))*sindeg(swang(3,k))
      tran(3,3) =  cosdeg(swang(1,k))

      return
      end


c------------------------------------------------------------------------------
      real*8 function cosdeg(thetad)
c     function to evaluate cosines in degrees

      implicit none

      real*8         pi, thetad, thetar
      parameter      (pi = 3.141592653589793238462643383d0)

      thetar = thetad*pi/180.d0
      cosdeg = dcos(thetar)

      return
      end


c------------------------------------------------------------------------------
      real*8 function sindeg(thetad)
c     function to evaluate sines in degrees

      implicit none

      real*8         pi, thetad, thetar
      parameter      (pi = 3.141592653589793238462643383d0)

      thetar = thetad*pi/180.d0
      sindeg = dsin(thetar)

      return
      end
