#ifndef __WS_TABLEHEAD_H
#define __WS_TABLEHEAD_H


#include <qtablevw.h>
#include <qevent.h>
#include <qpoint.h>


class Worksheet;


class TableHead : public QTableView
  {
    Q_OBJECT
    public:
      TableHead (int numCols, QWidget* parent=0, const char* name=0);
      ~TableHead ();

    signals:
      void changeActiveWS ();

    protected:
      void paintCell( QPainter*, int row, int col );
      void mousePressEvent (QMouseEvent* e);
      void mouseReleaseEvent (QMouseEvent* e);
      void mouseMoveEvent (QMouseEvent* e);

    public slots:
      // move the leftCell to newCol
      void changeLeftCell (int newCol); 

      // change the number of columns to int
      void resizeTableHead (int);

      // update cell with col int (the row is always 0)
      void update (int);

    signals:
      void showPopup (QPoint);

    private:
      Worksheet* myworksheet;              // tell me whos my parent worksheet
      QPoint mouseOldPos;
  };


#endif

