#include "ws_tablehead.h"
#include "worksheet.h"

#include "ws_tablehead.moc"


// ****************************  Table Head  **********************************


TableHead::TableHead (int numCols, QWidget* parent, const char* name)
  : QTableView (parent, name)
  {
    setBackgroundColor( white );		// set widgets background white
    setNumCols( numCols );			// set number of col's in table
    setNumRows( 1 );			// set number of rows in table
    setCellWidth( CELLWIDTH );			// set width of cell in pixels
    setCellHeight( FIRSTCELLHEIGHT );	      	// set height of cell in pixels
    setTableFlags( Tbl_clipCellPainting |	// avoid drawing outside cell
		   Tbl_snapToGrid |
    		   Tbl_cutCellsV |
    		   Tbl_cutCellsH);

    myworksheet = (Worksheet*) parent;

    return;
  }


TableHead::~TableHead ()
  {
  }


void TableHead::paintCell( QPainter* p, int row, int col )
  {
    int w = cellWidth( col );			// width of cell in pixels
    int h = cellHeight( row );			// height of cell in pixels
    int x2 = w - 1;
    int y2 = h - 1;

    //the headline could be label or x
    QString s (myworksheet->T->title (col));
    s += "(";
    s += myworksheet->usage.at(col)->copy();
    s += ")";

    // for better understanding the columns (whether they are labels or not) 
    if (myworksheet->T->type(col) == Column::columnString)
      s += "*";

    if ( ( myworksheet->high->isHighlighted (row, col) == TRUE ) &&
	 ( strcmp("Thead", myworksheet->high->whoHasHighlighted ()) == 0) )
      {
	p->setPen (NoPen);
	p->setBrush (KApplication::getKApplication()->selectColor);
	p->drawRect (1, 1, x2, y2);
	p->setPen (SolidLine);
	p->setPen (KApplication::getKApplication()->selectTextColor);
      }
    else
      { 
	p->setPen (NoPen);
	p->setBrush (KApplication::getKApplication()->backgroundColor);
	p->drawRect (1, 1, x2, y2);
	
	p->setPen (SolidLine);
	p->setBrush (NoBrush);
	p->drawLine( x2, 0, x2, y2 );
	p->drawLine( 0, y2, x2, y2 );
	p->setPen (KApplication::getKApplication()->textColor);
      }

    p->drawText( 0, 0, w, h, AlignCenter, (const char*)s);
  }


void TableHead::resizeTableHead (int numCols)
  {
    setNumCols (numCols);
  }


void TableHead::changeLeftCell (int newCol)
  {
    setLeftCell (newCol);
  }


void TableHead::mousePressEvent( QMouseEvent* e )
  {
    // emit a signal to get the active WS if mousepress inside
    if (activeWS != myworksheet) 
      {
	emit (changeActiveWS ());
	cout << "activeWSChanged" << endl;
      }

    int i;

    // loesche die Eingabezeile (infield), das muss immer passieren
    myworksheet->Tdata->setFocus (FALSE);

    if ( e->button () == MidButton )
      {
	myworksheet->hideHighlighted ();
	return;
      }

    QPoint clickedPos = e->pos();
    myworksheet->curCol = findCol( clickedPos.x() );    

    myworksheet->hideHighlighted ();

    if (e->button () == LeftButton)
      {
	myworksheet->high->setMouseStartPos (QPoint (myworksheet->curCol, 
						     0), "Thead");
	myworksheet->high->setMouseEndPos (QPoint (myworksheet->curCol, 
				         myworksheet->T->height()-1 ) );
	update (myworksheet->curCol);
	for (i=myworksheet->Tdata->topCell(); 
	     i<=myworksheet->Tdata->lastRowVisible(); i++)
	  myworksheet->Tdata->update (i, myworksheet->curCol);
	mouseOldPos = myworksheet->high->getMouseStartPos ();
      }
    else if (e->button () == RightButton)
      {
	myworksheet->hideHighlighted ();
	clickedPos += QPoint (FIRSTCELLWIDTH,0);
	emit (showPopup (clickedPos));
      }
  }


void TableHead::mouseMoveEvent (QMouseEvent* e)
  {
    QPoint p = e->pos ();
    QPoint a;
    int i,j;

    if ( myworksheet->high->isHighlighted () == FALSE) return;
    
    if (p.x() >= (lastColVisible()-leftCell()+1)*CELLWIDTH)
      {
	changeLeftCell (leftCell()+1);
	myworksheet->Tdata->changeLeftCell (leftCell());
	myworksheet->high->setMouseEndPos (QPoint(lastColVisible (), 
				     	  myworksheet->T->height() ));
      }
    else if (p.x () < 0)
      {
	changeLeftCell (leftCell()-1);
	myworksheet->Tdata->changeLeftCell (leftCell());
	myworksheet->high->setMouseEndPos (QPoint (leftCell (), 
				     myworksheet->T->height() ));
      }
    else
      myworksheet->high->setMouseEndPos (QPoint (findCol (p.x()), 
				       	 myworksheet->T->height() ));
    
    
    a = myworksheet->high->getMouseEndPos ();
    
    if (mouseOldPos.x() == myworksheet->high->getMouseEndPos().x()) ;
    else
      {
	int lux = (a.x() < mouseOldPos.x() )? a.x() : mouseOldPos.x();
	int rlx = (a.x () > mouseOldPos.x() )? a.x() : mouseOldPos.x();
	
	for (j=lux; j<=rlx; j++)
	  {
	    update (j);
	    for (i=0; i<=myworksheet->T->height (); i++)
		   myworksheet->Tdata->update (i,j);
	  }
      }
    
    mouseOldPos = a;      
  }


void TableHead::mouseReleaseEvent (QMouseEvent* e)
  {
    QPoint p = e->pos ();
    int i;

    if ( myworksheet->high->isHighlighted () == FALSE ) return;
    
    if (p.x() >= (lastColVisible()-leftCell()+1)*CELLWIDTH)
      {
	changeLeftCell (leftCell()+1);
	myworksheet->Tdata->changeLeftCell (leftCell());
	myworksheet->high->setMouseEndPos (QPoint(lastColVisible (),
						  myworksheet->T->height() ));
      }
    else if (p.x () < 0)
      {
	changeLeftCell (leftCell()-1);
	myworksheet->Tdata->changeLeftCell (leftCell());
	myworksheet->high->setMouseEndPos (QPoint (leftCell (), 
						   myworksheet->T->height() ));
      }
    else
      myworksheet->high->setMouseEndPos (QPoint (findCol (p.x()), 
						 myworksheet->T->height() ));
    
    
    // check if the cell has changed
    if (myworksheet->high->getMouseEndPos().x() == mouseOldPos.x())
      {
	if (AUTOCOPY) myworksheet->copyToClipboard ();
	    return;
      }
	else 
	  {
	    //	int lux = myworksheet->high->getLeftX ();
	    //	int rlx = myworksheet->high->getRightX ();
	    
	    update (myworksheet->high->getMouseEndPos ().x() );
	    for (i=0; i<=myworksheet->T->height (); i++)
	      {
		myworksheet->Tdata->update (i,myworksheet->high->getMouseEndPos ().y());
	      }
	  }
    
    if (AUTOCOPY) myworksheet->copyToClipboard ();
    
  }
  

void TableHead::update (int i)
  {
    updateCell (0,i);
  }
