#ifndef __WS_TABLEFIRSTCOLUMN_H
#define __WS_TABLEFIRSTCOLUMN_H


#include <qtablevw.h>
#include <qevent.h>
#include <qpoint.h>


class Worksheet;


class TableFirstColumn : public QTableView
  {
    Q_OBJECT
    public:
      TableFirstColumn (int numRows, QWidget* parent=0, const char* name=0);
      ~TableFirstColumn ();

    signals:
      void changeActiveWS ();

    protected:
      void paintCell ( QPainter*, int row, int col );
      void mousePressEvent (QMouseEvent* e);
      void mouseReleaseEvent (QMouseEvent* e);
      void mouseMoveEvent (QMouseEvent* e);
  
    public slots:
      // for details watch the TableHead class
      void changeTopCell (int newRow);
      void resizeTableFirstColumn (int);

      void update (int);

    signals:
      void showPopup (QPoint);

    private:
      Worksheet* myworksheet;
      bool paintInverted;
      QPoint mouseOldPos;
  };


#endif

