#include <stdlib.h>
#include <math.h>

#include "worksheet.h"

#include "ws_columnstatistics.h"



// *************************  statistics on columns  **************************


columnStatWidget::columnStatWidget (int col, QWidget* parent, const char* name)
  : QDialog ( 0, name, TRUE )
  {
    char s[70], s1[40];
    int i;

    Worksheet* myworksheet = (Worksheet*)parent;

    char labeltext[50];
    strcpy (labeltext, "Column Statistics on  ");
    strcat (labeltext, myworksheet->T->title (col));
    
    setCaption ("Column Statistics");

    // ********  calculate the column statistics  *********

    double help = atof ( myworksheet->T->cell (col, 0) );

    // initialize
    double mean = help;
    double stdev = 0;
    double min = help;
    double max = help;
    int num = myworksheet->T->height (col);

    // calculate for the rest rows
    for (i=1; i<num; i++)
      {
	help = atof ( myworksheet->T->cell (col, i) );

	mean += help;
	if (help > max) max = help;
	if (help < min) min = help;
	
      }

    mean /= double (num);

    // now the standarddeviation, we first need the mean value
    for (i=0; i<num; i++)
      {
	help = atof ( myworksheet->T->cell (col, i) );

	stdev += (help - mean)*(help - mean);
      }

    stdev = sqrt ( 1/double (num) * stdev );

    // ********  go on with widget design  ********

    ok = new QPushButton( this, "PushButton_1" );
    ok->setGeometry( 250, 190, 90, 25 );
    ok->setText( "Ok" );
    ok->setAutoRepeat( FALSE );
    ok->setAutoResize( FALSE );
    ok->setDefault (TRUE);

    // setting up the multi line edit
    
    mledit = new QMultiLineEdit( this, "MultiLineEdit_2" );
    mledit->setGeometry( 25, 60, 315, 105 );
    mledit->setReadOnly (TRUE);

    strcpy (s, "Number of Rows  =  ");
    sprintf (s1, "%i", num);
    strcat (s, s1);
    mledit->insertLine( s );

    strcpy (s, "Minimum Value  =  ");
    sprintf (s1, "%g", min);
    strcat (s, s1);
    mledit->insertLine( s );

    strcpy (s, "Maximum Value  =  ");
    sprintf (s1, "%g", max);
    strcat (s, s1);
    mledit->insertLine( s );

    strcpy (s, "Mean Value  =  ");
    sprintf (s1, "%g", mean);
    strcat (s, s1);
    mledit->insertLine( s );

    strcpy (s, "Standarddeviation  =  ");
    sprintf (s1, "%g", stdev);
    strcat (s, s1);
    mledit->insertLine( s );
    
    // uff, we got it
    
    lb1 = new QLabel( this, "Label_1" );
    lb1->setGeometry( 25, 15, 300, 25 );
    lb1->setText( labeltext );
    lb1->setAlignment( 289 );
    lb1->setMargin( -1 );
    
    setFixedSize ( 370, 240 );
    
    connect (ok, SIGNAL (clicked ()), SLOT(accept ()));
  }


columnStatWidget::~columnStatWidget()
  {
    delete mledit;
    delete ok;
    delete lb1;
  }

