#include <qmsgbox.h>

#include <kapp.h>

#include "formula.h"
#include "worksheet.h"

#include "ws_calculatewidget.h"

#include "ws_calculatewidget.moc"


// **********************  The Calculate Widget  ******************************


calculateWidget::calculateWidget (int _col, Table* _T, QWidget* parent, const char* name)
  :QDialog( 0, name, TRUE )
  {
        // this widget has no default button, because this buttons grabbs
        // the return, which is necessary for the multiLineEdit 

        myworksheet = (Worksheet*) parent;
	char s1[255];
	col = _col;
	T = _T;

	fiData* fd = myworksheet->readFormulaData ();

	setCaption ("Calculate Column Data");

	strcpy (s1, "col(");
	strcat (s1, T->title (col));
	strcat (s1, ") =  ");

	lb1 = new QLabel( this, "Label_1" );
	lb1->setText( s1 );
	lb1->setAlignment( 289 );
	lb1->setMargin( -1 );

	formula = new QLineEdit( this, "LineEdit_1" );
	formula->setText( (const char*) fd->formula );
	formula->setMaxLength( 32767 );
	formula->setEchoMode( QLineEdit::Normal );
	formula->setFrame( TRUE );

	constants = new QMultiLineEdit( this, "MultiLineEdit_1" );
	constants->setText( (const char*) fd->constants );
	constants->setReadOnly( FALSE );
	constants->setOverwriteMode( FALSE );

	min = new QLineEdit( this, "LineEdit_2" );
	sprintf ( s1, "%i", fd->min );
	min->setText( s1 );
	min->setMaxLength( 32767 );
	min->setEchoMode( QLineEdit::Normal );
	min->setFrame( TRUE );

	lb4 = new QLabel( this, "Label_4" );
	lb4->setText( "to" );
	lb4->setAlignment( 289 );
	lb4->setMargin( -1 );

	max = new QLineEdit( this, "LineEdit_3" );
	sprintf ( s1, "%i", fd->max );
	max->setText( s1 );
	max->setMaxLength( 32767 );
	max->setEchoMode( QLineEdit::Normal );
	max->setFrame( TRUE );

	ok = new QPushButton( this, "PushButton_1" );
	ok->setText( "OK" );
	ok->setAutoRepeat( FALSE );
	ok->setAutoResize( FALSE );
	connect (ok, SIGNAL (clicked ()), SLOT (calculate()));      

	apply = new QPushButton( this, "PushButton_2" );
	apply->setText( "Apply" );
	apply->setAutoRepeat( FALSE );
	apply->setAutoResize( FALSE );
        connect (apply, SIGNAL (clicked ()), SLOT (applyCalculate()));

	cancel = new QPushButton( this, "PushButton_3" );
	cancel->setText( "Cancel" );
	cancel->setAutoRepeat( FALSE );
	cancel->setAutoResize( FALSE );
	connect (cancel, SIGNAL (clicked()), SLOT (reject ()));
	
	help = new QPushButton ("Help", this);
	connect (help, SIGNAL (clicked()), SLOT (showHelper()) );

	lb2 = new QLabel( this, "Label_2" );
	lb2->setText( "Constants:" );
	lb2->setAlignment( 289 );
	lb2->setMargin( -1 );

	lb3 = new QLabel( this, "Label_3" );
	lb3->setText( "Apply for i = " );
	lb3->setAlignment( 289 );
	lb3->setMargin( -1 );

	resize( 510, 235 );
	setMinimumSize (510, 235);
	
	formula->selectAll ();
	formula->setFocus ();
  }


void calculateWidget::saveFormulaData ()
  {
    fiData fd;
    
    fd.formula = formula->text ();
    fd.constants = constants->text ();
    fd.min = atoi ( min->text() );
    fd.max = atoi ( max->text() );

    // give him the adress of the struct
    myworksheet->writeFormulaData( &fd );
  }


calculateWidget::~calculateWidget ()
  {
    delete ok;   
    delete cancel;
    delete apply;
    delete help;
    delete min;
    delete max;
    delete lb1;
    delete lb2;
    delete lb3;
    delete lb4;
    delete formula;
    delete constants;
  }


void calculateWidget::resizeEvent (QResizeEvent*)
  {
    QSize sh = lb1->sizeHint ();

    lb1->setGeometry( 30, 25, sh.width ()+20, 25 );
    formula->setGeometry( 30+sh.width()+10, 25, width()-70-sh.width(), 25 );
    constants->setGeometry( 40+lb2->sizeHint().width(), 80, width()-90-160, height()-155 );
    cancel->setGeometry( width()-120, height()-85, 90, 25 );
    ok->setGeometry( width()-120, height()-155, 90, 25 );
    apply->setGeometry( width()-120, height()-120, 90, 25 );
    help->setGeometry ( width()-120, height()-50, 90, 25 );
    lb2->setGeometry( 25, 80, 65, 25 );
    lb3->setGeometry( 25, height()-50, 85, 25 );
    min->setGeometry( 140, height()-50, 70, 25 );
    lb4->setGeometry( 230, height()-50, 20, 25 );
    max->setGeometry( 255, height()-50, 70, 25 );
  }


void calculateWidget::calculateFormula ()
  {
    // if the formula is calculated the formula and constants will be saved...
    saveFormulaData ();
    
    int i, l1, l2, l;
    char s[255];

    // be careful with empty formula strings
    if (strlen (formula->text()) == 0) return;

	//
	// Formula version 0.3 and up can deal with whitespaces...
	// it cuts em off, even in variable names.
	//
	//    if (QString(formula->text()).contains (' ') )
	//      {
	//	QMessageBox::information (0, "Attention", "No whitespaces in formula allowed!");
	//	return;
	//      }
	//    
	//    if (constants->text().contains (' ') )
	//      {
	//	QMessageBox::information (0, "Attention", "No whitespaces in constants allowed!");
	//	return;
	//      }

    Formula f (formula->text ());

    int start = atoi (min->text ());
    int end = atoi (max->text ());

    if (constants->text().length() > 0) 
      {

	// appending a , at the end of myconsts makes it easier to find 
	// variables
	QString myconsts = constants->text () + QString (",");
	QString dummy1;
	
	//
	// cutting local variables out of the multi_line_edit
	//
	while (myconsts.length() > 0)
	  {
	    l1 = myconsts.find ('\n');
	    l2 = myconsts.find (',');
	    if ((l2 >= l1) && (l1 > 0)) l = l1;
	    else l = l2;
	    
	    // here working on - splitting into name and value
	    dummy1 = myconsts.left(l);
	    f.setLocalVariable ( Variable (dummy1.left (dummy1.find ('=')), 
		  atof (dummy1.right (dummy1.length()-dummy1.find ('=')-1)) ));
	    
	    myconsts = myconsts.right (myconsts.length()-l-1);
	    
	    // be careful: users might be bad or stupid
	    if (myconsts.find(',') == 0)
	      myconsts = myconsts.right(myconsts.length()-1);
	    if (myconsts.find('\n') == 0) 
	      myconsts = myconsts.right(myconsts.length()-1);
	    if (myconsts.find(',') == 0)
	      myconsts = myconsts.right(myconsts.length()-1);
	  }
      }
    // 
    // now starting to calculate
    //
	double ergebnis;
    for (i=start; i<=end; i++)
      {
        f.setLocalVariable ( Variable("i",i) );
		ergebnis = f();
		if (f.state() != 0) break;
		sprintf (s, "%g", ergebnis );
		T->setCell (col, i-1, s);
      }   

    //cout << "New Height: " << T->height () << endl;
    myworksheet->Tdata->resizeTableData (T->height(), T->width());
    myworksheet->TfiCol->resizeTableFirstColumn (T->height());

    myworksheet->repaint ();
  }


void calculateWidget::calculate ()          // SLOT (Accept button)
  {
    calculateFormula ();
    accept ();
  }


void calculateWidget::applyCalculate ()
  {
    calculateFormula ();
  }


void calculateWidget::showHelper ()
{
  KApplication::getKApplication()->invokeHTMLHelp ("korigin/formula.html","");
}

