#ifndef __RESULTWINDOW_H
#define __RESULTWINDOW_H


#include <qmlined.h>
#include <qpopmenu.h>


/**
 *  This class provides a MultiLineEdit where all fitting results will be
 *  given out. Only one resultWindow will be opened in korigin. This is done
 *  by KCentre. So, do not try to build a new instance. Just work with the
 *  public member functions.
 *
 */
class resultWindow : public QMultiLineEdit
{
Q_OBJECT

public:
  /**
   *  Constructor. Called by the KCentre constructor.
   */
  resultWindow (QWidget* parent=0, const char* name=0);

  /**
   *  Destructor. Called by the KCentre destructor.
   */
  ~resultWindow ();

public slots:
  /**
   *  This slot will be called by the session saving management function.
   *  It will write an entry like <result> blabla </result>.
   */
  void saveToDisk (QFile* f);

  /**
   *  Load the calculation results out of a korigin session file. Reads
   *  everything between <result> and </result> including the </result>-line
   *  but not the <result>-tag.
   */
  void loadFromDisk (QFile* f);

private slots:
  void saveResults ();
  void clearResults ();

protected:
  void mousePressEvent (QMouseEvent*);  

private:
  QPopupMenu* menu;
};



extern resultWindow* result;


#endif
