/***************************************************************************
                          bibview.h  -  description
                             -------------------
    begin                : Mit Dez 29 13:12:29 MET 1999
    copyright            : (C) 1999 by  Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef BIBVIEW_H
#define BIBVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qmultilinedit.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qwidget.h>
#include <qwidgetstack.h>

// include files for KDE

#include "btabctl.h"
#include <ktablistbox.h>

// application specific includes

#include "bdoclst.h"
#include "banzpar.h"
#include "bintpar.h"
#include "bnbrpar.h"
#include "blexpar.h"
#include "bdoclst.h"
#include "bhebinp.h"
#include "btextmatrix.h"
#include "bgradoc.h"


class BibDoc;

/** The BibView class provides the view widget for the BitanaApp instance.	
	* The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As BibView is part of the
	* docuement-view model, it needs a reference to the document object connected with it by the BitanaApp class to manipulate and display
	* the document structure provided by the BibDoc class.
 	* 	
 	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
 	*/
class BibView : public QWidget
{
  Q_OBJECT

public:
  /** Constructor for the main view */
  BibView(QWidget* parent = 0, const char* name=0);
  /** Destructor for the main view */
  ~BibView();

	/** Markiert Item - File und gibt Dokument aus */
	void markFileItem(QString);

	/** Parameter auslesen - setzen*/
	/** Anzeige */
	int lesAusBr();
	QString lesAbbWort();
	int lesAbbBeg();
	int lesAbbIntWeite();


	bool lesAnzAus();
	bool lesAnzDar();
	bool lesAnzAbb();
	bool lesAnzWordAna();

	void setAnzAus(bool);
	void setAnzDar(bool);
	void setAnzAbb(bool);
	void setAnzWordAna(bool);

	void setAusBr(int);
	void setAbbWort(QString);
	void setAbbBeg(int);
	void setAbbIntWeite(int);

	/** Intervall */
	QString lesIntWort();
	bool lesAnalyse();
	int lesRichtung();
	bool lesSortierung();
	int lesIntwVon();
	int lesIntwBis();

  void setIntWort(QString);
	void setAnalyse(bool);
	void setRichtung(int);
	void setSortierung(bool);
	void setIntwVon(int);
	void setIntwBis(int);

	/** Nachbar */
	QString* lesNbrWorte();
	void setNbrWort(int, QString);

	QStrList* lesInputStack();
	void setInputStack(QStrList *);

	/** returns a pointer to the document connected to the view instance. Mind that this method requires a BitanaApp instance as a parent
		* widget to get to the window document pointer by calling the BitanaApp::getDocument() method.
		*
		* @see BitanaApp#getDocument
		*/
	BibDoc* getDocument() const;
	
  /** contains the implementation for printing functionality */
	void print(QPrinter* m_pPrinter);
  /** toggles the main view between
   *  edit and only output view
	 */
  void toggleView();

	int tabSelected();
	void selectTab(int);	
	
	 /** Hebreew Input Widget */
  BHebInp* inp;
  /** Parameter Nachbarschaft */
  BNbrPar* nbr;
  /** Parameter Intervall */
  BIntPar* inv;
  /** Parameter Anzeige */
  BAnzPar* anz;
 	/** Lexika Browser */
	BLexPar* lex;
 /** Tabs Widget for parameters */
  BTabCtl* tab;
  /** Widget Ergebniskopfzeilen */
  QMultiLineEdit *dkop;
  /** Widget Ergebnistextlisten */
	QMultiLineEdit *dtxt;
  /** Widget Ergebnistabellen */
  KTabListBox* dtab;
	/**Widget Textmatrix */
	BTextMatrix *dmat;
	/** Widget Pictures */
	BGrafik *dpic;				

private:

	/** Ausgabe eines Ergebnisdokuments
		* in die entsprechenden Fenster
		*/
  bool showDoc(QString file);
  /** Widget Ergebnisdokumentenliste */
  BDocLst	*dlst;
	QWidgetStack	*docw;
	QSplitter *sh, *sv1;
	
  /** Eingabe-Layout */
  QHBoxLayout* hl1;
  /** Ausgabe-Layout */
  QHBoxLayout* hl2;
  /** Layout ohne Eingabeteil */
  QVBoxLayout* vl2;
  /** Layout mit Eingabeteil */
  QVBoxLayout* vl1;

public slots: // Public slots

  /** Ausgewaehltes Ergebnisdokument */
  void slotResDoc(QListViewItem *);
};

#endif // BIBVIEW_H









































































