/***************************************************************************
                          		bhebinp.h
                             -------------------
    begin                : Sun Jan 2 2000
    copyright            : (C) 2000 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BHEBINP_H
#define BHEBINP_H

#include <qwidget.h>
#include <qlined.h>
#include <qcombo.h>
#include <qstrlist.h>

// Layoutgren entspr. der Fontgre !


#define	HEB_BEG			224			// 1. Heb-Zeichen ALEPH
#define	BDI					35			// Buttondistance - Buttonabstand
#define BBO					10			// ButtonBoarder - Buttonrand	
#define	BSI					30			// Buttonsize - Buttongrsse

#define MAX_INP_LEN	64

/**Hebrew - Eingabehilfe
  *@author  Hans-Jrgen Schumann
  */
class BHebInp : public QWidget  {
   Q_OBJECT

public:

	BHebInp(QWidget *parent=0, const char *name=0);
	~BHebInp();

  /** Initialisierung */
  void init();
  /** Reading the Input */
  QString readInput();
	QStrList* liesInputStack();
	void setInputStack(QStrList*);

private:
	QComboBox *in;
	QStrList *inpstack;
	QString word;			// Wort zur Bearbeitung
	bool wmod;				// Wort gendert
  char c;

private slots:
  /** Tastendruck */
  void slotPressx(int sloti);
  /** Auswahl aus Liste */
  void slotNewWord(int item);

};

#endif

































