/***************************************************************************
                          bgrafiksatz.cpp  -  description
                             -------------------
    begin                : Mon Dec 27 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qfile.h>

#include "bgrafiksatz.h"
#include "bitana.h"

BGrafikSatz::BGrafikSatz()
{

}

BGrafikSatz::~BGrafikSatz()
{

}

void BGrafikSatz::setzFenster(int x, int y)
{
 fx=x;
 fy=y;
 pen=0;
 mx=1.0;
 my=1.0;
 kx=0;
 ky=0;
 sx1=35;
 sx2=fx-10;
 sy1=20;
 sy2=fy-50;
}

void BGrafikSatz::setzMassstab(int x1, int x2, int y1, int y2)
{
 vx=x1;
 bx=x2;
 vy=y1;
 by=y2;
 int v,b,dl;
 int i=0;
 while(i<2)
 {
  if(i==0)
  {
   v=x1;
   b=x2;
  }
  else
  {
   v=y1;
   b=y2;
  }
  if(v<0 && b<0 && b>v) dl=b-v;
  if(v<0 && b<0 && b<v) dl=v-b;
  if(v>=0 && b>0) dl=b-v;
  if(v<0 && b>=0) dl=abs(v)+b;
  if(v>=0 && b<0) dl=abs(b)+v;
  if(i==0)
  {
   mx=float(sx2-sx1)/float(dl);
   dlx=dl;
   if(x1!=0) kx=int(float(x1)*mx)*-1;
  }
  else
  {
   my=float(sy2-sy1)/float(dl);
   dly=dl;
   if(y1!=0) ky=int(float(y1)*my);
  }
  i++;
 }
}

void BGrafikSatz::zeichneSkala(char z, int f, QString bez)
{

 int a=TRUE;
 if(z=='X' || z=='x') a=FALSE;

// Make linie for scala
 pen=f;
 kz=3;
 if(a)
 {
  x1=sx1;
  y1=sy1;
  x2=sx1;
  y2=sy2;
 }
 else
 {
  x1=sx1;
  y1=sy2;
  x2=sx2;
  y2=sy2;
 }
 schreibSatz();
 if(a)
 {
  y2=y1;
  x2=sx1-10;
 }
 else
 {
  x1=x2;
  y2=sy2+10;
 }
 schreibSatz();

// Calculate line sequenz for sala
 int il=1;
 int sr=1;
 int dl=0;
 bool s=TRUE;
 if(a) dl=dly;
 else  dl=dlx;
 while((dl/il)>50)
 {
  il=il*sr;
  if(s) sr=2;
  else  sr=5;
  s=!s;
 }

// Set up scala
 int lx=0;
 int v=0;
 if(a) v=vy;
 else  v=vx;
 int an;
 if(v<0) an=10;
 else    an=0;
 while(v<lx)
 {
  lx=lx-il;
  an--;
  if(an==0) an=10;
 }
 while(lx<=v)
 {
  lx=lx+il;
  an++;
  if(an>10) an=0;
 }
 if(a) x1=sx1;
 else  y1=sy2;

// Load correction factor
 int k=0;
 if(a) k=ky;
 else  k=kx;

// Make scala
 QString num;
 int b=0;

 if(a) b=by;
 else  b=bx;
 while(lx<=b)
 {
  if(a)
  {
   y2=sy2-int(float(lx)*my);
   y2=y2+k;
  }
  else
  {
   x2=sx1+int(float(lx)*mx);
   x2=x2+k;
  }
  if(an<10)
  {
   if(a) x2=sx1-3;
   else  y2=sy2+3;
  }
  else
  {
   num=num.setNum(lx);
   if(a) grafikText(1,sx1-(num.length()*8)-6,y2+5,num);
   else  grafikText(1,x2-((num.length()*8)/2),sy2+20,num);
   kz=3;
   if(a) x2=sx1-6;
   else  y2=sy2+6;
   if(a) x1=sx1;
   else  y1=sy2;
   an=0;
  }
  if(a) y1=y2;
  else  x1=x2;
  pen=f;
  schreibSatz();
  lx=lx+il;
  an++;
 }

// Designator text for scala
 if(a) grafikText(1,2,sy1-8,bez);
 else  grafikText(1,sx2-int(bez.length()*8),sy2+35,bez);
}

bool BGrafikSatz::openDatei(QString name)
{
 extern BitanaApp *bitana;

 QDir d=QDir::root();
 if(d.cd(bitana->getTmpDir())) f1.setName(d.filePath(name));
 else
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("Cannot find the working directory\n")+bitana->getTmpDir());
  return false;
 }
 if (!f1.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Error"),
                          i18n("Cannot create the file\n")+bitana->getTmpDir()+name);
   return false;
 }

 pic.setDevice(&f1);
 return true;
}

void BGrafikSatz::closeDatei()
{
 f1.close();
}

void BGrafikSatz::setzFarbe(int f)
{
 kz=5;
 pen=f;
 schreibSatz();
}

void BGrafikSatz::schreibText(QString text)
{
 pic<<text<<endl;
}

void BGrafikSatz::grafikText(int f, int x, int y, QString text)
{
 kz=1;
 pen=f;
 x1=x;
 y1=y;
 zeile=text;
 schreibSatz();
}

void BGrafikSatz::malePunkt(int f, int x, int y)
{
 float z;

 pen=f;
 kz=2;
 z=mx*float(x);
 x1=sx1+int(z)+kx;
 z=my*float(y);
 y1=sy2-int(z)+ky;
 schreibSatz();
}

void BGrafikSatz::maleLinie(int f, int kx1, int ky1, int kx2, int ky2)
{
 float z;

 pen=f;
 kz=3;
 z=mx*float(kx1);
 x1=sx1+int(z)+kx;
 z=mx*float(kx2);
 x2=sx1+int(z)+kx;
 z=my*float(ky1);
 y1=sy2-int(z)+ky;
 z=my*float(ky2);
 y2=sy2-int(z)+ky;
 schreibSatz();
}

void BGrafikSatz::maleBalken(int f, int kx1, int ky1, int kx2, int ky2)
{
 float z;

 pen=f;
 kz=4;
 z=mx*float(kx1);
 x1=sx1+int(z)+kx;
 z=mx*float(kx2);
 x2=sx1+int(z)+kx;
 z=my*float(ky1);
 y1=sy2-int(z)+ky;
 z=my*float(ky2);
 y2=sy2-int(z)+ky;
 schreibSatz();
}

void BGrafikSatz::schreibSatz()
{
 QString tmp;
 QString STRSEP="\t";

 tmp.setNum(kz);
 pic<<tmp<<STRSEP;
 tmp.setNum(pen);
 pic<<tmp;
 if(kz<5)
 {
  pic<<STRSEP;
  tmp.setNum(x1);
  pic<<tmp<<STRSEP;
  tmp.setNum(y1);
  pic<<tmp;
  if(kz>1)
  {
   pic<<STRSEP;
   tmp.setNum(x2);
   pic<<tmp<<STRSEP;
   tmp.setNum(y2);
   pic<<tmp;
  }
  if(kz==1)
  {
   pic<<STRSEP<<zeile;
  }
 }
 pic<<endl;
}


































































