/***************************************************************************
                          ktoplevel.h  -  description
		This Class handles the top level window
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <stdio.h>
#include <kapp.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kwm.h>
#include <klocale.h>
#include <kstdaccel.h>
#include <ktmainwindow.h>
#include <ktopwidget.h>
#include <klocale.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qdialog.h>
#include <qsize.h>
#include <qpopmenu.h>
#include <qlayout.h>
#include <qkeycode.h>
#include <qaccel.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include "kshowvcard.h"
#include "kpreferences.h"

class TopLevel: public KTMainWindow
{
	Q_OBJECT

public:
	TopLevel(QWidget *parent=0, const char *name=0);
	virtual ~TopLevel();
//Showcard
	KShowvcard *Showvcard;
//Liste des fenetres
	static QList<TopLevel> windowList;  		
//Menu ToolBar KEdit
	void MenuInit();
	void ToolbarInit();
	void ShowInit();

public slots:

signals:
//File Menu
	void signal_ktoplevel_opencard();
	void signal_ktoplevel_importcards();
	void signal_ktoplevel_exportcards();
	void signal_ktoplevel_printcards();
	void signal_ktoplevel_savecards();
	void signal_ktoplevel_quitcard();

//Edit Menu
	void signal_ktoplevel_add();
	void signal_ktoplevel_del();
	void signal_ktoplevel_selectall();
	void signal_ktoplevel_unselectall();
	void signal_ktoplevel_invertselect();
	void signal_ktoplevel_preferences();

//ToolBar
	void signal_ktoplevel_show(int);
	
protected slots:
	void slot_ktoplevel_show_preferences();
	void slot_ktoplevel_show_all();
	void slot_ktoplevel_show_a_b();
	void slot_ktoplevel_show_c_d();
	void slot_ktoplevel_show_e_f();	
	void slot_ktoplevel_show_g_h();
	void slot_ktoplevel_show_i_j();
	void slot_ktoplevel_show_k_l();
	void slot_ktoplevel_show_m_n();
	void slot_ktoplevel_show_o_p();
	void slot_ktoplevel_show_q_r();
	void slot_ktoplevel_show_s_t();
	void slot_ktoplevel_show_u_v();
	void slot_ktoplevel_show_w_x();
	void slot_ktoplevel_show_y_z();
	
protected:

private:
//KFM connection
//    KFM			*kfm;
//Menu
	KMenuBar	*MainMenu;
  	QPopupMenu	*FileMenu;
  	QPopupMenu	*EditMenu;
	QPopupMenu	*HelpMenu;
//ToolBar
  	KToolBar	*ToolBar;
  	Preferences	*pref;
	
	int			file_open_card;
	int			file_import_card;
	int			file_export_card;
	int			file_print_card;
	int			file_save_cards;
	int			file_quit_card;
	int			editundo;
	int			editcut;
	int			editCopy;
	int			editSelectAll;
	int			editUnselectAll;
	int			editInvertSelection;
	int			editPreferences;
	int			help;
	int			Width;
};
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
