/***************************************************************************
                          kshowvcard.cpp  -  description
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <klocale.h>
#include <kapp.h>

#include <qprinter.h>
#include "kshowvcard.h"


KShowvcard::KShowvcard(KApplication *a, QWidget *_parent, const char *name) : QFrame(_parent, name)
{
	mykapp = a;
	parent = _parent;
	file_dialog=NULL;
	add_scrollbar();
	printer = new QPrinter;	
	QPainter PaintCards;
	normal	=	QColorGroup ( QColor( QRgb(10789024) ), QColor( QRgb(16777215) ), QColor( QRgb(16777215) ), QColor( QRgb(8421504) ), QColor( QRgb(10789024) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ) );
	select	=	QColorGroup ( QColor( QRgb(8421504) ), QColor( QRgb(8388608) ), QColor( QRgb(16777215) ), QColor( QRgb(8421504) ), QColor( QRgb(10789024) ), QColor( QRgb(16777215) ), QColor( QRgb(12632256) ) );
	active	=	QColorGroup ( QColor( QRgb(0) ), QColor( QRgb(12632256) ), QColor( QRgb(16777215) ), QColor( QRgb(8421504) ), QColor( QRgb(10789024) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ) );
	
	palette_normal = QPalette ( normal, select, active );
	palette_select = QPalette ( select, normal, active);
	palette_active = QPalette ( active, select, normal);
		
	this->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
/*	this->setPalette( palette_normal );*/
	this->setPalettePropagation(QWidget::SamePalette);
	this->show();

	connect(this, SIGNAL(signal_kshowvcard_quit()),mykapp,SLOT(quit()));	
        connect(_parent,SIGNAL(signal_ktoplevel_show(int)),this,SLOT(slot_kshowvcard_show(int)));
	list_cards.setAutoDelete(FALSE);
	posx_free=10;
	posy_free=10;
	free_card=0;
	int nb_col=0;
	decalage=0;
	cardnumber=0;
	appear=0;
}



KShowvcard::~KShowvcard()
{
}

void KShowvcard::slot_kshowvcard_show(int this_int)
{
emit signal_kshowvcard_show(this_int);
}

void KShowvcard::slot_kshowvcard_openfile()
{
}

void KShowvcard::slot_kshowvcard_importfiles()
{
}

void KShowvcard::slot_kshowvcard_exportfiles()
{
}

void KShowvcard::slot_kshowvcard_printcards()
{
if (printer->setup())
	{
	}
}

void KShowvcard::slot_kshowvcard_savefiles()
{
}

void KShowvcard::slot_kshowvcard_quitcard()
{
emit signal_kshowvcard_quit();
}

void KShowvcard::slot_kshowvcard_addcard()
{
QString nom_carte = i18n("New_Card_");
nom_carte+=convert_to_string(free_card);
//find_free_pos();
list_cards.append( new Kcard(mykapp, this,nom_carte,posx_free,posy_free,nom_carte,(int)list_cards.count()));
reorder_positions();
free_card++;
}

void KShowvcard::slot_kshowvcard_delcard()
{
emit signal_kshowvcard_whoselect();
}

void KShowvcard::slot_kshowvcard_selectall()
{
emit signal_kshowvcard_selectall();
}

void KShowvcard::slot_kshowvcard_unselectall()
{
emit signal_kshowvcard_unselectall();
}

void KShowvcard::slot_kshowvcard_invertselect()
{
emit signal_kshowvcard_invertselect();
}

void KShowvcard::slot_kshowvcard_ordercards()
{
//We are not using the inSort insertion procedure so we must ordercards
//The best way, i know to sort data is to use a sorting algorthim from
//the graph theory it's complexity is n*log2(n) so for 1024 cards
//it's complexity is k*10240 operations
}


void KShowvcard::slot_kshowvcard_reorder_positions()
{
reorder_positions();
}

void KShowvcard::add_scrollbar()
{
int pox,poy,poz,pok;

pox=this->frameGeometry().left();
poy=this->frameGeometry().top();
poz=this->frameGeometry().right();
pok=this->frameGeometry().bottom();
	ScrollBar = new QScrollBar(this,"ScrollBar");
	ScrollBar->setMinimumSize( 0, 0 );
	ScrollBar->setMaximumSize( 32767, 32767 );
	connect( ScrollBar, SIGNAL(nextLine()),			SLOT(slot_kshowvcard_nextline()) );
	connect( ScrollBar, SIGNAL(nextPage()),			SLOT(slot_kshowvcard_nextpage()) );
	connect( ScrollBar, SIGNAL(prevLine()),			SLOT(slot_kshowvcard_prevline()) );
	connect( ScrollBar, SIGNAL(prevPage()),			SLOT(slot_kshowvcard_prevpage()) );
	connect( ScrollBar, SIGNAL(sliderPressed()),	SLOT(slot_kshowvcard_sliderpressed()) );
	connect( ScrollBar, SIGNAL(sliderReleased()),	SLOT(slot_kshowvcard_sliderreleased()) );
	connect( ScrollBar, SIGNAL(sliderMoved(int)),	SLOT(slot_kshowvcard_slidermoved(int)) );
	connect( ScrollBar, SIGNAL(valueChanged(int)),	SLOT(slot_kshowvcard_valuechanged(int)) );
	ScrollBar->setFocusPolicy( QWidget::NoFocus );
	ScrollBar->setBackgroundMode( QWidget::PaletteMid );
	ScrollBar->setFontPropagation( QWidget::NoChildren );
	ScrollBar->setPalettePropagation( QWidget::NoChildren );
	ScrollBar->setOrientation( QScrollBar::Horizontal );
	ScrollBar->setRange( 0, 0 );
	ScrollBar->setSteps( 0, 0 );
	ScrollBar->setValue( 0 );
	ScrollBar->setTracking( TRUE );
	decalage=0;
}

void KShowvcard::slot_kshowvcard_slidermoved(int valeur)
{
decalage=valeur;
reorder_positions();
}

void KShowvcard::slot_kshowvcard_valuechanged(int valeur)
{

decalage=valeur;
reorder_positions();
}
void KShowvcard::slot_kshowvcard_nextline()
{
if (decalage<nb_col) decalage++;
reorder_positions();
}
void KShowvcard::slot_kshowvcard_nextpage()
{
if (decalage<nb_col) decalage++;
reorder_positions();
}
void KShowvcard::slot_kshowvcard_prevline()
{
if (decalage>0) decalage--;
reorder_positions();
}
void KShowvcard::slot_kshowvcard_prevpage()
{
if (decalage>0) decalage--;
reorder_positions();
}
void KShowvcard::slot_kshowvcard_sliderpressed()
{
reorder_positions();
}
void KShowvcard::slot_kshowvcard_sliderreleased()
{
reorder_positions();
}

void KShowvcard::resizeEvent(QResizeEvent *e)
{
int pox,poy,poz,pok;
pox=this->frameGeometry().left();
poy=this->frameGeometry().top();
poz=this->frameGeometry().right()-pox;
pok=this->frameGeometry().bottom()-poy-15;
ScrollBar->setGeometry(0,pok,poz,15);
reorder_positions();
}

QString KShowvcard::convert_to_string(int valeur)
{
QString text;
text+=(valeur%10)+48;
while ((valeur/10)>0)
	{
	valeur=valeur/10;
	text.insert(0,((valeur%10)+48));
	}
return text;
}

void KShowvcard::slot_kshowvcard_removeselect(int me)
{
list_cards.remove(me);
emit signal_kshowvcard_delcard(me);
decalage=0;
reorder_positions();
}

void KShowvcard::find_free_pos()
{
int pox,poy,poz,pok;
int x1_card,y1_card,x2_card,y2_card;
pox=this->frameGeometry().left();
poy=this->frameGeometry().top();
poz=this->frameGeometry().right();
pok=this->frameGeometry().bottom()-15;
int number_cards=(int)list_cards.count();
int temp;

temp=decalage;
decalage=0;
reorder_positions();

if (number_cards==0)
	{
	posx_free=10;
	posy_free=10;
	}
else
	{
	//get position and size of the last card
	if (posy_free+70>(pok-poy))
		{
		//if last line full start a new line
		posy_free=10;
		posx_free+=120;
		}
	else
		{
		posy_free+=30;
		}
	}
decalage=temp;
reorder_positions();
}

void KShowvcard::reorder_positions()
{
int pox,poy,poz,pok;
int x1_card,y1_card,x2_card,y2_card,wc,hc;
pox=this->frameGeometry().left();
poy=this->frameGeometry().top();
poz=this->frameGeometry().right();
pok=this->frameGeometry().bottom()-15;
int number_cards=(int)list_cards.count();
nb_col=0;

if (number_cards==0)
	{
	posx_free=10;
	posy_free=10;
	ScrollBar->setRange(0,0);		
	}
else
	{
slot_kshowvcard_ordercards();
	posx_free=10;
	posy_free=10;
	list_cards.first();

	x1_card=list_cards.first()->x();
	y1_card=list_cards.first()->y();
	x2_card=x1_card+list_cards.first()->width();
	y2_card=y1_card+list_cards.first()->height();
	
	wc=x2_card-x1_card;
	hc=y2_card-y1_card;
	list_cards.first()->setGeometry(posx_free-(decalage*110),posy_free,list_cards.current()->width(),list_cards.current()->height());
	
	if ((pok-poy<50) || (poz-pox<110))
		{
		list_cards.first()->hide();
		}
	else
		{
		list_cards.first()->show();
		}
	if (list_cards.first()->hidden==false)
	{	
	posx_free=10;
	posy_free=10+list_cards.current()->height();
	}
	else
	{
	posx_free=10;
        posy_free=0;
	list_cards.current()->hide();
	}
	while(list_cards.next()!=NULL)
		{
		if ((pok-poy<50) || (poz-pox<110))
			{
			list_cards.current()->hide();
			}
		else
			{
			if (list_cards.current()->hidden==true) {list_cards.current()->hide();}
			else{
			x1_card=list_cards.current()->x();
			y1_card=list_cards.current()->y();
			x2_card=x1_card+list_cards.current()->width();
			y2_card=y1_card+list_cards.current()->height();
			wc=x2_card-x1_card;
			hc=y2_card-y1_card;
			if (posy_free+15+list_cards.current()->height()>(pok-poy))
				{
				posy_free=10;
				posx_free+=wc+10;
				nb_col++;
				list_cards.current()->setGeometry(posx_free-(decalage*110),posy_free,list_cards.current()->width(),list_cards.current()->height());
				posy_free+=list_cards.current()->height();
				}
			else
				{
				posy_free+=list_cards.current()->height()+10;
				list_cards.current()->setGeometry(posx_free-(decalage*110),posy_free-list_cards.current()->height(),list_cards.current()->width(),list_cards.current()->height());
				}

			if ( ( ((posx_free+wc)-(pok-poy)) <0) || ( ((posy_free+hc)-(poz-pox)) <0) )
				{
				list_cards.current()->show();
				}
			else
				{
				list_cards.current()->show();
				ScrollBar->setRange(0,0);
				ScrollBar->setSteps(0,0);
				}
			}//fin du if hidden==false
			}
		}
		ScrollBar->setRange(0,nb_col);
		ScrollBar->setSteps( 1, 1 );
		ScrollBar->setRange(0,nb_col);		
	}
}
	
void KShowvcard::slot_kshowvcard_mousedcgevent(int this_int,QString this_string)
{
cardnumber=this_int;
slot_internal(1,this_string);
//emit signal_kshowvcard_tabgeneral(1,this_string);
}
void KShowvcard::slot_kshowvcard_mousedcdevent(int this_int,QString this_string)
{
cardnumber=this_int;
slot_internal(2,this_string);
//emit signal_kshowvcard_tabdetails(2,this_string);

}
void KShowvcard::slot_kshowvcard_mousedceevent(int this_int,QString this_string)
{
cardnumber=this_int;
slot_internal(3,this_string);
//emit signal_kshowvcard_tabextensions(3,this_string);
}

void KShowvcard::slot_kshowvcard_receivegeneral(QString this_string)
{
emit signal_kshowvcard_kcardgeneral(cardnumber,this_string);
}
void KShowvcard::slot_kshowvcard_receivedetails(QString this_string)
{
emit signal_kshowvcard_kcarddetails(cardnumber,this_string);
}
void KShowvcard::slot_kshowvcard_receiveextensions(QString this_string)
{
emit signal_kshowvcard_kcardextensions(cardnumber,this_string);
}

void KShowvcard::slot_internal(int this_int,QString this_string)
{
if (this_int==1) String_General=this_string;
if (this_int==2) String_Details=this_string;
if (this_int==3) String_Extensions=this_string;

appear++;
if (appear==3)
	{
	Complete_Data = new TabData(mykapp,this,"TabData");
	connect(this,SIGNAL(signal_kshowvcard_tabgeneral(QString)),	Complete_Data,SLOT(slot_tabdata_receivegeneral(QString)));
	connect(this,SIGNAL(signal_kshowvcard_tabdetails(QString)),	Complete_Data,SLOT(slot_tabdata_receivedetails(QString)));
	connect(this,SIGNAL(signal_kshowvcard_tabextensions(QString)),	Complete_Data,SLOT(slot_tabdata_receiveextensions(QString)));		
	connect(Complete_Data, SIGNAL(signal_tabdata_updategeneral(QString)), this, SLOT(slot_kshowvcard_receivegeneral(QString)));
	connect(Complete_Data, SIGNAL(signal_tabdata_updatedetails(QString)), this, SLOT(slot_kshowvcard_receivedetails(QString)));
	connect(Complete_Data, SIGNAL(signal_tabdata_updateextensions(QString)), this, SLOT(slot_kshowvcard_receiveextensions(QString)));	
	emit signal_kshowvcard_tabgeneral(String_General);
	emit signal_kshowvcard_tabdetails(String_Details);
	emit signal_kshowvcard_tabextensions(String_Extensions);
	Complete_Data->show();
	delete(Complete_Data);
	appear=0;
	}
else
	{
	}
}
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
