/***************************************************************************
                          NameData.h  -  description
			This Class handles the Name Data fields
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <qdialog.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <kwizard.h>

class NameData : public KDialog
{
    Q_OBJECT

public:

    NameData
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~NameData();

signals:
	void signal_namedata_apply(QString);

public slots:
	void Load(QString);

protected slots:

    virtual void Name_Cancel();
    virtual void Last_Name(const char*);
    virtual void Validate_Last_Name();
    virtual void Title(int);
    virtual void Validate_Suffix(int);
    virtual void Name_OK();
    virtual void Suffix(int);
    virtual void Second_Name(const char*);
    virtual void Validate_Title(int);
    virtual void Validate_Second_Name();
    virtual void First_Name(const char*);
    virtual void Validate_First_Name();

protected:
	QString	String;
	QLineEdit *LineEdit_First_Name;
	QLineEdit *LineEdit_Second_Name;
	QLineEdit *LineEdit_Last_Name;
	QLabel *Label_Title;
	QLabel *Label_First_Name;
	QLabel *Label_Second_Name;
	QLabel *Label_Last_Name;
	QLabel *Label_Suffix;
	QComboBox *ComboBox_Title;
	QComboBox *ComboBox_Suffix;
	QPushButton *PushButton_Validate;
	QPushButton *PushButton_Cancel;
	int	index_title, index_suffix;
};
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
