/***************************************************************************
                          ExtensionsData.h  -  description
		This Class handles the Extensions Data fields and Tab
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qwidget.h>
#include <qstring.h>
#include <kwizard.h>
#include "OtherExtension.h"
#include "stdio.h"
#define MAX_EXTENSIONS 3

class ExtensionsData : public QWidget
{

    Q_OBJECT

public:

    ExtensionsData
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~ExtensionsData();

signals:
	void signal_extensionsdata_apply(QString);

public slots:
	void slot_extensionsdata_receiveextensions(QString);

protected slots:

    virtual void slot_extensions_fetch();
    virtual void slot_extensions_modifyimage();
    virtual void slot_extensions_modifyother();
    virtual void slot_extensions_soundplay();
    virtual void slot_extensions_modifysound();
    virtual void slot_extensions_soundstop();
	void slot_extensionsdata_apply();
	
protected:
	QPushButton *PushButton_Fetch;
	QPushButton *PushButton_Modifyimage;
	QPushButton *PushButton_Modifysound;
	QPushButton *PushButton_Modifyother;
	QPushButton *PushButton_Soundplay;
	QPushButton *PushButton_Soundstop;
	QLabel *Label_Photoinfo;
	QLabel *Label_Soundinfo;
	QButtonGroup *ButtonGroup_Other;
	QButtonGroup *ButtonGroup_Sound;
	QButtonGroup *ButtonGroup_Photo;
	OtherExtension *Other_Extension;
	QString	Strings;
};
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
