/* stockdata.h
 * 
 * Andreas Wst
 *
 */ 

#ifndef STOCKDATA_H
#define STOCKDATA_H

#include <qpushbutton.h>
#include <qpopupmenu.h>
#include <qlistview.h>
#include <qframe.h>
#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>
#include <qregexp.h>

#include <kmsgbox.h>

#include "stock.h"
#include "structs.h"
  
class StockData : public QWidget
{
  Q_OBJECT

public :

  StockData (QWidget *, const char *);
  ~StockData ();

public slots :

  // startet browser mit entsprechender seite
  void startBrowser (int);

  // stock news at zacks
  void openBrowserWithZacks ();

  // Stock quotes cnnfn
  void openBrowserWithCNNFN ();

  // CBS Market Watch -> NEWS
  void openBrowserWithCBSMarketWatchNews ();

  // CBS Market Watch -> HOME
  void openBrowserWithCBSMarketWatchHome ();

  // YAHOO GRADES 
  void openBrowserWithYahooGrades ();

  // QUICKEN HOME 
  void openBrowserWithQuickenQuote ();

  // QUICKEN SNAPSHOT
  void openBrowserWithQuickenSnapshot ();

  // YAHOO HOME -> Netscape mit auf Krzelseite ffnen
  void openBrowserWithYahooHome ();

  // popup dialog fr aktien in listview
  void openPopupInListView (QListViewItem *, const QPoint &, int);

protected:

  struct CONFIGURATION_DATA config_data;

  Stock *currentStock;
  QPopupMenu *popyahoo, *popcbs, *popquicken, *popup;
 

};

#endif
