/* stock.h
 *
 * Klassendefinition der Aktie
 * 
 */


#include <stdio.h>

#ifndef STOCK_H
#define STOCK_H

enum STOCK_STATUS { OK, KILLED };

class Stock
{

public:
  
  Stock (int anz = 0, char *s=0, char *wkn=0, double kaufkurs=0);
  ~Stock ();

  // Funktionen zum verndern und lesen von Eigenschaften
  int getAnzahl ();
  double getAktKurs ();
  double getKaufKurs ();
  char * getName ();
  char * getWKN ();
  char * getLogo ();
  char * getKurzel ();
  double getGesamtWert ();
  double gewinnProzent ();
  double gewinnEuro ();
  int getStatus ();

  void setName (char *);
  void setWKN (char *);
  void setLogo (char *);
  void setKurzel (char *);
  void setKaufKurs (double);
  void setAktKurs (double);
  void setAnzahl (int);
  void setStatus (int);

  // Mischkurs zweier Aktien berechnen
  void mergeStocks (Stock);


protected:

  // Variablen, die einzelne Position beschreiben  
  int anzahl;
  char name [50], wkn [8], logo [20], kurzel [10];
  double kaufkurs;
  double aktkurs;
  double gewinnproz;
  double gewinndm;
  STOCK_STATUS status;

  
};

#endif // Stock
    

