


#include "stock.h"


Stock::Stock (int anz = 0, char *s=0, char *wk=0, double kauf) : anzahl (anz),
              kaufkurs (kauf), aktkurs (kauf)
{
  strcpy (name, s);
  strcpy (wkn, wk);
  fprintf (stderr, "%s", name);
}


Stock::~Stock () 
{
}

int Stock::getAnzahl ()
{
  return (anzahl);
}

double Stock::getAktKurs ()
{
  return (aktkurs);
}

double Stock::getKaufKurs ()
{
  return (kaufkurs);
}

char * Stock::getName ()
{
  return name; 
}

char * Stock::getWKN ()
{
  return wkn;
}

double Stock::getGesamtWert ()
{
  return (anzahl * aktkurs);
}

double Stock::gewinnProzent ()
{
  return (aktkurs * 100 / kaufkurs - 100);
}

double Stock::gewinnEuro ()
{
  return ((aktkurs - kaufkurs) * anzahl);
}

void Stock::setName (char *s)
{
  strcpy (name, s);
}

void Stock::setWKN (char *s)
{
  strcpy (wkn, s);
}

void Stock::setKaufKurs (double k)
{
  kaufkurs = k;
}

void Stock::setAktKurs (double k)
{
  aktkurs = k;
}

void Stock::setAnzahl (int a)
{
  anzahl = a;
}

void Stock::mergeStocks (Stock s)
{
  fprintf (stderr, "in mergeStocks");
  // Gesamtwert
  double summe = s.getAnzahl () * s.getKaufKurs () + anzahl * kaufkurs;

  anzahl = s.getAnzahl () + anzahl;
  kaufkurs = summe / anzahl;
  aktkurs = kaufkurs;
  fprintf (stderr, "ende mergeStocks");
}

void Stock::setLogo (char *s)
{
  strcpy (logo, s);
}

char * Stock::getLogo ()
{
  return logo;
}

void Stock::setStatus (int s)
{
  status = (STOCK_STATUS) s;
}

int Stock::getStatus ()
{
  return (int) status;
}

void Stock::setKurzel (char *k)
{
  strcpy (kurzel, k);
}

char * Stock::getKurzel ()
{
  return kurzel;
}
