
#include <qwidget.h>
#include <qpixmap.h>
#include <qimage.h>
#include <kapp.h>
#include <kwm.h>
#include "kimgio/kimgio.h"

#include <unistd.h>
#include <time.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <X11/extensions/shape.h>

void mainloop();
static void win (char *p);
static void quit (char *p);
static void prnt (char *p);

static struct {
	char *verb;
	void (*cb) (char *);
} plugin_cmds[] = {
    {"WIN", win},
    {"QUIT", quit},
    {"PRNT", prnt},
    { NULL, NULL }
};

QPixmap *pixmap;

int main (int argc, char **argv)
{
    KApplication app(argc, argv);
    QWidget widget;
    pixmap = new QPixmap;
    
    if (argc < 2){
        printf("501 Bogus command line\n");
        return (0);
    }
    kimgioRegister();
    if(pixmap->load(argv[argc-1]) == false){
        return (0);
    }
    widget.setBackgroundPixmap(*pixmap);
    widget.resize(pixmap->size());
    app.setMainWidget(&widget);
    KWM::doNotManage(widget.winId());
    widget.show();
    mainloop();
    return(1);
}

void mainloop()
{
    KApplication *app = KApplication::getKApplication();
    int fid  = fileno(stdin);

    printf("220 Image plugin\n");
    fflush(stdout);
    
    // QT doesn't support async I/O!
    fcntl(fid, F_SETFL, O_NONBLOCK);
    while(1){
        char b[1024], *p;
        int i, n;
        if ((n = read(fid, b, 1020)) == -1){
            app->processEvents(1000);
        }
        else{
            b[n] = '\0';
            if ((p = strchr(b, '\n')) == NULL) {
		printf("501 Incomplete command\n");
		fflush(stdout);
            }
            *p = '\0';
            for (i = 0; plugin_cmds[i].verb; i++) {
		if (!strncmp(b, plugin_cmds[i].verb,
                             strlen(plugin_cmds[i].verb)))
                    break;
            }
            if (plugin_cmds[i].verb)
                (*plugin_cmds[i].cb) (b + strlen(plugin_cmds[i].verb));
            else
		printf("500 What are you talking about\n");
            fflush(stdout);
        }
    }
}

static void win (char *p)
{
    printf("250 %lx\n", (unsigned long)KApplication::getKApplication()->
           mainWidget()->winId());
}

static void quit (char *p)
{
	printf("221 Over and out\n");
	exit(0);
}

// We have to due this ourselves unless someone can tell me how to make
// QPrinter take a file handle...
static void prnt (char *p)
{
    QImage img = pixmap->convertToImage();
    QRgb color;
    int x, y, col;
    int w = img.width();
    int h = img.height();
    //int d = img.depth();
    int d = 8;
    time_t t;

    printf("200 Postscript coming right up\n");
    /* print postscript preblurb */
    printf("%%!PS-Adobe-2.0 EPSF-2.0\n");
    printf("%%%%Creator: Image plugin for Siag Office\n");
    printf("%%%%Title: Plugged in image\n");
    printf("%%%%Pages: 1\n");
    printf("%%%%BoundingBox: %d %d %d %d\n", 0, 0, w, h);
    t = time(NULL);
    printf("%%%%CreationDate: %s\n", ctime(&t));
    printf("%%%%EndComments\n");
    printf("%%%%EndProlog\n");
    printf("%%%%Page: 1 1\n\n\n");
    printf("gsave\n\n");
    printf("/inch {72 mul} def\n");
    printf("%d %d scale\n", w, h);
    printf("/line %d string def\n", 3*w);
    printf("%d %d %d\n", w, h, d);
    printf("[ %d %d %d %d %d %d ]\n", w, 0, 0, -h, 0, h);
    printf("{currentfile line readhexstring pop}\n");
    printf("false 3 colorimage\n");

    /* print all the pixels */
    col = 0;
    for (y = 0; y < h; y++) {
        for (x = 0; x < w; x++) {
            color = img.pixel(x, y);
            printf("%02hx%02hx%02hx", qRed(color), qGreen(color),
                   qBlue(color));
            col += 6;
            if (col >= 72) {
                printf("\n");
                col = 0;
	    }
	}
    }
    if (col) printf("\n");

    /* print postscript postblurb */
    printf("%%\n\n");
    printf("grestore\n");
    printf("%%%%Trailer\n");
}
    
    
    
