// The toplevel widget. A few methods were added for Siag's scheme menus and
// such.

#include <kapp.h>
#include <kiconloader.h>
#include <qlabel.h>
#include "ksiag_app.h"
#include "ksiag_toplevel.h"
#include "kseparator.h"

KSiagTopLevel::KSiagTopLevel (window *w, const char *name)
    : KTMainWindow (name)
{

    int i;
    KIconLoader *ldr = KApplication::getKApplication()->getIconLoader();
    KSiagToolBarReceiver *toolreceiver = new KSiagToolBarReceiver;
    tblview = new KSiagTableView(w, this);
    setView (tblview);

    // Menus are populated by the table manager. We just allocate the popups
    // and set the Menubar names.
    KMenuBar *menu = menuBar();
    for (i=0; i <= ID_MENU_SHORTCUTS; ++i)
        menus[i] = new KSiagPopupMenu;
    for (i=0; i < ID_MENU_HELP; ++i)
        menu->insertItem(KSiagApp::manager()->menuName(i), menus[i]);
    menu->insertSeparator();
    menu->insertItem("Help", menus[ID_MENU_HELP]);

    // Top toolbar...
    toolBar(0)->insertButton (ldr->loadIcon ("filenew.xpm"), ID_TB_NEW,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (newFile()), true,
                              "Start another instance of Siag");
    toolBar(0)->insertButton (ldr->loadIcon ("fileopen.xpm"), ID_TB_OPEN,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (open()), true,
                              "Open a Siag document");
    toolBar(0)->insertButton (ldr->loadIcon ("filefloppy.xpm"), ID_TB_SAVE,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (save()), true,
                              "Save the current spreadsheet");
    toolBar(0)->insertButton (ldr->loadIcon ("kpreview.xpm"), ID_TB_PREVIEW,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (preview()), true,
                              "Preview the current spreadsheet");
    toolBar(0)->insertButton (ldr->loadIcon ("fileprint.xpm"), ID_TB_PRINT,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (print()), true,
                              "Print the current spreadsheet");
    toolBar(0)->insertWidget(5000, 3, new KSeparator(QFrame::VLine, toolBar(0)));
    toolBar(0)->insertButton (ldr->loadIcon ("cut.xpm"), ID_TB_CUT,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (cut()), true,
                              "Cut block");
    toolBar(0)->insertButton (ldr->loadIcon ("copy.xpm"), ID_TB_COPY,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (copy()), true,
                              "Copy block");
    toolBar(0)->insertButton (ldr->loadIcon ("paste.xpm"), ID_TB_PASTE,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (paste()), true,
                              "Paste block");
    toolBar(0)->insertWidget(5001, 3, new KSeparator(QFrame::VLine, toolBar(0)));
    toolBar(0)->insertButton (ldr->loadIcon ("borders.xpm"), ID_TB_BORDER,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (borders()), true,
                              "Draw borders around the block");
    toolBar(0)->insertButton (ldr->loadIcon ("grid.xpm"), ID_TB_GRID,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (grid()), true,
                              "Draw grid lines in the block");
    toolBar(0)->insertButton (ldr->loadIcon ("uline.xpm"), ID_TB_ULINE,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (underline()), true,
                              "Underline the block");
    toolBar(0)->insertButton (ldr->loadIcon ("none.xpm"), ID_TB_NOGRID,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (none()), true,
                              "Remove grid lines from the block");
    toolBar(0)->insertWidget(5002, 3, new KSeparator(QFrame::VLine, toolBar(0)));
    toolBar(0)->insertButton (ldr->loadIcon ("sigma.xpm"), ID_TB_SIGMA,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (sigma()), true,
                              "Add the contents of the block");
    toolBar(0)->insertButton (ldr->loadIcon ("plotter.xpm"), ID_TB_PLOT,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (plot()), true,
                              "Plot the contents of the block using lines");
    toolBar(0)->insertButton (ldr->loadIcon ("funcwizard.xpm"), ID_TB_FWIZ,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (fwizard()), true,
                              "Run the function wizard");
    toolBar(0)->insertWidget(5003, 3, new KSeparator(QFrame::VLine, toolBar(0)));
    // Middle toolbar
    toolBar(1)->insertCombo ((char *)(0), ID_TB_FONT_COMBO, false, SIGNAL(activated(int)),
                            toolreceiver, SLOT(fontComboActivated(int)), true,
                            "Change the font family");
    KCombo *tmpcombo = toolBar(1)->getCombo (ID_TB_FONT_COMBO);
    tmpcombo->resize (150, tmpcombo->height());
    tmpcombo->insertItem ("Courier");
    tmpcombo->insertItem ("Helvetica");
    tmpcombo->insertItem ("New Century Schoolbook");
    tmpcombo->insertItem ("Times");

    toolBar(1)->insertCombo ((char *)(0), ID_TB_SIZE_COMBO, false, SIGNAL(activated(int)),
                            toolreceiver, SLOT(sizeComboActivated(int)), true,
                            "Change the font size");
    tmpcombo = toolBar(1)->getCombo (ID_TB_SIZE_COMBO);
    tmpcombo->resize (50, tmpcombo->height());
    tmpcombo->insertItem ("8");
    tmpcombo->insertItem ("10");
    tmpcombo->insertItem ("12");
    tmpcombo->insertItem ("14");
    tmpcombo->insertItem ("18");
    tmpcombo->insertItem ("24");
    tmpcombo->insertItem ("20");
    tmpcombo->insertItem ("30");

    toolBar(1)->insertCombo ((char *)(0), ID_TB_TYPE_COMBO, false, SIGNAL(activated(int)),
                            toolreceiver, SLOT(typeComboActivated(int)), true,
                            "Change the display style");
    tmpcombo = toolBar(1)->getCombo (ID_TB_TYPE_COMBO);
    tmpcombo->resize (100, tmpcombo->height());
    tmpcombo->insertItem ("Default");
    tmpcombo->insertItem ("Invisible");
    tmpcombo->insertItem ("Integer");
    tmpcombo->insertItem ("Scientific");
    tmpcombo->insertItem ("Fixed");
    tmpcombo->insertItem ("Date");
    tmpcombo->insertItem ("Time");
    tmpcombo->insertItem ("Time Difference");
    tmpcombo->insertItem ("Percent");
    tmpcombo->insertItem ("Hex");
    tmpcombo->insertItem ("Currency");
    tmpcombo->insertItem ("User 1");
    tmpcombo->insertItem ("User 2");
    tmpcombo->insertItem ("User 3");
    tmpcombo->insertItem ("User 4");
    tmpcombo->insertItem ("User 5");


    toolBar(1)->insertCombo ((char *)(0), ID_TB_COLOR_COMBO, false, SIGNAL(activated(int)),
                            toolreceiver, SLOT(colorComboActivated(int)), true,
                            "Change the color");
    tmpcombo = toolBar(1)->getCombo (ID_TB_COLOR_COMBO);
    tmpcombo->resize (90, tmpcombo->height());
    tmpcombo->insertItem ("Black");
    tmpcombo->insertItem ("Red");
    tmpcombo->insertItem ("Green");
    tmpcombo->insertItem ("Blue");
    tmpcombo->insertItem ("Yellow");
    tmpcombo->insertItem ("Magenta");
    tmpcombo->insertItem ("Cyan");
    tmpcombo->insertItem ("White");

    toolBar(1)->insertButton (ldr->loadIcon ("bold.xpm"), ID_TB_BOLD,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (bold()), true,
                              "Bold text");
    toolBar(1)->setToggle(ID_TB_BOLD, true);
    toolBar(1)->insertButton (ldr->loadIcon ("italic.xpm"), ID_TB_ITALIC,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (italic()), true,
                              "Italic text");
    toolBar(1)->setToggle(ID_TB_ITALIC, true);
    toolBar(1)->insertButton (ldr->loadIcon ("hleft.xpm"), ID_TB_LEFT,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (leftJustify()), true,
                              "Left adjusted text");
    toolBar(1)->setToggle(ID_TB_LEFT, true);
    toolBar(1)->insertButton (ldr->loadIcon ("hcenter.xpm"), ID_TB_CENTER,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (centerJustify()), true,
                              "Centered text");
    toolBar(1)->setToggle(ID_TB_CENTER, true);
    toolBar(1)->insertButton (ldr->loadIcon ("hright.xpm"), ID_TB_RIGHT,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (rightJustify()), true,
                              "Right adjusted text");
    toolBar(1)->setToggle(ID_TB_RIGHT, true);

    // Last toolbar
    input_label = new QLabel (toolBar(2));
    input_label->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    toolBar(2)->insertWidget (ID_TB_LABEL, 90, input_label);

    input_line = new KSiagLineEdit (toolBar(2));

    toolBar(2)->insertButton (ldr->loadIcon ("dump.xpm"), ID_TB_DUMP,
                              SIGNAL(clicked()), input_line,
                              SLOT (cancel()), true,
                              "Discard the current edit");
    toolBar(2)->insertButton (ldr->loadIcon ("enter.xpm"), ID_TB_ENTER,
                              SIGNAL(clicked()), input_line,
                              SLOT (done()), true,
                              "Accept the current edit");
    toolBar(2)->insertButton (ldr->loadIcon ("help.xpm"), ID_TB_HELP,
                              SIGNAL(clicked()), toolreceiver,
                              SLOT (info()), true,
                              "Display the Siag online documentation");

    toolBar(2)->insertWidget (ID_TB_LINED, 1, input_line);
    toolBar(2)->setItemAutoSized (ID_TB_LINED);

    // Status bar
    stbar = statusBar();
    stbar->insertItem("             ", ID_STATUS_TYPE);
    stbar->insertItem (" ", ID_STATUS_MSG);

    connect(toolreceiver, SIGNAL(update()), tblview->table(),
            SLOT(updateCursor()));

    // Other toplevel windows
}

KSiagTopLevel::~KSiagTopLevel ()
{
    ;
}


void KSiagTopLevel::updateMenus(KSiagPopupMenu **menulist)
{
    int i;

    for (i=0; i <= ID_MENU_SHORTCUTS; ++i)
        menus[i]->copy(menulist[i]);
}

KSiagPopupMenu* KSiagTopLevel::menuAt(int index) const
{
    return(menus[index]);
}

void KSiagTopLevel::closeEvent (QCloseEvent *ev)
{
    ev->ignore();
    emit closeWindow(tblview->table()->siagWindow());
}

bool KSiagTopLevel::queryExit()
{
    return (0);
}

void KSiagTopLevel::activateShortcuts(const QPoint &pos)
{
    menus[ID_MENU_SHORTCUTS]->popup(pos);
}

void KSiagTopLevel::updateControls()
{
    window *w = tblview->table()->siagWindow();
    long row = w->point_pos.row;
    long col = w->point_pos.col;
    int fmt = ret_format(w->buf, row, col);
    KToolBar *tb = toolBar(1);

    tb->setButton(ID_TB_BOLD, fmt & BOLD);
    tb->setButton(ID_TB_ITALIC, fmt & ITALIC);
    tb->getCombo(ID_TB_TYPE_COMBO)->setCurrentItem((fmt & FMT_MASK)
                                                   >> FMT_SHIFT);
    tb->getCombo(ID_TB_SIZE_COMBO)->setCurrentItem(fmt & SIZE_MASK);
    fmt = fmt & HADJ_MASK;
    tb->setButton(ID_TB_LEFT, fmt == HADJ_LEFT);
    tb->setButton(ID_TB_CENTER, fmt == HADJ_CENTER);
    tb->setButton(ID_TB_RIGHT, fmt == HADJ_RIGHT);
    int fontidx = (ret_font(w->buf, row, col) & FONT_MASK) >> FONT_SHIFT;
    tb->getCombo(ID_TB_FONT_COMBO)->setCurrentItem(fontidx);
    tb->getCombo(ID_TB_COLOR_COMBO)->
        setCurrentItem(ret_color(w->buf, row, col));
}

