
#ifndef __KSIAGTABLE_H
#define __KSIAGTABLE_H

/**
 * This is the base Siag table class. It is more or less intended just to
 * handle table painting. Siag does the rest. Table decorations are provided
 * by KSiagTableView. Sorry about all the inlines making protected stuff
 * public, but the Siag callbacks need access and cannot be methods...
 */

#include <qtableview.h>
#include <qcolor.h>
#include <qpainter.h>
#include <stdio.h>

#include "../siag/types.h"
#include "../siag/calc.h"
#include "../common/fonts.h"
#include "siagcallbacks.h"

class KSiagTable : public QTableView
{
    Q_OBJECT
friend class KSiagHorizHeader;
friend class KSiagVertHeader;
friend class KSiagTableView;
friend class KSiagCellEdit;
public:
    KSiagTable (window *win, QWidget *parent=0, const char *name=0);
    ~KSiagTable();
    window* siagWindow();
    // We need the following for siagcallbacks.cpp. I'm not sure
    // why these are protected and not public in the first place...
    bool rowYPos (int row, int *pos){return(QTableView::rowYPos(row, pos));}
    bool colXPos (int col, int *pos){return(QTableView::colXPos(col, pos));}
    int cellWidth(int col);
    int cellHeight(int row);
    void resetBuffer();
public slots:
    void setCursor();
    void newBlock();
    void updateBlock (position blku, position blkl);
    void updateCursor(){updateCell(cur_row, cur_col);}
signals:
    void activated(window *w);
    void scrollHorizontal(int leftcell);
    void scrollVertical(int topcell);
    void blockChanged(window *w);
    void cursorChanged(window *w);
protected:
    int totalWidth ();
    int totalHeight();
    void paintCell (QPainter *p, int row, int col);
    virtual void paintEvent (QPaintEvent *ev);
    virtual void keyPressEvent (QKeyEvent *ev);
    virtual void keyReleaseEvent (QKeyEvent *ev);
    virtual void mousePressEvent (QMouseEvent *ev);
    virtual void mouseDoubleClickEvent (QMouseEvent *ev);
    virtual void mouseMoveEvent (QMouseEvent *ev);
    virtual void mouseReleaseEvent (QMouseEvent *ev);
    virtual void focusInEvent (QFocusEvent *ev);
    virtual void focusOutEvent (QFocusEvent *ev);

    window *w;
    QBrush *brush;
    QFont *font;
    int w_total, h_total;
    int cur_row, cur_col;
    int blk_row, blk_col;
    int in_blk_select;
    bool shift_down;
};


#endif

