
#ifndef __KSIAGHEADER_H
#define __KSIAGHEADER_H

/**
 * Resizable row/column headers. Originally both horizontal and vertical
 * headers were in one class, but all the "if (orient == Horizontal) xxx;
 * else xxx;" stuff got way too messy.
 */

#include "ksiag_table.h"

class KSiagHeader : public QWidget
{
    Q_OBJECT
public:
    enum {Horizontal, Vertical};
    KSiagHeader (KSiagTable *tbl, QWidget *parent=0, const char *name=0);
    ~KSiagHeader();
public slots:
    void setTopCell (int cell);
protected:
    virtual void drawMoveLine (int pos)=0;
    virtual void mousePressEvent (QMouseEvent *ev)=0;
    virtual void mouseReleaseEvent (QMouseEvent *ev)=0;
    virtual void mouseMoveEvent (QMouseEvent *ev)=0;
    virtual void paintEvent (QPaintEvent *ev)=0;
    KSiagTable *tbl;
    QFont *fnt;
    char text[10];
    int cell, top, orient, oldpos;
    bool inresize, incursor;
};


class KSiagHorizHeader : public KSiagHeader
{
    Q_OBJECT
public:
    KSiagHorizHeader (KSiagTable *tbl, QWidget *parent=0, const char *name=0)
        : KSiagHeader(tbl, parent, name){;}
protected:
    virtual void drawMoveLine (int pos);
    virtual void mousePressEvent (QMouseEvent *ev);
    virtual void mouseReleaseEvent (QMouseEvent *ev);
    virtual void mouseMoveEvent (QMouseEvent *ev);
    virtual void paintEvent (QPaintEvent *ev);
};

class KSiagVertHeader : public KSiagHeader
{
    Q_OBJECT
public:
    KSiagVertHeader (KSiagTable *tbl, QWidget *parent=0, const char *name=0)
        : KSiagHeader(tbl, parent, name){;}
protected:
    virtual void drawMoveLine (int pos);
    virtual void mousePressEvent (QMouseEvent *ev);
    virtual void mouseReleaseEvent (QMouseEvent *ev);
    virtual void mouseMoveEvent (QMouseEvent *ev);
    virtual void paintEvent (QPaintEvent *ev);
};

#endif

