#ifndef __KSIAGDIALOGS_H
#define __KSIAGDIALOGS_H

#include <kfiledialog.h>
#include <qlistbox.h>
//#include "ksiag_app.h"
#include "ksiag_table.h"
#include "ksiag_pluginmanager.h"

/**
 * This is the file dialog. We pretty much just add a filter parsed from Siag's
 * patterns.
 */
class KSiagFileDialog : public KFileDialog
{
public:
    KSiagFileDialog (char *path, char *patterns[], char *fmt);
    int getFilterIndex();
protected:
    virtual bool getShowFilter();
};

class KSiagPluginDialog : public KFileDialog
{
public:
    KSiagPluginDialog (KSiagPluginManager *mgr);
    int getFilterIndex();
protected:
    virtual bool getShowFilter();
};
        

/**
 * This is a simple dialog that presents a list of items.
 */
class KSiagList : public QDialog
{
    Q_OBJECT
public:
    KSiagList (char *text, char *choices[], int nchoices, QWidget *parent=0,
               const char *name=0);
    int item();
private:
    QPushButton *okay, *cancel;
    QListBox *items;
    QLabel *head;
};

#endif 

