
#include "ksiag_app.h"
#include "ksiag_form.h"
#include "formcallbacks.h"

static KSiagForm *form = NULL;

static LISP form_begin()
{
    form = new KSiagForm(KSiagApp::manager()->activeTopLevel());
    form->begin();
    return(NIL);
}

static LISP form_label (LISP text)
{
    char *lbl = get_c_string(text);
    if(form)
        form->label(lbl);
    return(NIL);
}

static LISP form_text (LISP text)
{
    if(form)
        form->text(get_c_string(text));
    return(NIL);
}

static LISP form_menu (LISP text)
{
    if(form)
        form->menu(get_c_string(text));
    return(NIL);
}

static LISP form_menuentry (LISP text)
{
    if(form)
        form->menuEntry(get_c_string(text));
    return(NIL);
}

static LISP form_okbutton (LISP text)
{
    if(form)
        form->okButton(get_c_string(text));
    return(NIL);
}

static LISP form_cancelbutton (LISP text)
{
    if(form)
        form->cancelButton(get_c_string(text));
    return(NIL);
}

static LISP form_property (LISP prop, LISP val)
{
    if(form)
        form->property(get_c_string(prop), val);
    return(NIL);
}

static LISP form_newline()
{
    if(form)
        form->newline();
    return(NIL);
}

static LISP form_end()
{
    LISP result = NIL;
    if(form)
	    result = form->end();
    delete form;
    return(result);
}
