/*
 * $Id: qkstring.h,v 1.1 1998/02/01 19:25:00 kalle Exp $
 */

#ifndef _QKSTRING_H
#define _QKSTRING_H

#include <qstring.h>

class QkString : public QString
{
public:
  QkString() : QString() {};
  QkString( int size ) : QString( size ) {};
  QkString( const QString& s ) : QString( s ) {};
  QkString( const char* str ) : QString( str ) {};
  QkString( const char* str, uint maxlen ) : QString( str, maxlen ) {};

  uint tokenCount( const char separator = ',' ) const;
  QkString getToken( const uint num, const char separator = ',' ) const;
};

#endif

/*
 * $Log: qkstring.h,v $
 * Revision 1.1  1998/02/01 19:25:00  kalle
 * Fixed bug with comboboxes in DocumentLayoutDialog
 *
 * Revision 1.1  1997/10/11 19:43:24  kalle
 * QkString class
 *
 */
