
#include <config.h>

#include <kapp.h>
#include <klocale.h>

#include <stdlib.h>
#include "error.h"
#include "lyx_main.h"
#include "lyxrc.h"
#include "filetools.h"
#include "syscall.h"
#include "SendFaxDialog.h"
#include "LyXView.h"
#include "klyx.h"
#include "BufferView.h"

// 	$Id: lyx_sendfax_main.C,v 1.6 1999/01/05 11:17:21 kulow Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: lyx_sendfax_main.C,v 1.6 1999/01/05 11:17:21 kulow Exp $";
#endif /* lint */

extern BufferView* current_view;

/* Prototypes */

bool sendfax(LString const &fname, LString const &sendcmd);
void show_logfile(LString logfile, bool show_if_empty);

const int LEN_PHONE = 20;
const int LEN_NAME = 25;

/* Global Variables */

LString phone_book;
LString global_sendcmd;
LString filename;

bool send_fax(LString const &fname, LString const &sendcmd)
{
    // I put FAXCMD here to see if I can get rid of some strange errors. (Lgb)
    LString FAXCMD = "sendfax -n -h '$$Host' -c '$$Comment' -x '$$Enterprise' -d '$$Name'@'$$Phone' '$$FName'";
    LString title = i18n("Fax File: ");
    LString path;
    
    if (fname.empty())
        return false;
    path=OnlyPath(fname);
    if (path.empty() || path == "./")
        filename = GetCWD() + "/" + fname;
    else
        filename = fname;

    if (sendcmd.empty())
	    global_sendcmd = FAXCMD;
    else
	    global_sendcmd = sendcmd;
    
    /* init Phone-Book */
    LString phone_book_name;
    if (lyxrc->phone_book.empty()) {
        phone_book_name = "phonebook";
    } else
        phone_book_name = lyxrc->phone_book;
    phone_book=FileSearch(user_lyxdir,phone_book_name);
    if (phone_book.empty()) 
        phone_book = AddName(user_lyxdir,phone_book_name);

	if( !klyxdialogs->phonebook )
		klyxdialogs->phonebook = new Phonebook( current_view->getOwner() );

	klyxdialogs->phonebook->loadFile( phone_book.c_str() );

    title += OnlyFilename(fname);

    /* show the first form */
	if( !klyxdialogs->sendfax )
		klyxdialogs->sendfax = new SendFaxDialog( current_view->getOwner() );

	klyxdialogs->sendfax->setFilename( filename.c_str() );
	klyxdialogs->sendfax->setSendCmd( sendcmd.c_str() );

	SendFaxDialog* sendfax = klyxdialogs->sendfax;
	(void)klyxdialogs->sendfax->exec();
	klyxdialogs->sendfax = sendfax;

    return true;
}


