/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1997 Asger Alstrup
 *
 *======================================================*/

#include <config.h>
#include "insetspecialchar.h"
#include "lyxdraw.h"
#include "error.h"

// 	$Id: insetspecialchar.C,v 1.1.1.1 1997/12/14 21:19:37 kalle Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: insetspecialchar.C,v 1.1.1.1 1997/12/14 21:19:37 kalle Exp $";
#endif /* lint */

InsetSpecialChar::InsetSpecialChar()
{
}


InsetSpecialChar::InsetSpecialChar(Kind k)
	: kind(k)
{
}


InsetSpecialChar::~InsetSpecialChar()
{
}


int InsetSpecialChar::Ascent(LyXFont const&font) const
{
	return font.maxAscent();
}


int InsetSpecialChar::Descent(LyXFont const&font) const
{
	return font.maxDescent();
}


int InsetSpecialChar::Width(LyXFont const&font) const
{
	LyXFont f = font;
	switch (kind) {
	case HYPHENATION:
	{
		int w = f.textWidth("-", 1);
		if (w > 5) 
			w -= 2; // to make it look shorter
		return w;
	}
	case END_OF_SENTENCE:
	{
		return f.textWidth(".", 1);
	}
	case LDOTS:
	{
		return f.textWidth(". . .", 5);
	}
	}
	return 1; // To shut up gcc
}


void InsetSpecialChar::Draw(LyXFont font, LyXScreen &scr,
			    int baseline, float &x)
{
	switch (kind) {
	case HYPHENATION:
	{
		font.setColor(LyXFont::MAGENTA);
		scr.drawText(font, "-", 1, baseline, int(x));
		x += Width(font);
		break;
	}
	case END_OF_SENTENCE:
	{
		font.setColor(LyXFont::MAGENTA);
		scr.drawText(font, ".", 1, baseline, int(x));
		x += Width(font);
		break;
	}
	case LDOTS:
	{
		font.setColor(LyXFont::MAGENTA);
		scr.drawText(font, ". . .", 5, baseline, int(x));
		x += Width(font);
		break;
	}
	}
}


// In lyxf3 this will be just LaTeX
void InsetSpecialChar::Write(FILE *file)
{
	LString command;
	switch (kind) {
	case HYPHENATION:	command = "\\-";	break;
	case END_OF_SENTENCE:	command = "\\@.";	break;
	case LDOTS:		command = "\\ldots{}";	break;
	}
	fprintf(file, "\\SpecialChar %s\n", command.c_str());
}


// This function will not be necessary when lyx3
void InsetSpecialChar::Read(LyXLex &lex)
{    
	lex.nextToken();
	LString command = lex.GetString();

	if (command=="\\-")
		kind = HYPHENATION;
	else if (command=="\\@.")
		kind = END_OF_SENTENCE;
	else if (command=="\\ldots{}")
		kind = LDOTS;
	else
		lex.printError("InsetSpecialChar: Unknown kind: `$$Token'");
}


int InsetSpecialChar::Latex(FILE *file, signed char /*fragile*/)
{
	LString command;
	signed char dummy = 0;
	Latex(command, dummy);
	fprintf(file, "%s", command.c_str());
	return 0;
}


int InsetSpecialChar::Latex(LString &file, signed char /*fragile*/)
{
	switch (kind) {
	case HYPHENATION:	file += "\\-";	break;
	case END_OF_SENTENCE:	file += "\\@.";	break;
	case LDOTS:		file += "\\ldots{}";	break;
	}
	return 0;
}


Inset* InsetSpecialChar::Clone()
{
	InsetSpecialChar *result = new InsetSpecialChar(kind);
	return result;
}
