#include <config.h>

#include <kapp.h>
#include <klocale.h>

#include <stdlib.h>
#include "insetindex.h"
#include "buffer.h"
#include "error.h"
#include "LaTeXFeatures.h"
#include "LString.h"
#include "lyx_gui_misc.h" // WarnReadonly()
#include "InsertIndexEntryDialog.h"
#include "LyXView.h"
 
extern BufferView *current_view;

InsetIndex::InsetIndex(LString const & key)
	: InsetCommand("index", key) 
{
}


InsetIndex::~InsetIndex()
{
}


void InsetIndex::Edit(int, int)
{
	if(current_view->currentBuffer()->isReadonly())
		WarnReadonly();

	if( !klyxdialogs->insertindex )
	  klyxdialogs->insertindex = new InsertIndexEntryDialog( current_view->getOwner() );

	klyxdialogs->insertindex->setInsetIndex( this );
	klyxdialogs->insertindex->setIndexEntry( getContents().c_str() );

	(void)klyxdialogs->insertindex->exec();
}


LString InsetIndex::getScreenLabel() const
{
	LString tmp;
	tmp = i18n("Index: ");
	tmp+=getContents();
	return tmp;
}


//
// InsetPrintIndex
//

InsetPrintIndex::InsetPrintIndex()
	: InsetCommand("printindex")
{
	owner = NULL;
}


InsetPrintIndex::InsetPrintIndex(Buffer *o)
	: InsetCommand("printindex"), owner(o)
{
}


InsetPrintIndex::~InsetPrintIndex()
{
}


LString InsetPrintIndex::getScreenLabel() const
{
	return i18n("PrintIndex");
}


void InsetPrintIndex::Validate(LaTeXFeatures &features) const
{
	features.makeidx = true;
}


Inset::Code InsetPrintIndex::LyxCode() const
{
 	return Inset::INDEX_CODE;
}
