// -*- C++ -*-
/* ======================================================================= *\
   Docu   : To add a new function:
   - add a new enum constant immediately before LFUN_LASTACTION
   - add an appropriate line to lyx_func_table in LyXAction.C
   - add a branch to the switch in LyXFunc::Dispath() in lyxfunc.C
   - add a help text in LyXAction::getHelp() in LyXAction.C
   \* ======================================================================= */

#ifndef _COMMANDTAGS_H_
#define _COMMANDTAGS_H_


/** These are all the lyxfunctions (as enums).
 */
enum kb_action {
	LFUN_UNKNOWN_ACTION = -1,
	LFUN_NOACTION = 0,
	LFUN_PREFIX,
	LFUN_CENTER,
	LFUN_MENUNEW,
	LFUN_MENUOPEN,
	LFUN_MENUWRITE,
	LFUN_MENUWRITEAS,
	LFUN_MENUPRINT,
	LFUN_MENUSENDTO,
	LFUN_RUNLATEX,
	LFUN_TOCVIEW,
	LFUN_DOCUMENT_STRUCTURE,
	LFUN_PREVIEW,
	LFUN_PREVIEWPS,
	LFUN_PREVIEWCUSTOM,	// Rocher 981124
	LFUN_PREVIEWUPDATE,	// Rocher 981124
	LFUN_CLOSEBUFFER,
	LFUN_QUIT,
	LFUN_AUTOSAVE,
	LFUN_UNDO,
	LFUN_REDO,
	LFUN_MENUSEARCH,
	LFUN_PASTE,
	LFUN_PASTESELECTION,
	LFUN_CUT,
	LFUN_COPY,
	LFUN_EXCHANGE_CURSOR_SELECTION,	// Rocher 981127
	LFUN_GOTOERROR,
	LFUN_GOTONOTE,
	LFUN_OPENSTUFF,
	LFUN_HYPHENATION,
	LFUN_HFILL,
	LFUN_DEPTH,
	LFUN_FREE,
	LFUN_FREE_TOOLBAR,	// Rocher 981201
	LFUN_TEX,
	LFUN_FOOTMELT,
	LFUN_MARGINMELT,
	LFUN_PREVBUFFER,
	LFUN_EMPH,
	LFUN_BOLD,
	LFUN_ROMAN,
	LFUN_NOUN,
	LFUN_RIGHT,
	LFUN_LEFT,
	LFUN_UP,
	LFUN_DOWN,
	LFUN_PRIOR,
	LFUN_NEXT,
	LFUN_HOME,
	LFUN_END,
	LFUN_TAB,
	LFUN_WORDRIGHT,
	LFUN_WORDLEFT,
	LFUN_BEGINNINGBUF,
	LFUN_ENDBUF,
	LFUN_RIGHTSEL,
	LFUN_LEFTSEL,
	LFUN_UPSEL,
	LFUN_DOWNSEL,
	LFUN_PRIORSEL,
	LFUN_NEXTSEL,
	LFUN_HOMESEL,
	LFUN_ENDSEL,
	LFUN_WORDRIGHTSEL,
	LFUN_WORDLEFTSEL,
	LFUN_BEGINNINGBUFSEL,
	LFUN_ENDBUFSEL,
	LFUN_PROTECTEDSPACE,
	LFUN_SETMARK,
	LFUN_DELETE,
	LFUN_BACKSPACE,
	LFUN_BREAKLINE,
	LFUN_BREAKPARAGRAPH,
	LFUN_BREAKPARAGRAPHKEEPLAYOUT,
	LFUN_QUOTE,
	LFUN_CIRCUMFLEX,
	LFUN_GRAVE,
	LFUN_ACUTE,
	LFUN_TILDE,
	LFUN_CEDILLA,
	LFUN_MACRON,
	LFUN_UNDERBAR,
	LFUN_UNDERDOT,
	LFUN_CIRCLE,
	LFUN_TIE,
	LFUN_BREVE,
	LFUN_CARON,
	LFUN_SPECIAL_CARON,
	LFUN_HUNG_UMLAUT,
	LFUN_UMLAUT,
	LFUN_DOT,
	LFUN_OGONEK,
	LFUN_VECTOR,        //  Alejandro 040696
	LFUN_SELFINSERT,
	LFUN_GETBUFNAME,
	LFUN_GETXY,
	LFUN_SETXY,
	LFUN_CHARATCURSOR,
	LFUN_LINEATCURSOR,
	LFUN_GETLAYOUT,
	LFUN_GETFONT,
	LFUN_GETLATEX,
	LFUN_GETNAME,
	LFUN_NOTIFY,
	LFUN_INSERT_INSET_LATEX,
	LFUN_INSERT_INSET_LATEX_DEL,
	LFUN_INSERT_NOTE,
	LFUN_KMAP_OFF,
	LFUN_KMAP_PRIM,
	LFUN_KMAP_SEC,
	LFUN_KMAP_TOGGLE,
	LFUN_INSERT_MATH,
	LFUN_INSERT_MATRIX,
	LFUN_GREEK,
	LFUN_MATH_LIMITS,  
	LFUN_GREEK_TOGGLE,
	LFUN_MATH_DELIM,    //  Alejandro 180696
	LFUN_MATH_DISPLAY,  // was INSERT_EQUATION  Alejandro 180696
	LFUN_MATH_MODE,     //  Alejandro 040696
	LFUN_MATH_NUMBER,   //  Alejandro 040696
	LFUN_MATH_NONUMBER,   //  Alejandro 180696
	LFUN_MATH_SIZE,   //  Alejandro 150896
	LFUN_MATH_MACRO,  // ale970510
	LFUN_MATH_MACROARG,  // ale970510
	LFUN_FIGURE,
	LFUN_TABLE,
	LFUN_MELT,
	LFUN_DELETE_WORD_FORWARD,
	LFUN_DELETE_WORD_BACKWARD,
	LFUN_DELETE_LINE_FORWARD,
	LFUN_MARK_OFF,
	LFUN_MARK_ON,
	LFUN_LAYOUT,
	LFUN_LAYOUTNO,    // Lgb 97-06-10
	LFUN_LAYOUT_CHARACTER,
	LFUN_LAYOUT_PARAGRAPH,
	LFUN_LAYOUT_DOCUMENT,
	LFUN_LAYOUT_PAPER,
	LFUN_LAYOUT_TABLE,
	LFUN_LAYOUT_QUOTES,
	LFUN_LAYOUT_PREAMBLE,
	LFUN_DROP_LAYOUTS_CHOICE,
	LFUN_CODE,
	LFUN_SANS,
	LFUN_DEFAULT,
	LFUN_UNDERLINE,
	LFUN_FONT_SIZE,
	LFUN_FONT_STATE,
	LFUN_UPCASE_WORD,
	LFUN_LOWCASE_WORD,
	LFUN_CAPITALIZE_WORD,
	LFUN_INSERT_LABEL,
	LFUN_INSERT_REF,
	LFUN_PUSH_TOOLBAR,
	LFUN_ADD_TO_TOOLBAR,
	LFUN_DEPTH_MIN,                // RVDK_PATCH_5
	LFUN_DEPTH_PLUS,                     // RVDK_PATCH_5
	LFUN_MENU_OPEN_BY_NAME,              // RVDK_PATCH_5
	LFUN_SPELLCHECK,                     // RVDK_PATCH_5
	LFUN_CANCEL,                         // RVDK_PATCH_5
	LFUN_META_FAKE,                      // RVDK_PATCH_5
	LFUN_EXEC_COMMAND,
	LFUN_FILE_INSERT,
	LFUN_FILE_INSERT_ASCII,         // CFO-G 1997-11-19
	LFUN_FILE_NEW,
	LFUN_FILE_OPEN,
	LFUN_UP_PARAGRAPH, 		// Asger 1996-10-01
	LFUN_UP_PARAGRAPHSEL,		// Asger 1996-10-01
	LFUN_DOWN_PARAGRAPH,		// Asger 1996-10-01
	LFUN_DOWN_PARAGRAPHSEL,		// Asger 1996-10-01
	LFUN_BREAKPARAGRAPH_SKIP,
	LFUN_BACKSPACE_SKIP,
	LFUN_DELETE_SKIP,
	LFUN_MENUNEWTMPLT,		// Asger 1997-02-02
	LFUN_RUNDVIPS,			// Asger 1997-02-02
	LFUN_MENURELOAD,		// Asger 1997-02-02
	LFUN_FAX,			// Asger 1997-02-10
	LFUN_RECONFIGURE,		// Asger 1997-02-14
	LFUN_INSERT_CITATION,           // AAS 97-02-23
	LFUN_INSERT_BIBTEX,             // AAS 97-02-23
	LFUN_INDEX_INSERT,              // Lgb 97-02-27
	LFUN_INDEX_PRINT,               // Lgb 97-02-27
	LFUN_APROPOS,                   // Asger 1997-02-27
	LFUN_LATEX_LOG,                 // Lgb 97-04-05
	LFUN_LAYOUT_COPY,		// Asger 1997-05-04
	LFUN_LAYOUT_PASTE,		// Asger 1997-05-04
	LFUN_TABINSERT,                 // Ale 970515
	LFUN_CHILDINSERT,               // Ale 970521
	LFUN_CHILDOPEN,                 // Ale 970528
	LFUN_TOC_INSERT,                // Lgb 97-05-27
	LFUN_LOA_INSERT,                // Bernhard 97-08-07
	LFUN_LOF_INSERT,                // Lgb 97-05-27
	LFUN_LOT_INSERT,                // Lgb 97-05-27
	LFUN_READ_ONLY_TOGGLE,          // Lgb 97-05-27    
	LFUN_BIBDB_ADD,                 // Ale 970530   
	LFUN_BIBDB_DEL,                 // Ale 970530
	LFUN_BIBTEX_STYLE,              // Ale 970530
	LFUN_GETTIP,                    // Ale 970603
	LFUN_VC_REGISTER,               // Lgb 97-07-01
	LFUN_VC_CHECKIN,                // Lgb 97-07-01
	LFUN_VC_CHECKOUT,               // Lgb 97-07-01
	LFUN_VC_REVERT,                 // Lgb 97-07-01
	LFUN_VC_UNDO,                   // Lgb 97-07-01
	LFUN_VC_HISTORY,                // Lgb 97-07-01
	LFUN_REFTOGGLE,                 // Ale 970723
	LFUN_EXPORT,                    // Lgb 97-07-29
	LFUN_INSERTFOOTNOTE,            // Bernhard 97-08-07
	LFUN_REFGOTO,                   // Ale 970806
	LFUN_REFBACK,                   // Ale 970806
	LFUN_PARENTINSERT,		// Ale 970813
	LFUN_REMOVEERRORS,		// Asger 970906
	LFUN_LDOTS,			// Asger 970929
	LFUN_END_OF_SENTENCE,		// Asger 970929
	LFUN_RUNCHKTEX,			// Asger 971030
	LFUN_BUFFERBULLETSSELECT,       // ARRae 971018
	LFUN_TOGGLECURSORFOLLOW,        // ARRae 971202
	LFUN_HTMLURL,                   // CFO-G 971121
	LFUN_URL,                       // CFO-G 971121
	
	LFUN_WINDOW_NEW,                 // Matthias for klyx
	LFUN_WINDOW_DELETE,
	LFUN_WINDOW_SPLIT,
	LFUN_WINDOW_SPLIT_VERTICAL,	// Rocher 981130
	LFUN_WINDOW_UNSPLIT,
        LFUN_WINDOW_UNSPLIT_OTHER,	// Rocher 981123
        LFUN_WINDOW_CHANGEVIEW,		// Rocher 981123

	LFUN_APPENDIX,
	LFUN_LASTACTION  /* this marks the end of the table */
};

#endif
