/*
 * $Id: ViewLogfileDialog.C,v 1.5 1999/01/05 11:16:58 kulow Exp $
 */

#include "ViewLogfileDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qfileinf.h>
#include <qmlined.h>
#include <qpushbt.h>
#include <qlayout.h>

#include "LyXView.h"

ViewLogfileDialog::ViewLogfileDialog( LyXView* view, QWidget * parent=0, 
									  const char * name=0, 
									  WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  editED = new QMultiLineEdit( this );

  QPushButton* updatePB = new QPushButton( i18n( "&Update" ), 
										   this );
  QObject::connect( updatePB, SIGNAL( clicked() ),
					this, SLOT( updateClicked() ) );

  QPushButton* closePB = new QPushButton( i18n( "&Close" ), 
										  this );
  QObject::connect( closePB, SIGNAL( clicked() ),
					this, SLOT( closeClicked() ) );

  setCaption( i18n( "View Logfile" ) );

  updatePB->setMinimumSize(updatePB->sizeHint());
  closePB->setMinimumSize(closePB->sizeHint());
  if (updatePB->minimumSize().width() <75)
      updatePB->setFixedWidth(75);
  if (closePB->minimumSize().width() <75)
      closePB->setFixedWidth(75);
  
  QVBoxLayout *v=new QVBoxLayout(this,5,5);
  QHBoxLayout *h=new QHBoxLayout();
  v->addWidget(editED,1);
  v->addLayout(h,0);
  h->addWidget(updatePB,0);
  h->addStretch(10);
  h->addWidget(closePB,0);
  v->activate();

  resize(400,400);
}


void ViewLogfileDialog::updateClicked()
{
  loadFile( logfile );
}


void ViewLogfileDialog::closeClicked()
{
  reject();
}


void ViewLogfileDialog::loadFile( QString filename )
{
  logfile = filename;

  editED->clear();

  if( !QFileInfo( filename ).exists() )
	editED->insertLine( i18n( "NO LATEX LOGFILE" ) );
  else
	{
	  QFile file( filename );
	  if( file.open( IO_ReadOnly ) )
		{
		  QTextStream stream( &file );
		  while( !stream.eof() )
			editED->insertLine( stream.readLine() );
		  
		  file.close();
		}
	}
}



/*
 * $Log: ViewLogfileDialog.C,v $
 * Revision 1.5  1999/01/05 11:16:58  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.4  1998/03/05 21:01:42  ralsina
 * [Roberto] GMified ViewLogFileDialog
 *
 * Revision 1.3  1998/03/04 21:49:58  kalle
 * More Qt-ified
 *
 * Revision 1.2  1998/03/03 22:36:30  kulow
 * removed all those ->show(), they make me crazy
 *
 * Revision 1.1  1998/01/27 23:09:55  kalle
 * The first part of the monster commit. Perhaps not everything
 * compiles yet...
 * The ViewLogfile dialog is in, but not yet tested.
 *
 */
