/*
 * $Id: SpellCheckDialog.C,v 1.4 1999/01/05 11:16:53 kulow Exp $
 */

#include "SpellCheckDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qlabel.h>
#include <qpushbt.h>

#include "LyXView.h"
#include "commandtags.h"
#include "lyxfunc.h"
#include "spellchecker.h"

SpellCheckDialog::SpellCheckDialog( LyXView* view, QWidget * parent=0, 
									const char * name=0, 
									WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  QLabel* unknownLA = new QLabel( i18n( "Unknown:" ), this );
  unknownLA->setGeometry( 10, 10, 60, 30 );
  unknownLA->setAlignment( AlignVCenter | AlignRight );

  unknownED = new QLineEdit( this );
  unknownED->setGeometry( 80, 10, 210, 30 );
  unknownED->setEnabled( false );

  QLabel* replaceLA = new QLabel( i18n( "Replace:" ), this );
  replaceLA->setGeometry( 10, 50, 60, 30 );
  replaceLA->setAlignment( AlignVCenter | AlignRight );

  replaceED = new QLineEdit( this );
  replaceED->setGeometry( 80, 50, 210, 30 );

  QLabel* alternativesLA = new QLabel( i18n( "Alternatives:" ), 
									   this );
  alternativesLA->setGeometry( 10, 90, 70, 30 );
  alternativesLA->setAlignment( AlignVCenter | AlignRight );

  alternativesLB = new QListBox( this );
  alternativesLB->setGeometry( 80, 90, 210, 210 );
  QObject::connect( alternativesLB, SIGNAL( highlighted( int ) ),
					this, SLOT( listBoxHighlighted( int ) ) );
  QObject::connect( alternativesLB, SIGNAL( selected( int ) ),
					this, SLOT( listBoxSelected( int ) ) );

  progressPB = new QProgressBar( 100, this );
  progressPB->setGeometry( 10, 310, 280, 30 );

  startPB = new QPushButton( i18n( "&Start spellchecking" ), 
							 this );
  startPB->setGeometry( 300, 10, 170, 30 );
  QObject::connect( startPB, SIGNAL( clicked() ), this, SLOT( start() ) );

  insertPB = new QPushButton( i18n( "&Insert in personal dictionary" ), this );
  insertPB->setGeometry( 300, 60, 170, 30 );
  insertPB->setEnabled( false );
  QObject::connect( insertPB, SIGNAL( clicked() ), this, SLOT( insert() ) );

  acceptPB = new QPushButton( i18n( "&Accept word in this session" ), this );
  acceptPB->setGeometry( 300, 100, 170, 30 );
  acceptPB->setEnabled( false );
  QObject::connect( acceptPB, SIGNAL( clicked() ), this, SLOT( accept() ) );

  ignorePB = new QPushButton( i18n( "I&gnore word" ), this );
  ignorePB->setGeometry( 300, 140, 170, 30 );
  ignorePB->setEnabled( false );
  QObject::connect( ignorePB, SIGNAL( clicked() ), this, SLOT( ignore() ) );

  replacePB = new QPushButton( i18n( "R&eplace word" ), this );
  replacePB->setGeometry( 300, 180, 170, 30 );
  replacePB->setEnabled( false );
  QObject::connect( replacePB, SIGNAL( clicked() ), this, SLOT( replace() ) );

  stopPB = new QPushButton( i18n( "Stop spellchecking" ), this );
  stopPB->setGeometry( 300, 230, 170, 30 );
  stopPB->setEnabled( false );
  QObject::connect( stopPB, SIGNAL( clicked() ), this, SLOT( stop() ) );

  optionsPB = new QPushButton( i18n( "Spellchecker &Options" ), 
							   this );
  optionsPB->setGeometry( 300, 270, 170, 30 );
  QObject::connect( optionsPB, SIGNAL( clicked() ), this, SLOT( options() ) );

  closePB = new QPushButton( i18n( "Close spellchecker" ), 
							 this );
  closePB->setGeometry( 300, 310, 170, 30 );
  QObject::connect( closePB, SIGNAL( clicked() ), this, SLOT( close() ) );

  setCaption( i18n( "Spellchecker" ) );
  clearFlags();
  bIsRunning = false; // may not be moved to clearFlags();
}



void SpellCheckDialog::reset()
{
  progressPB->setProgress( 0 );
  unknownED->setText( "" );
  replaceED->setText( "" );
  alternativesLB->clear();
  insertPB->setEnabled( false );
  acceptPB->setEnabled( false );
  ignorePB->setEnabled( false );
  replacePB->setEnabled( false );
  stopPB->setEnabled( false );
  clearFlags();
}


void SpellCheckDialog::clearFlags()
{
  bStop = false;
  bClose = false;
  bAccept = false;
  bReplace = false;
  bIgnore = false;
  bInsert = false;
}


void SpellCheckDialog::start()
{
  clearFlags();
  startPB->setEnabled( false );
  optionsPB->setEnabled( false );
  insertPB->setEnabled( true );
  acceptPB->setEnabled( true );
  ignorePB->setEnabled( true );
  replacePB->setEnabled( true );
  stopPB->setEnabled( true );

  bIsRunning = true;
  
  int ret = RunSpellChecker( _view->currentBuffer()->GetLanguage() );
  // if RunSpellChecker returns false quit spellchecker
  if( !ret )
	reject();
  
  bIsRunning = false;

  EndOfSpellCheck();
  startPB->setEnabled( true );
  optionsPB->setEnabled( true );
  reset();
}


void SpellCheckDialog::stop()
{
  bStop = true;
}


void SpellCheckDialog::ignore()
{
  bIgnore = true;
}


void SpellCheckDialog::replace()
{
  bReplace = true;
}


void SpellCheckDialog::accept()
{
  bAccept = true;
}


void SpellCheckDialog::insert()
{
  bInsert = true;
}


void SpellCheckDialog::close()
{
  if( bIsRunning )
	bClose = true;
  else
	reject();
}


void SpellCheckDialog::options()
{
  SpellCheckerOptions();
}


void SpellCheckDialog::listBoxHighlighted( int item )
{
  setReplaceText( alternativesLB->text( item ) );
}


void SpellCheckDialog::listBoxSelected( int item )
{
  setReplaceText( alternativesLB->text( item ) );
  bReplace = true; 
}


