/*
 * $Id: QuotesDialog.C,v 1.5 1999/01/05 11:16:47 kulow Exp $
 */

#include "QuotesDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qcombo.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qradiobt.h>

#include "LyXView.h"
#include "BufferView.h"
#include "minibuffer.h"
#include "insetquotes.h"

extern BufferView* current_view;

QuotesDialog::QuotesDialog( LyXView* view, QWidget * parent=0, 
							const char * name=0, 
							WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  QLabel* typeLA = new QLabel( i18n( "Type: "), this );
  typeLA->setGeometry( 40, 10, 40, 30 );
  typeLA->setAlignment( AlignVCenter | AlignRight );

  typeCB = new QComboBox( false, this );
  typeCB->setGeometry( 90, 10, 100, 30 );
  typeCB->insertItem( "``text''" );
  typeCB->insertItem( "''text''" );
  typeCB->insertItem( ",,text``" );
  typeCB->insertItem( ",,text''" );
  typeCB->insertItem( "text" );
  typeCB->insertItem( "text" );

  QButtonGroup* singledoubleBG = new QButtonGroup( this );
  singledoubleBG->hide();

  singleRB = new QRadioButton( i18n( "&Single" ), this );
  singleRB->setGeometry( 20, 40, 90, 30 );
  singleRB->setChecked( true );
  singledoubleBG->insert( singleRB );

  doubleRB = new QRadioButton( i18n( "&Double" ), this );
  doubleRB->setGeometry( 120, 40, 90, 30 );
  singledoubleBG->insert( doubleRB );

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 10, 80, 100, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), 
										   this );
  cancelPB->setGeometry( 120, 80, 100, 30 );
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );

  setCaption( i18n( "Configure Quotes" ) );
}


void QuotesDialog::okClicked()
{
  if( !current_view->available() )
	return;
	
  current_view->getMiniBuffer()->Set(i18n("Quotes type set"));
  InsetQuotes::quote_language lga = InsetQuotes::EnglishQ;
  switch( typeCB->currentItem() ) {
  case 0:
	lga = InsetQuotes::EnglishQ;
	break;
  case 1:
	lga = InsetQuotes::SwedishQ;
	break;
  case 2:
	lga = InsetQuotes::GermanQ;
	break;
  case 3:
	lga = InsetQuotes::PolishQ;
	break;
  case 4:
	lga = InsetQuotes::FrenchQ;
	break;
  case 5:
	lga = InsetQuotes::DanishQ;
	break;
  }

  _view->currentBuffer()->params.quotes_language = lga;
  if( singleRB->isChecked() )
	_view->currentBuffer()->params.quotes_times = InsetQuotes::SingleQ;
  else
	_view->currentBuffer()->params.quotes_times = InsetQuotes::DoubleQ;
  
  accept();
}


void QuotesDialog::cancelClicked()
{
  reject();
}


void QuotesDialog::setQuotes( int item )
{
  typeCB->setCurrentItem( item );
}


void QuotesDialog::setSingle()
{
  singleRB->setChecked( true );
  doubleRB->setChecked( false );
}


void QuotesDialog::setDouble()
{
  singleRB->setChecked( false );
  doubleRB->setChecked( true );
}


/*
 * $Log: QuotesDialog.C,v $
 * Revision 1.5  1999/01/05 11:16:47  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.4  1998/05/17 15:58:02  schreter
 *
 *
 * Changed label widths to fit in Slovak translations (mainly).
 * Also added character set autodetection (from /opt/kderc, General Font,
 * Charset). It only accepts iso8859-1,2,7, since only these do have
 * .cdef files for them. Use DEFCHARSET (defined in klyx.h) for defaults
 * in config reads, etc. I've changed string "iso8859-1" to DEFCHARSET
 * where appropriate.
 * TODO: fix autodetection, use some locale functions instead of kderc.
 *
 * Revision 1.3  1998/03/17 15:56:35  ettrich
 * Matthias: fixed half a million of bugs
 *
 * Revision 1.2  1998/03/04 21:49:38  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/02/09 22:26:25  kalle
 *  - added PaperFormatDialog
 * - added QuotesDialog
 *
 */
