/*
 * $Id: ParagraphDialog.C,v 1.12 1998/08/05 11:04:15 kuepper Exp $
 */

#include "ParagraphDialog.h"
#include "ParagraphExtraDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qdialog.h>
#include <qlabel.h>
#include <qbttngrp.h>
#include <qchkbox.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qgrpbox.h>
#include <qradiobt.h>
#include <qcombo.h>
#include <qlayout.h>

extern void ParagraphApplyCB();
extern void ParagraphVSpaceCB_SpaceAboveCombo( int );
extern void ParagraphVSpaceCB_SpaceBelowCombo( int );
extern void ParagraphVSpaceCB_SpaceAboveEdit( const char* );
extern void ParagraphVSpaceCB_SpaceBelowEdit( const char* );


ParagraphDialog::ParagraphDialog( QWidget * parent=0, 
				  const char * name=0, 
				  WFlags f=0 ) :
    QDialog( parent, name, false, f ),
    _extra_data( 0 )
{
  QVBoxLayout *toplevelVL = new QVBoxLayout( this, 10, 12);

  QHBoxLayout *topHL = new QHBoxLayout();
  toplevelVL->addLayout(topHL, 0);
  
  alignmentBG = new QButtonGroup( i18n( "Alignment" ), this );
  topHL->addWidget(alignmentBG);
  
  QGridLayout *alignmentGL = new QGridLayout(alignmentBG, 2, 2, 15);
  
  rightRB = new QRadioButton( i18n( "&Right" ), alignmentBG );
  rightRB->adjustSize();
  rightRB->setMinimumSize(rightRB->size());
  alignmentGL->addWidget(rightRB, 0, 0);

  leftRB = new QRadioButton( i18n( "&Left" ), alignmentBG );
  leftRB->adjustSize();
  leftRB->setMinimumSize(leftRB->size());
  alignmentGL->addWidget(leftRB, 0, 1);

  blockRB = new QRadioButton( i18n( "&Block" ), alignmentBG );
  blockRB->adjustSize();
  blockRB->setMinimumSize(blockRB->size());
  alignmentGL->addWidget(blockRB, 1, 0);
  blockRB->setChecked( true );

  centerRB = new QRadioButton( i18n( "&Center" ), alignmentBG );
  centerRB->adjustSize();
  centerRB->setMinimumSize(centerRB->size());
  alignmentGL->addWidget(centerRB, 1, 1);
  alignmentGL->activate();

  linesBG = new QButtonGroup( i18n( "Lines" ), this );
  topHL->addWidget(linesBG);
  
  QVBoxLayout *linesVL = new QVBoxLayout( linesBG, 15, 3);
    
  abovelinesCB = new QCheckBox( i18n( "Ab&ove" ), linesBG );
  abovelinesCB->adjustSize();
  abovelinesCB->setMinimumSize(abovelinesCB->size());
  linesVL->addWidget(abovelinesCB);

  belowlinesCB = new QCheckBox( i18n( "B&elow" ), linesBG );
  belowlinesCB->adjustSize();
  belowlinesCB->setMinimumSize(belowlinesCB->size());
  linesVL->addWidget(belowlinesCB);
  linesVL->activate();

  pagebreaksBG = new QButtonGroup( i18n( "Pagebreaks" ), this );
  topHL->addWidget(pagebreaksBG);
  
  QVBoxLayout *pagebreaksVL = new QVBoxLayout( pagebreaksBG, 15, 3);
  abovepagebreakCB = new QCheckBox( i18n( "Abo&ve" ), pagebreaksBG );
  abovepagebreakCB->adjustSize();
  abovepagebreakCB->setMinimumSize(abovepagebreakCB->size());
  pagebreaksVL->addWidget(abovepagebreakCB);

  belowpagebreakCB = new QCheckBox( i18n( "Belo&w" ), pagebreaksBG );
  belowpagebreakCB->adjustSize();
  belowpagebreakCB->setMinimumSize(belowpagebreakCB->size());
  pagebreaksVL->addWidget(belowpagebreakCB);
  pagebreaksVL->activate();

  QHBoxLayout *middleHL = new QHBoxLayout(15);
  toplevelVL->addLayout(middleHL, 0);
  
  verticalspacesGB = new QGroupBox( i18n( "Vertical Spaces" ), this );
  middleHL->addWidget(verticalspacesGB);
  
  QGridLayout *verticalspacesGL = new QGridLayout(verticalspacesGB, 5, 4, 11);
  int i;
  for (i = 0; i < 5; i++)
      verticalspacesGL->setRowStretch(i, 1);
  for (i = 0; i < 4; i++)
      verticalspacesGL->setColStretch(i, 1);

  abovespaceLA = new QLabel( i18n( "Above:" ), verticalspacesGB );
  abovespaceLA->adjustSize();
  abovespaceLA->setMinimumSize(abovespaceLA->size());
  verticalspacesGL->addWidget(abovespaceLA, 1, 0);
  abovespaceLA->setAlignment( AlignRight | AlignVCenter );

  belowspaceLA = new QLabel( i18n( "Below:" ), verticalspacesGB );
  belowspaceLA->adjustSize();
  belowspaceLA->setMinimumSize(belowspaceLA->size());
  verticalspacesGL->addWidget(belowspaceLA, 3, 0);
  belowspaceLA->setAlignment( AlignRight | AlignVCenter );

  abovespaceCO = new QComboBox( FALSE, verticalspacesGB );
  abovespaceCO->insertItem( "None", ParagraphDialogData::VS_None );
  abovespaceCO->insertItem( "Defskip", ParagraphDialogData::VS_Defskip );
  abovespaceCO->insertItem( "Smallskip", ParagraphDialogData::VS_Smallskip );
  abovespaceCO->insertItem( "Medskip", ParagraphDialogData::VS_Medskip );
  abovespaceCO->insertItem( "Bigskip", ParagraphDialogData::VS_Bigskip );
  abovespaceCO->insertItem( "Vfill", ParagraphDialogData::VS_Vfill );
  abovespaceCO->insertItem( "Length", ParagraphDialogData::VS_Length );
  abovespaceCO->adjustSize();
  abovespaceCO->setMinimumSize(abovespaceCO->size());
  abovespaceCO->setMaximumHeight(abovespaceCO->height());
  verticalspacesGL->addWidget(abovespaceCO, 1, 1);

  belowspaceCO = new QComboBox( FALSE, verticalspacesGB );
  belowspaceCO->insertItem( "None", ParagraphDialogData::VS_None );
  belowspaceCO->insertItem( "Defskip", ParagraphDialogData::VS_Defskip );
  belowspaceCO->insertItem( "Smallskip", ParagraphDialogData::VS_Smallskip );
  belowspaceCO->insertItem( "Medskip", ParagraphDialogData::VS_Medskip );
  belowspaceCO->insertItem( "Bigskip", ParagraphDialogData::VS_Bigskip );
  belowspaceCO->insertItem( "Vfill", ParagraphDialogData::VS_Vfill );
  belowspaceCO->insertItem( "Length", ParagraphDialogData::VS_Length );
  belowspaceCO->adjustSize();
  belowspaceCO->setMinimumSize(belowspaceCO->size());
  belowspaceCO->setMaximumHeight(belowspaceCO->height());
  verticalspacesGL->addWidget(belowspaceCO, 3, 1); 

  abovespaceED = new QLineEdit( verticalspacesGB );
  abovespaceED->setMinimumWidth( 60 );
  verticalspacesGL->addWidget(abovespaceED, 1, 2); 

  belowspaceED = new QLineEdit( verticalspacesGB );
  belowspaceED->setMinimumWidth( 60 );
  verticalspacesGL->addWidget(belowspaceED, 3, 2); 

  abovespacekeepCB = new QCheckBox( i18n( "Keep" ), verticalspacesGB );
  abovespacekeepCB->adjustSize();
  abovespacekeepCB->setMinimumSize(abovespacekeepCB->size());
  verticalspacesGL->addWidget(abovespacekeepCB, 1, 3); 

  belowspacekeepCB = new QCheckBox( i18n( "Keep" ), verticalspacesGB );
  belowspacekeepCB->adjustSize();
  belowspacekeepCB->setMinimumSize(belowspacekeepCB->size());
  verticalspacesGL->addWidget(belowspacekeepCB, 3, 3); 
  verticalspacesGL->activate();

  QVBoxLayout *indentSpaceVL = new QVBoxLayout();
  middleHL->addLayout(indentSpaceVL);
  
  indentBG = new QButtonGroup( i18n( "Indent" ), this );
  QVBoxLayout *indentVL = new QVBoxLayout( indentBG, 15, 3 );
  
  noindentCB = new QCheckBox( i18n( "&No indent" ), indentBG );
  indentVL->addWidget(noindentCB);
  noindentCB->adjustSize();
  noindentCB->setMinimumSize(noindentCB->size());
  indentVL->activate();

  indentSpaceVL->addWidget(indentBG);
  indentSpaceVL->addWidget(new QLabel("hello"));

  QButtonGroup* spacingBG = new QButtonGroup( i18n( "Line spacing" ), this );
  QHBoxLayout* spacingHL = new QHBoxLayout( spacingBG, 20, 3 );
  toplevelVL->addWidget( spacingBG );

  spacingCO = new QComboBox( false, spacingBG );
  spacingCO->insertItem( "Single", 
			  ParagraphDialogData::Single );
  spacingCO->insertItem( "OneHalf", ParagraphDialogData::Onehalf );
  spacingCO->insertItem( "Double", ParagraphDialogData::Double );
  spacingCO->insertItem( "Other", ParagraphDialogData::Other );
  spacingCO->insertItem( "LayoutDefault", 
			  ParagraphDialogData::LayoutDefault);
  spacingCO->adjustSize();
  spacingHL->addWidget( spacingCO, 1 );
  spacingCO->setFixedHeight( spacingCO->height() );
  spacingCO->setMinimumWidth( spacingCO->width() );

  spacingED = new QLineEdit( spacingBG );
  spacingED->adjustSize();
  spacingED->setFixedHeight( spacingCO->height() );
  spacingED->setMinimumWidth( spacingED->width() );
  spacingHL->addWidget( spacingED, 2 );
  connect( spacingED, SIGNAL( textChanged( const char* ) ),
		   SLOT( spacingTextChanged( const char * ) ) );
  spacingHL->activate();


  QHBoxLayout *labelwidthHL = new QHBoxLayout(10);
  toplevelVL->addLayout(labelwidthHL, 0);
  
  labelwidthED = new QLineEdit( this );
  labelwidthED->adjustSize();
  labelwidthED->setMinimumSize(labelwidthED->size());
  labelwidthED->setMaximumHeight(labelwidthED->height());
  
  labelwidthLA = new QLabel( labelwidthED, i18n( "&Label Width:" ), this);
  labelwidthLA->adjustSize();
  labelwidthLA->setMinimumSize(labelwidthLA->size());
  labelwidthHL->addWidget(labelwidthLA, 0);

  labelwidthHL->addWidget(labelwidthED, 1);

  QHBoxLayout *buttonsHL = new QHBoxLayout();
  toplevelVL->addLayout(buttonsHL, 0);
  
  extraoptPB = new QPushButton( i18n( "E&xtra Options" ), this );
  extraoptPB->adjustSize();
  extraoptPB->setMinimumSize(extraoptPB->size());
  extraoptPB->setMaximumHeight(extraoptPB->height());
  buttonsHL->addWidget(extraoptPB, 2);
  connect( extraoptPB, SIGNAL(clicked()), SLOT(showExtraOptionsDialog()) );

  buttonsHL->addStretch(2);
  okPB = new QPushButton( i18n( "OK" ), this );
  okPB->adjustSize();
  okPB->setMinimumSize(okPB->size());
  okPB->setMaximumHeight(okPB->height());
  buttonsHL->addWidget(okPB, 1);
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( applyClicked() ) );
  connect( okPB, SIGNAL( clicked() ), SLOT( hide()) );

  applyPB = new QPushButton( i18n( "&Apply" ), this );
  applyPB->adjustSize();
  applyPB->setMinimumSize(applyPB->size());
  applyPB->setMaximumHeight(applyPB->height());
  buttonsHL->addWidget(applyPB, 1);
  connect( applyPB, SIGNAL( clicked() ), SLOT( applyClicked() ) );

  cancelPB = new QPushButton( i18n( "Close" ), this );
  cancelPB->adjustSize();
  cancelPB->setMinimumSize(cancelPB->size());
  cancelPB->setMaximumHeight(cancelPB->height());
  buttonsHL->addWidget(cancelPB, 1);
  connect( cancelPB, SIGNAL( clicked() ), SLOT( hide() ) );

  toplevelVL->activate();
  resize(10,10);
  setCaption( i18n( "Paragraph Environment" ) );
}


ParagraphDialog::~ParagraphDialog()
{
}


void ParagraphDialog::setData( ParagraphDialogData* data )
{
  switch( data->alignment )
	{
	case ParagraphDialogData::Right:
	  rightRB->setChecked( true );
	  break;
	case ParagraphDialogData::Left:
	  leftRB->setChecked( true );
	  break;
	case ParagraphDialogData::Block:
	  blockRB->setChecked( true );
	  break;
	case ParagraphDialogData::Center:
	  centerRB->setChecked( true );
	  break;
	};

  abovelinesCB->setChecked( data->lines_above );
  belowlinesCB->setChecked( data->lines_below );
  abovepagebreakCB->setChecked( data->pagebreaks_above );
  belowpagebreakCB->setChecked( data->pagebreaks_below );
  abovespaceCO->setCurrentItem( data->vertical_spaces_above );
  belowspaceCO->setCurrentItem( data->vertical_spaces_below );
  abovespaceED->setText( data->space_above );
  belowspaceED->setText( data->space_below );
  abovespacekeepCB->setChecked( data->space_keep_above );
  belowspacekeepCB->setChecked( data->space_keep_below );
  noindentCB->setChecked( data->noindent );
  labelwidthED->setText( data->label_width );
  spacingCO->setCurrentItem( data->spacing);
  spacingED->setText( data->spacing_length );
}

static ParagraphDialogData tempdata;

ParagraphDialogData* ParagraphDialog::data() const
{
  if( rightRB->isChecked() )
	tempdata.alignment = ParagraphDialogData::Right;
  else if( leftRB->isChecked() )
	tempdata.alignment = ParagraphDialogData::Left;
  else if( blockRB->isChecked() )
	tempdata.alignment = ParagraphDialogData::Block;
  else if( centerRB->isChecked() )
	tempdata.alignment = ParagraphDialogData::Center;
  else
	lyxerr_debug( "Cannot determine value for ParagraphDialogData::alignment" );

  tempdata.lines_above = abovelinesCB->isChecked();
  tempdata.lines_below = belowlinesCB->isChecked();
  tempdata.pagebreaks_above = abovepagebreakCB->isChecked();
  tempdata.pagebreaks_below = belowpagebreakCB->isChecked();
  tempdata.vertical_spaces_above = 
	(ParagraphDialogData::VerticalSpaces)abovespaceCO->currentItem();
  tempdata.vertical_spaces_below = 
	(ParagraphDialogData::VerticalSpaces)belowspaceCO->currentItem();
  tempdata.space_above = abovespaceED->text();
  tempdata.space_below = belowspaceED->text();
  tempdata.space_keep_above = abovespacekeepCB->isChecked();
  tempdata.space_keep_below = belowspacekeepCB->isChecked();
  tempdata.noindent = noindentCB->isChecked();
  tempdata.label_width = labelwidthED->text();
  tempdata.spacing = (ParagraphDialogData::Spacing)spacingCO->currentItem();
  tempdata.spacing_length = spacingED->text();

  return &tempdata;
}


void ParagraphDialog::applyClicked()
{
  emit apply();
}


void ParagraphDialog::activate()
{
  okPB->setEnabled( true );
  applyPB->setEnabled( true );
}


void ParagraphDialog::deactivate()
{
  okPB->setEnabled( false );
  applyPB->setEnabled( false );
}



void ParagraphDialog::spacingTextChanged( const char* text )
{
  if( text && text[0] )
	  spacingCO->setCurrentItem( ParagraphDialogData::Other );
}



void ParagraphDialog::showExtraOptionsDialog()
{
  ParagraphExtraDialog dlg;
  dlg.updateData();
  int ret = dlg.exec();
  if( ret == QDialog::Accepted )
	dlg.applyData();
}


ParagraphDialogReceiver::ParagraphDialogReceiver( ParagraphDialog* dlg )
{
  QObject::connect( dlg, SIGNAL( apply() ), this, SLOT( apply() ) );
  _dlg = dlg;

  QObject::connect( dlg->abovespaceCO, SIGNAL( activated( int ) ),
					this, SLOT( comboSpaceAbove( int ) ) );
  QObject::connect( dlg->belowspaceCO, SIGNAL( activated( int ) ),
					this, SLOT( comboSpaceBelow( int ) ) );
  QObject::connect( dlg->abovespaceED, SIGNAL( textChanged( const char* ) ),
					this, SLOT( editSpaceAbove( const char* ) ) );
  QObject::connect( dlg->belowspaceED, SIGNAL( textChanged( const char* ) ),
					this, SLOT( editSpaceBelow( const char* ) ) );
  QObject::connect( dlg->spacingCO, SIGNAL( activated( int ) ),
					this, SLOT( comboSpacing( int ) ) );
  QObject::connect( dlg->spacingED, SIGNAL( textChanged( const char* ) ),
					this, SLOT( editSpacing( const char* ) ) );
}

ParagraphDialogReceiver::~ParagraphDialogReceiver()
{
  QObject::disconnect( _dlg, SIGNAL( apply() ), this, SLOT( apply() ) );
}


void ParagraphDialogReceiver::apply()
{
  ParagraphApplyCB();
}


void ParagraphDialogReceiver::comboSpaceAbove( int selection )
{
  ParagraphVSpaceCB_SpaceAboveCombo( selection );
}


void ParagraphDialogReceiver::comboSpaceBelow( int selection )
{
  ParagraphVSpaceCB_SpaceBelowCombo( selection );
}


void ParagraphDialogReceiver::editSpaceAbove( const char* text )
{
  ParagraphVSpaceCB_SpaceAboveEdit( text );
}

void ParagraphDialogReceiver::editSpaceBelow( const char* text )
{
  ParagraphVSpaceCB_SpaceBelowEdit( text );
}


void ParagraphDialogReceiver::comboSpacing( int selection )
{
  if (selection != ParagraphDialogData::Other)
    _dlg->spacingED->setText("");

}


void ParagraphDialogReceiver::editSpacing( const char* text )
{  
  if (_dlg->spacingCO->currentItem() != ParagraphDialogData::Other)
    _dlg->spacingCO->setCurrentItem(ParagraphDialogData::Other);
}

/*
 * $Log: ParagraphDialog.C,v $
 * Revision 1.12  1998/08/05 11:04:15  kuepper
 * Added type specifiers to some variable declarations. Added return type
 * specifiers to several functions extern declarations.
 *
 * Revision 1.11  1998/04/14 16:08:54  ettrich
 * Matthias: fixed lots of nasty bug (should no longer segfault when
 *   exiting :-)
 *
 * Revision 1.10  1998/03/18 18:00:18  kulow
 * OK, the dialog looks now a little bit better. At least no overlapping
 * widgets anymore. I think the problem was a bug in QGridLayout, I will
 * ask Arnt about it.
 *
 * Revision 1.9  1998/03/16 21:06:43  kalle
 * Paragraph looks a *little* bit less ugly now
 *
 * Revision 1.8  1998/03/12 15:32:19  ettrich
 * Matthias:
 *
 *       spacing for paragraphs, bugfixes, cleanups
 *
 * Revision 1.7  1998/03/09 22:06:05  kalle
 * Towards 0.8.4...
 *
 * Loads of fixes and changes:
 * - added KFileDialog. --enable-kfiledialog uses it, otherwise QFileDialog is used
 * - font loading now faster and more robust
 * - prepared ParagraphDialog for line skips per paragraph (some code from Matthias is still missing)
 * - Changed the way the menus are created
 *
 * KLyX NOW REQUIRES QT 1.32!!!
 *
 * Revision 1.6  1998/03/09 11:28:10  kulow
 * fixed several problems found by purify
 *
 * Revision 1.5  1998/03/07 14:35:37  kulow
 * added some Row and Col stretch factors, but I still don't get it to display
 * correctly ;(
 *
 * Revision 1.4  1998/03/06 18:57:29  kulow
 * implemented GM for another dialog.
 * Note: something weired is going on, if you make it smaller, but I have
 * currently no idea why. So I need a break and perhaps I get an idea ;)
 *
 * Revision 1.3  1998/02/03 23:41:57  kalle
 * BulletShapeDialog sort of works
 * It took me two Maribo Pilsner to get this far!
 * Still no images in BulletShapeDialog (will add these tomorrow)
 *
 * Revision 1.2  1998/01/28 22:44:19  kalle
 * activated new ParagraphExtraDialog (still buggy, and I don't understand
 * the options anyway :-))
 * 1626 XForms calls left (this was a good one)
 * fixed a bug in the document layout dialog
 *
 * Revision 1.1.1.1  1997/12/14 21:19:34  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.4  1997/11/27 08:56:34  kalle
 * ParagraphDialog works
 *
 * Revision 1.3  1997/11/27 01:12:47  kalle
 * ParagraphDialog attached
 *
 * Revision 1.2  1997/11/26 19:22:19  kalle
 * First KDE dialog visible
 *
 * Revision 1.1  1997/11/26 16:11:14  kalle
 * Kalle: First dialogs for LyX
 *
 * Revision 1.3  1997/11/16 22:07:29  kalle
 * added CharacterStyleDialog
 *
 * Revision 1.2  1997/11/15 22:11:53  kalle
 * ParagraphExtraDialog added
 *
 * Revision 1.1  1997/11/15 20:51:49  kalle
 * ParagraphDialog added
 *
 *
 */
