/*
 * $Id: MathSpacingDialog.C,v 1.4 1999/01/05 11:16:44 kulow Exp $
 */

#include "MathSpacingDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qpushbt.h>
#include <qradiobt.h>

#include "LyXView.h"
#include "commandtags.h"
#include "lyxfunc.h"

static char const *latex_mathspace[] = {
   "!", ",", ":", ";", "quad", "qquad"
};

MathSpacingDialog::MathSpacingDialog( LyXView* view, QWidget * parent=0, 
									  const char * name=0, 
									  WFlags f=0 ) :
  QDialog( parent, name, false, f ),
  _view( view )
{
  QButtonGroup* spacingBG = new QButtonGroup( this );
  spacingBG->hide(); // this group is just to group the buttons
  
  thinRB = new QRadioButton( i18n( "&Thin" ), this );
  thinRB->setGeometry( 20, 10, 100, 30 );
  spacingBG->insert( thinRB );

  mediumRB = new QRadioButton( i18n( "&Medium" ), this );
  mediumRB->setGeometry( 20, 50, 100, 30 );
  spacingBG->insert( mediumRB );

  thickRB = new QRadioButton( i18n( "&Thick" ), this );
  thickRB->setGeometry( 20, 90, 100, 30 );
  spacingBG->insert( thickRB );

  negativeRB = new QRadioButton( i18n( "&Negative" ), this );
  negativeRB->setGeometry( 130, 10, 100, 30 );
  spacingBG->insert( negativeRB );

  squareinchRB = new QRadioButton( i18n( "&Square inch" ), this );
  squareinchRB->setGeometry( 130, 50, 100, 30 );
  spacingBG->insert( squareinchRB );

  twosquareinchesRB = new QRadioButton( i18n( "T&wo square inches" ), this );
  twosquareinchesRB->setGeometry( 130, 90, 100, 30 );
  spacingBG->insert( twosquareinchesRB );

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 10, 140, 80, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* applyPB = new QPushButton( i18n( "Apply" ), 
										  this );
  applyPB->setGeometry( 100, 140, 80, 30 );
  connect( applyPB, SIGNAL( clicked() ), SLOT( applyClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), 
										   this );
  cancelPB->setGeometry( 190, 140, 80, 30 );
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );

  setCaption( i18n( "Spacing" ) );
  setSpacing( MATHSPACING_THIN );
}


void MathSpacingDialog::okClicked()
{
	applyClicked();
	accept();
}


void MathSpacingDialog::cancelClicked()
{
	reject();
}


void MathSpacingDialog::applyClicked()
{
  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, 
								 latex_mathspace[ spacing() ] );
}


void MathSpacingDialog::setSpacing( int spacing )
{
  switch( spacing )
	{
	case MATHSPACING_THIN:
	  thinRB->setChecked( true );
	  break;
	case MATHSPACING_MEDIUM:
	  mediumRB->setChecked( true );
	  break;
	case MATHSPACING_THICK:
	  thickRB->setChecked( true );
	  break;
	case MATHSPACING_NEGATIVE:
	  negativeRB->setChecked( true );
	  break;
	case MATHSPACING_SQUAREINCH:
	  squareinchRB->setChecked( true );
	  break;
	case MATHSPACING_TWOSQUAREINCHES:
	  twosquareinchesRB->setChecked( true );
	  break;
	};
}


int MathSpacingDialog::spacing() const
{
  if( thinRB->isChecked() )
	return MATHSPACING_THIN;
  else if( mediumRB->isChecked() )
	return MATHSPACING_MEDIUM;
  else if( thickRB->isChecked() )
	return MATHSPACING_THICK;
  else if( negativeRB->isChecked() )
	return MATHSPACING_NEGATIVE;
  else if( squareinchRB->isChecked() )
	return MATHSPACING_SQUAREINCH;
  else
	return MATHSPACING_TWOSQUAREINCHES;
}



/*
 * $Log: MathSpacingDialog.C,v $
 * Revision 1.4  1999/01/05 11:16:44  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.3  1998/03/11 19:12:02  kalle
 * More dialogs Qt-ified
 *
 * Revision 1.2  1998/03/03 22:36:23  kulow
 * removed all those ->show(), they make me crazy
 *
 * Revision 1.1  1998/01/09 19:51:12  kalle
 * Math matrix and math spacing dialogs added
 *
 */
