/*
 * $Id: MathMatrixDialog.h,v 1.2 1998/03/11 19:12:01 kalle Exp $
 */

#ifndef _MATHMATRIXDIALOG_H
#define _MATHMATRIXDIALOG_H

#include <qdialog.h>
#include <qvalidator.h>

class QComboBox;
class QLCDNumber;
class QLineEdit;
class QSlider;

class LyXView;

struct MathMatrixDialogData
{
  int num_rows;
  int num_cols;
  QString horz_align;
  enum VerticalAlign { Top, Center, Buttom };
  VerticalAlign vert_align;
};


class MathMatrixDialog : public QDialog
{
friend class MathHorzAlignmentValidator;

  Q_OBJECT

public:
  MathMatrixDialog ( LyXView* view, QWidget * parent=0, const char * name=0, 
					 WFlags f=0 );

  void setData( MathMatrixDialogData* );
  MathMatrixDialogData* data() const;

private slots:
  void columnValueChanged( int );

private:
  LyXView* _view;
  
  QSlider* rowsSL;
  QLCDNumber* rowsLC;

  QSlider* columnsSL;
  QLCDNumber* columnsLC;

  QLineEdit* horzalignmentED;
  MathHorzAlignmentValidator* horzalignmentVA;
  QComboBox* vertalignmentCB;
};


class MathHorzAlignmentValidator : public QValidator
{
public:
  MathHorzAlignmentValidator( MathMatrixDialog* owner ) :
	QValidator( owner, "" ), _owner ( owner ) {};

  QValidator::State MathHorzAlignmentValidator::validate( QString& input, 
														  int& pos );

private:
  MathMatrixDialog* _owner;
};

#endif

/*
 * $Log: MathMatrixDialog.h,v $
 * Revision 1.2  1998/03/11 19:12:01  kalle
 * More dialogs Qt-ified
 *
 * Revision 1.1  1998/01/09 19:51:12  kalle
 * Math matrix and math spacing dialogs added
 *
 */
