#include <config.h>

#include <kapp.h>
#include <klocale.h>

#include "lyx_main.h"
#include "lyxrc.h"
#include "LString.h"
#include "filetools.h"
#include "pathstack.h"
#include "buffer.h"
#include "lyx_gui_misc.h"
#include "syscall.h"
#include "lyx_cb.h"
#include "klyx.h"
#include "ExportCustomDialog.h"
#include "LyXView.h"

// 	$Id: LyXSendto.C,v 1.5 1998/08/05 11:04:14 kuepper Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: LyXSendto.C,v 1.5 1998/08/05 11:04:14 kuepper Exp $";
#endif /* lint */

/* Prototypes */
extern BufferView *current_view;
extern int MakeDVIOutput(Buffer *buffer);
extern bool MenuRunDvips(Buffer *buffer, bool wait);

// Whereas this feature is under the menu item File->Export->Custom,
// I kept the old name sendto in the code because I am lazy (JMarc)

void MenuSendto()
{
  if( !klyxdialogs->exportcustom )
	  klyxdialogs->exportcustom = new ExportCustomDialog( current_view->getOwner() );

  // do this only if the command is empty
  ExportCustomDialogData* dlg_data = klyxdialogs->exportcustom->data();
  if( !dlg_data->command.isEmpty() && 
	  !lyxrc->custom_export_command.empty() )
	{
	  dlg_data->command = lyxrc->custom_export_command.c_str();
	  klyxdialogs->exportcustom->setData( dlg_data );
	}
  
  (void)klyxdialogs->exportcustom->exec();
}
