/*
 * $Id: InsertFigureDialog.C,v 1.4 1999/04/21 14:01:28 kuepper Exp $
 */

#include "InsertFigureDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qlayout.h>

InsertFigureDialog::InsertFigureDialog( QWidget * parent=0, 
					const char * name=0, 
					WFlags f=0 ) :
  QDialog( parent, name, true, f )
{
  QVBoxLayout *vlayout = new QVBoxLayout(this, 10);
  QHBoxLayout *hlayout = new QHBoxLayout(5);
  
  QButtonGroup *typeBG = new QButtonGroup( i18n( "Type" ), this);
  QVBoxLayout *vlayout2 = new QVBoxLayout(typeBG, 16, 5);
   
  vlayout->addWidget(typeBG, 5);
  vlayout->addLayout(hlayout, 1);
  
  EPSRB = new QRadioButton( i18n( "&Encapsulated Postscript (*.eps, *.ps)" ), typeBG );
  EPSRB->adjustSize();
  EPSRB->setMinimumSize(EPSRB->size());
  vlayout2->addWidget(EPSRB);
  EPSRB->setChecked( true );

  inlineRB = new QRadioButton( i18n( "&Inlined EPS (*.eps, *.ps)" ), typeBG );
  inlineRB->adjustSize();
  inlineRB->setMinimumSize(inlineRB->size());
  vlayout2->addWidget(inlineRB);
  inlineRB->setChecked( false );

  vlayout2->activate();

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->adjustSize();
  okPB->setFixedHeight(okPB->height());
  okPB->setMinimumWidth(okPB->width());
  hlayout->addStretch(1);
  hlayout->addWidget(okPB,3);
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( accept() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), this);
  cancelPB->adjustSize();
  cancelPB->setFixedHeight(cancelPB->height());
  cancelPB->setMinimumWidth(cancelPB->width());
  hlayout->addStretch(1);
  hlayout->addWidget(cancelPB,3);
  hlayout->addStretch(1);
  connect( cancelPB, SIGNAL( clicked() ), SLOT( reject() ) );

  vlayout->activate();

  // as small as possible
  resize(10,10);
  setCaption( i18n( "Insert figure" ) );
}


void InsertFigureDialog::setData( InsertFigureDialogData* data )
{
  switch( data->type )
	{
	case InsertFigureDialogData::EPS:
	  EPSRB->setChecked( true );
	  inlineRB->setChecked( false );
	  break;
	case InsertFigureDialogData::Inlined:
	  inlineRB->setChecked( true );
	  EPSRB->setChecked( false );
	  break;
	default:
	  lyxerr_debug( "Unknown enum for InsertFigureDialogData::Type" );
	};
}


static InsertFigureDialogData tempdata;

InsertFigureDialogData* InsertFigureDialog::data() const
{
  if( EPSRB->isChecked() )
	tempdata.type = InsertFigureDialogData::EPS;
  else if( inlineRB->isChecked() )
	tempdata.type = InsertFigureDialogData::Inlined;
  else
	lyxerr_debug( "Cannot determine value for InsertFigureDialogData::type" );

  return &tempdata;
}


/*
 * $Log: InsertFigureDialog.C,v $
 * Revision 1.4  1999/04/21 14:01:28  kuepper
 * Enhanced file filters when importing figures.
 *
 * Revision 1.3  1998/03/03 19:51:28  kulow
 * Roberto is my hero ;-)
 *
 * Revision 1.2  1998/03/02 21:13:39  kalle
 * Kalle: Started to make dialogs more Qt-like
 *
 * Revision 1.1.1.1  1997/12/14 21:19:44  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.2  1997/12/04 22:10:03  kalle
 * Make distributions
 *
 * Revision 1.1  1997/12/04 20:19:08  kalle
 * Qt-based InsertFigureDialog
 *
 */
