/*
 * $Id: InsertErrorDialog.C,v 1.3 1999/01/05 11:16:30 kulow Exp $
 */

#include "InsertErrorDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qmlined.h>
#include <qpushbt.h>

InsertErrorDialog::InsertErrorDialog( LyXView* view, QWidget * parent=0, 
									  const char * name=0, 
									  WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  errorML = new QMultiLineEdit( this );
  errorML->setGeometry( 10, 10, 380, 180 );
  errorML->setReadOnly( true );
  
  QPushButton* closePB = new QPushButton( i18n( "Close" ), 
										  this );
  closePB->setGeometry( 180, 290, 140, 30 );
  closePB->setDefault( true );
  connect( closePB, SIGNAL( clicked() ), SLOT( closeClicked() ) );

  setCaption( i18n( "LaTeX Error" ) );
}


void InsertErrorDialog::closeClicked()
{
  accept();
}


void InsertErrorDialog::setError( const char* text )
{
  errorML->setText( text );
}



/*
 * $Log: InsertErrorDialog.C,v $
 * Revision 1.3  1999/01/05 11:16:30  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.2  1998/03/02 21:13:36  kalle
 * Kalle: Started to make dialogs more Qt-like
 *
 * Revision 1.1  1998/02/16 20:20:56  kalle
 * Kalle: First XForms-free version
 *
 */
