/*
 * $Id: FindReplaceDialog.h,v 1.3 1999/01/28 09:57:58 kuepper Exp $
 */

#ifndef _FINDREPLACEDIALOG_H
#define _FINDREPLACEDIALOG_H

#include <qdialog.h>
#include <qstring.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qcheckbox.h>

class LyXView;

class FindReplaceDialog : public QDialog
{
  Q_OBJECT

public:
  FindReplaceDialog ( LyXView* view, QWidget * parent=0, const char * name=0, 
					  WFlags f=0 );

  QString getSearchText() const { return findED->text(); }
  QString getReplaceText() const { return replaceED->text(); }
  void setSearchText( QString _text ) { findED->setText( _text ); }
  bool isCaseSensitive() const { return casesensitiveCB->isChecked(); }
  bool isMatchWord() const { return matchwordCB->isOn(); }
  void setReplaceEnabled( bool _enable );

private slots:
  void replaceClicked();
  void replaceAllClicked();
  void backwardClicked();
  void forwardClicked();

private:
  LyXView* _view;

  QLineEdit* findED;
  QLineEdit* replaceED;
  QPushButton* replacePB;
  QPushButton* replaceAllPB;
  QCheckBox* casesensitiveCB;
  QCheckBox* matchwordCB;
};


#endif

/*
 * $Log: FindReplaceDialog.h,v $
 * Revision 1.3  1999/01/28 09:57:58  kuepper
 * Daniel Nabers enhancements of the Find&Replace dialog + some tweaks.
 *
 * Revision 1.2  1998/03/15 07:11:13  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/01/27 20:42:58  kalle
 * Implemented new find and replace dialog
 * 1839 XForms calls left!
 *
 */
