// This file is part of KLyX, The Document Processor
//
// Copyright (C) 1995 Matthias Ettrich
// Copyright (C) 1997-1999 KLyX Team

#include "FindReplaceDialog.h"

#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>

#include <qgrpbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qlayout.h>
#include "LyXView.h"

FindReplaceDialog::FindReplaceDialog( LyXView *view, QWidget *parent=0,
				      const char *name=0, WFlags f=0 )
    : QDialog( parent, name, false, f ),
      _view( view )
{
    // toplevel layout
    QVBoxLayout *vlayout1 = new QVBoxLayout( this, 10 );
    // the line edits
    QGridLayout *grid  = new QGridLayout( 3, 2, 5 );
    // the replace buttons
    QHBoxLayout *hlayout1 = new QHBoxLayout( 8 );
  
    vlayout1->addStretch( 2 );
    vlayout1->addLayout( grid, 1 );
    vlayout1->addStretch( 2 );
  
    QLabel* findLA = new QLabel( i18n( "&Find" ), this );
    findLA->adjustSize();
    findLA->setMinimumSize( findLA->size() );
    grid->addWidget( findLA, 0, 0 );
    findLA->setAlignment( AlignVCenter | AlignRight );
    findED = new QLineEdit( this );
    findED->adjustSize();
    findED->setFixedHeight( findED->height() );
    findED->setFocus();
    findED->setMinimumWidth( findED->width() );
    grid->addWidget( findED, 0, 1 );
    findLA->setBuddy( findED );

    QLabel* replaceLA = new QLabel( i18n( "Replace &with" ), this );
    replaceLA->adjustSize();
    replaceLA->setMinimumSize(replaceLA->size());
    grid->addWidget(replaceLA, 1, 0);
    replaceLA->setAlignment( AlignVCenter | AlignRight );
    grid->setColStretch(0, 1);
    grid->setColStretch(1, 5);
    replaceED = new QLineEdit( this );
    replaceED->adjustSize();
    replaceED->setFixedHeight( replaceED->height() );
    replaceED->setMinimumWidth( replaceED->width() );
    grid->addWidget( replaceED, 1, 1 );
    replaceLA->setBuddy( replaceED );
    grid->addLayout( hlayout1, 2, 1 );

    KIconLoader* loader = kapp->getIconLoader();
    QPushButton* backwardPB = new QPushButton( this );
    hlayout1->addWidget( backwardPB );
    backwardPB->setPixmap( loader->loadIcon( "left.xpm" ) );
    backwardPB->adjustSize();
    backwardPB->setFixedSize( backwardPB->size() );
    QObject::connect( backwardPB, SIGNAL( clicked() ), this, SLOT( backwardClicked() ) );

    QPushButton* forwardPB = new QPushButton( this );
    hlayout1->addWidget( forwardPB );
    forwardPB->setPixmap( loader->loadIcon( "right.xpm" ) );
    forwardPB->adjustSize();
    forwardPB->setFixedSize( forwardPB->size() );
    QObject::connect( forwardPB, SIGNAL( clicked() ), this, SLOT( forwardClicked() ) );

    replacePB = new QPushButton( i18n( "&Replace" ), this );
    replacePB->adjustSize();
    replacePB->setFixedHeight( replacePB->height() );
    replacePB->setMinimumWidth( replacePB->width() );
    hlayout1->addWidget( replacePB );
    QObject::connect( replacePB, SIGNAL( clicked() ), this, SLOT( replaceClicked() ) );

    replaceAllPB = new QPushButton( i18n( "Replace &All" ), this );
    replaceAllPB->adjustSize();
    replaceAllPB->setFixedHeight(replaceAllPB->height());
    replaceAllPB->setMinimumWidth(replaceAllPB->width());
    hlayout1->addWidget(replaceAllPB);
    QObject::connect( replaceAllPB, SIGNAL( clicked() ), this, SLOT( replaceAllClicked() ) );

    QGroupBox* optionsGB = new QGroupBox( i18n( "Options" ), this );
    vlayout1->addWidget(optionsGB, 0);
    // the options
    QVBoxLayout *vlayout2 = new QVBoxLayout(optionsGB, 18, 5);
    vlayout2->addStretch(1);

    casesensitiveCB = new QCheckBox( i18n( "Ca&se sensitive" ), optionsGB);
    casesensitiveCB->adjustSize();
    casesensitiveCB->setFixedHeight(casesensitiveCB->height());
    casesensitiveCB->setMinimumWidth(casesensitiveCB->width());
    vlayout2->addWidget(casesensitiveCB, 3, AlignCenter);
    vlayout2->addStretch(1);
    casesensitiveCB->setChecked( false );
  
    matchwordCB = new QCheckBox( i18n( "&Match word" ), optionsGB);
    matchwordCB->adjustSize();
    matchwordCB->setFixedHeight(matchwordCB->height());
    matchwordCB->setMinimumWidth(matchwordCB->width());
    vlayout2->addWidget(matchwordCB, 3);
    vlayout2->addStretch(1);
    vlayout2->activate();
    matchwordCB->setChecked( false );

    QPushButton* closePB = new QPushButton( i18n( "&Close" ), this );
    closePB->adjustSize();
    closePB->setMinimumSize( closePB->size() );
    closePB->setMaximumSize( closePB->width() * 3 / 2, closePB->height() );
  
    vlayout1->addWidget(closePB, 0);
    vlayout1->addStretch(2);
    QObject::connect( closePB, SIGNAL( clicked() ), this, SLOT( hide() ) );
    vlayout1->activate();
    resize(10, 10);

    setCaption( i18n( "Find and Replace" ) );
}


void FindReplaceDialog::replaceClicked()
{
    _view->getFR()->SearchReplaceCB();
}


void FindReplaceDialog::replaceAllClicked()
{
    _view->getFR()->SearchReplaceAllCB();
}


void FindReplaceDialog::backwardClicked()
{
    _view->getFR()->SearchCB( false );
}


void FindReplaceDialog::forwardClicked()
{
    _view->getFR()->SearchCB( true );
}


void FindReplaceDialog::setReplaceEnabled( bool _enable )
{
    replaceED->setEnabled( _enable );
    replacePB->setEnabled( _enable );
}


// Local Variables:
// mode: C++
// c-file-style: "Stroustrup"
// End:
