// -*- C++ -*-
/*
 * $Id: DocumentLayoutDialog.h,v 1.10 1999/04/15 13:33:12 kuepper Exp $
 */

#ifndef _DOCUMENTLAYOUTDIALOG_H
#define _DOCUMENTLAYOUTDIALOG_H

#include <qdialog.h>
#include <qpushbt.h>
#include <qstring.h>

#include "lyxdummies.h"

class QButtonGroup;
class QCheckBox;
class QComboBox;
class QLabel;
class QLCDNumber;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QSlider;

struct DocumentLayoutDialogData
{
  int _class;

  enum Pagestyle { PageStyleDefault, Empty, Plain, Headings, Fancy };
  Pagestyle pagestyle;

  // FIXME: These are probably not hard-coded but retrieved from the server
  enum Fonts { FontsDefault, Times, Palatino, Helvet, Avant, NewCent, 
			   Bookman };
  Fonts fonts;

  enum FontSize { FontSizeDefault, FontSize10, FontSize11, FontSize12 };
  FontSize font_size;

  // FIXME: These are probably not hard-coded as well
  enum Language { LanguageDefault, Afrikaans, American, Austrian, Bahasa, 
				  Brazil, Breton, Catalan, Croatian, Czech, Danish, Dutch,
				  English, Esperanto, Estonian, Finnish, French, Frenchb,
				  Galician, German, Greek, Hungarian, Irish, Italian, Isorbian,
				  Magyar, Norwegian, Polish, Portuguese, Romanian, Russian,
				  Scottish, Slovak, Slovene, Spanish, Turkish, Usorbian, Welsh
  };
  Language language;

  enum PSDriver { PSDriverDefault, Dvips, Dvitops, Emtex, Ln, Oztex, 
				  Textures, PSDriverNone };
  PSDriver ps_driver;

  enum Encoding { EncodingDefault, Latin1, Latin2, Latin5 };
  Encoding encoding;

  enum DefaultSkip { Smallskip, Medskip, Bigskip, Length };
  DefaultSkip default_skip;
  QString default_skip_length;

  enum Spacing { Single, Onehalf, Double, Other };
  Spacing spacing;
  QString spacing_length;

  enum Sides { OneSide, TwoSides };
  Sides sides;
  
  enum Columns { OneColumn, TwoColumns };
  Columns columns;

  enum Separation { Indent, Skip };
  Separation separation;

  QString float_placement;
  QString extra_options;

  ushort section_number_depth;
  ushort table_of_contents_depth;

  bool amsmath;
};


class DocumentLayoutDialog : public QDialog
{
friend class DocumentLayoutDialogReceiver;

  Q_OBJECT

public:
  DocumentLayoutDialog ( QWidget * parent=0, const char * name=0, 
						 WFlags f=0 ) ;
  ~DocumentLayoutDialog();
  void setData( DocumentLayoutDialogData* data );
  DocumentLayoutDialogData* data() const;
  void activateButtons() { okPB->setEnabled( true ); 
  						   applyPB->setEnabled( true ); }
  void deactivateButtons() { okPB->setEnabled( false ); 
  			   			     applyPB->setEnabled( false ); }
  void disable();
  void enable();

  QComboBox* fontsizeCombo() const { return fontsizeCO; }
  QComboBox* pagestyleCombo() const { return pagestyleCO; }
  QComboBox* classCombo() const { return classCO; }
  QPushButton* getBulletsButton() const { return bulletshapesPB; }

  int stringToClass( const QString& classString );
  DocumentLayoutDialogData::Language stringToLanguage( const QString& languageString );
  DocumentLayoutDialogData::Fonts stringToFonts( const QString& fontsString );
  DocumentLayoutDialogData::Encoding stringToEnc( const QString& encodingString );
  DocumentLayoutDialogData::PSDriver stringToPSDriver( const QString& psdriverString );

  QString numToFontString( int font );
  QString numToFontSizeString( int font_size );
  QString numToInputencString( int encoding );
  QString numToPageStyleString( int page_style );
  QString numToPostScriptDriverString( int ps_driver );
  QString numToLanguageString( int language );

signals:
  void apply();

private slots:
  void okClicked();
  void applyClicked();
  void defaultskipTextChanged( const char* text );
  void spacingTextChanged( const char* text );
  void showBulletShapes();
  void classComboActivated( int item );

private:
  QLabel* classLA;
  QLabel* pagestyleLA;
  QLabel* fontsLA;
  QLabel* fontsizeLA;
  QLabel* languageLA;
  QLabel* psdriverLA;
  QLabel* encodingLA;
  QLabel* defaultskipLA;
  QLabel* spacingLA;
  QComboBox* classCO;
  QComboBox* pagestyleCO;
  QComboBox* fontsCO;
  QComboBox* fontsizeCO;
  QComboBox* languageCO;
  QComboBox* psdriverCO;
  QComboBox* encodingCO;
  QComboBox* defaultskipCO;
  QLineEdit* defaultskipED;
  QComboBox* spacingCO;
	QLineEdit* spacingED;

  QButtonGroup* sidesBG;
  QRadioButton* sidesoneRB;
  QRadioButton* sidestwoRB;

  QButtonGroup* columnsBG;
  QRadioButton* columnsoneRB;
  QRadioButton* columnstwoRB;

  QButtonGroup* separationBG;
  QRadioButton* indentRB;
  QRadioButton* skipRB;

  QPushButton* bulletshapesPB;
  QCheckBox* amsmathCB;

  QLabel* floatplacementLA;
  QLineEdit* floatplacementED;

  QLabel* extraoptionsLA;
  QLineEdit* extraoptionsED;

  QLabel* secnumdepthLA;
  QSlider* secnumdepthSL;
  QLCDNumber* secnumdepthLC;

  QLabel* tocdepthLA;
  QSlider* tocdepthSL;
  QLCDNumber* tocdepthLC;

  QPushButton* okPB;
  QPushButton* cancelPB;
  QPushButton* applyPB;
};


class DocumentLayoutDialogReceiver : public QObject
{
friend class DocumentLayoutDialog;

  Q_OBJECT

public:
  DocumentLayoutDialogReceiver( DocumentLayoutDialog* );
  ~DocumentLayoutDialogReceiver();  

private slots:
  void apply();
  void comboDefaultSkip( int );
  void editDefaultSkip( const char* );
  void comboSpacing( int );
  void editSpacing( const char* );

private:
  DocumentLayoutDialog* _dlg;
};


#endif

/*
 * $Log: DocumentLayoutDialog.h,v $
 * Revision 1.10  1999/04/15 13:33:12  kuepper
 * Enhanced InsertCitationReferenceDialog: Group keys by bibtex database.
 *
 * Revision 1.9  1998/07/31 16:13:22  kuepper
 * QBoxLayout hlayout4 doesn't need to be activated, since it is a
 * child-layout of leftGR.
 *
 * Revision 1.8  1998/03/28 22:15:26  kalle
 * - Pagestyles in DocumentLayoutDialog are dynamically updated when changing text classes
 * - InsertCitationDialog starts up with correct bibliographic reference
 * - Added Goto button to DocumentStructureDialog
 */
