/*
 * $Id: BulletShapeDialog.C,v 1.9 1998/07/31 09:47:00 kuepper Exp $
 */

#include <qslider.h>

#include "BulletShapeDialog.h"

#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>

#include <qcombo.h>
#include <qbttngrp.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qlined.h>

#include "bufferparams.h"
#include "LyXView.h"

#define DEPTH1 0
#define DEPTH2 1
#define DEPTH3 2
#define DEPTH4 3

#define GROUPSTANDARD 0
#define GROUPMATH 1
#define GROUPDING1 2
#define GROUPDING2 3
#define GROUPDING3 4
#define GROUPDING4 5


BulletShapeDialog::BulletShapeDialog( LyXView* view, QWidget * parent=0,
				      const char * name=0, WFlags f=0 )
    : QDialog( parent, name, true, f ),
      _view( view )
{
  QButtonGroup* depthBG = new QButtonGroup( i18n( "Change bullet for depth" ), this );
  depthBG->setGeometry( 110, 0, 165, 53 );
  connect( depthBG, SIGNAL( clicked( int ) ), 
		   SLOT( depthChanged( int ) ) );

  depth1RB = new QRadioButton( i18n( "1" ), this );
  depth1RB->setGeometry( 120, 20, 30, 30 );
  depth1RB->setChecked( true );
  depthBG->insert( depth1RB, DEPTH1 );

  depth2RB = new QRadioButton( i18n( "2" ), this );
  depth2RB->setGeometry( 160, 20, 30, 30 );
  depthBG->insert( depth2RB, DEPTH2 );

  depth3RB = new QRadioButton( i18n( "3" ), this );
  depth3RB->setGeometry( 200, 20, 30, 30 );
  depthBG->insert( depth3RB, DEPTH3 );

  depth4RB = new QRadioButton( i18n( "4" ), this );
  depth4RB->setGeometry( 240, 20, 30, 30 );
  depthBG->insert( depth4RB, DEPTH4 );

  
  QButtonGroup* groupBG = new QButtonGroup( i18n( "Group" ), this);
  groupBG->setGeometry( 10, 50, 100, 210 );
  connect( groupBG, SIGNAL( clicked( int ) ),
		   SLOT( groupChanged( int ) ) );

  QRadioButton* standardRB = new QRadioButton( "Standard", this );
  standardRB->setGeometry( 20, 70, 80, 30 );
  standardRB->setChecked( true );
  groupBG->insert( standardRB, GROUPSTANDARD );

  QRadioButton* mathRB = new QRadioButton( "Math", this );
  mathRB->setGeometry( 20, 100, 80, 30 );
  groupBG->insert( mathRB, GROUPMATH );

  QRadioButton* ding1RB = new QRadioButton( "Ding1", this );
  ding1RB->setGeometry( 20, 130, 80, 30 );
  groupBG->insert( ding1RB, GROUPDING1 );

  QRadioButton* ding2RB = new QRadioButton( "Ding2", this );
  ding2RB->setGeometry( 20, 160, 80, 30 );
  groupBG->insert( ding2RB, GROUPDING2 );

  QRadioButton* ding3RB = new QRadioButton( "Ding3", this );
  ding3RB->setGeometry( 20, 190, 80, 30 );
  groupBG->insert( ding3RB, GROUPDING3 );

  QRadioButton* ding4RB = new QRadioButton( "Ding4", this );
  ding4RB->setGeometry( 20, 220, 80, 30 );
  groupBG->insert( ding4RB, GROUPDING4 );

  QButtonGroup* shapesBG = new QButtonGroup( this );
  shapesBG->hide();
  shapesBG->setExclusive( true );
  connect( shapesBG, SIGNAL( clicked( int ) ),
		   SLOT( bulletSelected( int ) ) );

  for( int i = 0; i < 6; i++ )
	{
	  for( int j = 0; j < 6; j++ )
		{
		  shapesPB[i*6+j] = new QPushButton( this );
		  shapesPB[i*6+j]->setGeometry( i*40+130, j*30+70, 40, 30 );
		  shapesBG->insert( shapesPB[i*6+j] );
		  shapesPB[i*6+j]->setToggleButton( true );
		};
	  pixmaps_loaded[ i ] = false;
	}

  QLabel* sizeLA = new QLabel( i18n( "Size:" ), this );
  sizeLA->setGeometry( 10, 270, 60, 30 );
  sizeLA->setAlignment( AlignVCenter | AlignRight );

  sizeCB = new QComboBox( false, this );
  sizeCB->setGeometry( 70, 270, 90, 30 );
  sizeCB->insertItem( "default" );
  sizeCB->insertItem( "tiny" );
  sizeCB->insertItem( "script" );
  sizeCB->insertItem( "footnote" );
  sizeCB->insertItem( "small" );
  sizeCB->insertItem( "normal" );
  sizeCB->insertItem( "large" );
  sizeCB->insertItem( "Large" );
  sizeCB->insertItem( "LARGE" );
  sizeCB->insertItem( "huge" );
  sizeCB->insertItem( "Huge" );
  connect( sizeCB, SIGNAL( activated( int ) ),
		   SLOT( sizeChanged( int ) ) );

  QLabel* latexLA = new QLabel( i18n( "LaTeX:" ), this );
  latexLA->setGeometry( 170, 270, 50, 30 );
  latexLA->setAlignment( AlignVCenter | AlignRight );

  latexED = new QLineEdit( this );
  latexED->setGeometry( 220, 270, 150, 30 );
  connect( latexED, SIGNAL( textChanged( const char* ) ),
		   SLOT( latexTextChanged( const char* ) ) );
  
  okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 80, 320, 100, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  cancelPB = new QPushButton( i18n( "Cancel" ), 
										   this );
  cancelPB->setGeometry( 200, 320, 100, 30 );
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );

  iconloader = kapp->getIconLoader();

  groupChanged( GROUPSTANDARD ); // initialize the first group of bullets
  
  setCaption( i18n( "Bullet Shapes" ) );
}


BulletShapeDialog::~BulletShapeDialog()
{
  for( int i = 0; i < 6; i++ )
	{
	  if( pixmaps_loaded[i] )
		{
		  for( int j = 0; j < 36; j++ )
			delete pixmaps[i][j];
		}
	}
}


void BulletShapeDialog::init()
{
  if( _view->currentBuffer()->isReadonly() )
	{
	  okPB->setEnabled( false );
	  sizeCB->setEnabled( false );
	  latexED->setEnabled( false );
	  for( int i = 0; i < 36; i++ )
		shapesPB[i]->setEnabled( false );
	}
  else
	{
	  okPB->setEnabled( true );
	  sizeCB->setEnabled( true );
	  latexED->setEnabled( true );
	  for( int i = 0; i < 36; i++ )
		shapesPB[i]->setEnabled( true );
	}

  depth1RB->setChecked( true );
  depth2RB->setChecked( false );
  depth3RB->setChecked( false );
  depth4RB->setChecked( false );
  current_bullet_depth = DEPTH1;
  groupChanged( GROUPSTANDARD );
  disconnect( latexED, SIGNAL( textChanged( const char* ) ),
			  this, SLOT( latexTextChanged( const char* ) ) );
  latexED->setText( _view->currentBuffer()->params.user_defined_bullets[0].c_str()) ;
  connect( latexED, SIGNAL( textChanged( const char* ) ),
		   SLOT( latexTextChanged( const char* ) ) );
  current_bullet_panel = GROUPSTANDARD;
}


void BulletShapeDialog::okClicked()
{
  /* update the bullet settings */
  BufferParams & param = _view->currentBuffer()->params;
  
  // a little bit of loop unrolling
  param.user_defined_bullets[0] = param.temp_bullets[0];
  param.user_defined_bullets[1] = param.temp_bullets[1];
  param.user_defined_bullets[2] = param.temp_bullets[2];
  param.user_defined_bullets[3] = param.temp_bullets[3];
  _view->currentBuffer()->markDirty();
  
  accept();
}


void BulletShapeDialog::cancelClicked()
{
  // this avoids confusion when reopening
  BufferParams & param = _view->currentBuffer()->params;
  param.temp_bullets[0] = param.user_defined_bullets[0];
  param.temp_bullets[1] = param.user_defined_bullets[1];
  param.temp_bullets[2] = param.user_defined_bullets[2];
  param.temp_bullets[3] = param.user_defined_bullets[3];
  
  reject();
}


void BulletShapeDialog::latexTextChanged( const char* newtext )
{
  BufferParams & param = _view->currentBuffer()->params;
  
  param.temp_bullets[current_bullet_depth].setText( newtext );
}


void BulletShapeDialog::groupChanged( int i )
{
  // load the bullets for the new depth if not already done
  if( !pixmaps_loaded[ i ] )
	{
	  pixmaps_loaded[ i ] = true;

	  switch( i )
		{
		case GROUPSTANDARD:
		  {
			QString filename;
			for( int j = 0; j < 36; j++ )
			  {
				filename.sprintf( "standard%d.xpm", j );
				pixmaps[i][j] = new QPixmap( iconloader->loadIcon( filename ) );
			  }
			break;
		  }
		case GROUPMATH:
		  {
		        QString filename;
			for( int j = 0; j < 36; j++ )
			  {
				filename.sprintf( "amssymb%d.xpm", j );
				pixmaps[i][j] = new QPixmap( iconloader->loadIcon( filename ) );
			  }
			break;
		  }
		case GROUPDING1:
		  {
			QString filename;
			for( int j = 0; j < 36; j++ )
			  {
				filename.sprintf( "psnfss1-%d.xpm", j );
				pixmaps[i][j] = new QPixmap( iconloader->loadIcon( filename ) );
			  }
			break;
		  }
		case GROUPDING2:
		  {
			QString filename;
			for( int j = 0; j < 36; j++ )
			  {
				filename.sprintf( "psnfss2-%d.xpm", j );
				pixmaps[i][j] = new QPixmap( iconloader->loadIcon( filename ) );
			  }
			break;
		  }
		case GROUPDING3:
		  {
			QString filename;
			for( int j = 0; j < 36; j++ )
			  {
				filename.sprintf( "psnfss3-%d.xpm", j );
				pixmaps[i][j] = new QPixmap( iconloader->loadIcon( filename ) );
			  }
			break;
		  }
		case GROUPDING4:
		  {
			QString filename;
			for( int j = 0; j < 36; j++ )
			  {
				filename.sprintf( "psnfss4-%d.xpm", j );
				pixmaps[i][j] = new QPixmap( iconloader->loadIcon( filename ) );
			  }
			break;
		  }
		}
	}

  // set the pixmaps
  for( int j = 0; j < 36; j++ )
	shapesPB[j]->setPixmap( *(pixmaps[i][j]) );

  current_bullet_panel = i;
}


void BulletShapeDialog::depthChanged( int new_depth )
{
  current_bullet_depth = new_depth;

  /* Should I do the following:                                 */
  /*  1. change to the panel that the current bullet belongs in */
  /*  2. show that bullet as selected                           */
  /*  3. change the size setting to the size of the bullet in Q.*/
  /*  4. display the latex equivalent in the latex box          */
  /*                                                            */
  /* I'm inclined to just go with 3 and 4 at the moment and     */
  /* maybe try to support the others later                      */
  BufferParams & param = _view->currentBuffer()->params;

  // Kalle: This is number 1 :-)
  int new_group = param.temp_bullets[current_bullet_depth].getFont();
  groupChanged( new_group );

  // Kalle: This is number 2
  for( int i = 0; i < 36; i++ )
	shapesPB[i]->setOn( false );
  shapesPB[param.temp_bullets[current_bullet_depth].getCharacter()]->setOn( true );

  // Kalle: no way to get a RMB click on a push button :-(
#warning defaults for bullet shapes not implemented
//  switch (fl_get_button_numb(ob)) {
//  case 3:
//	// right mouse button resets to default
//	param.temp_bullets[data] = ITEMIZE_DEFAULTS[data];
//  default:

  // Kalle: This is number 4
  disconnect( latexED, SIGNAL( textChanged( const char* ) ),
			  this, SLOT( latexTextChanged( const char* ) ) );
  latexED->setText( param.temp_bullets[new_depth].c_str());
  connect( latexED, SIGNAL( textChanged( const char* ) ),
		   SLOT( latexTextChanged( const char* ) ) );

  // Kalle: This is number 3
  sizeCB->setCurrentItem( param.temp_bullets[new_depth].getSize() + 1 );
}


void BulletShapeDialog::sizeChanged( int newsize )
{
  BufferParams & param = _view->currentBuffer()->params;
  
  // convert from 0-5 range to -1-4 
  param.temp_bullets[current_bullet_depth].setSize( newsize - 1 );
  disconnect( latexED, SIGNAL( textChanged( const char* ) ),
			  this, SLOT( latexTextChanged( const char* ) ) );
  latexED->setText( param.temp_bullets[current_bullet_depth].c_str() );
  connect( latexED, SIGNAL( textChanged( const char* ) ),
		   SLOT( latexTextChanged( const char* ) ) );
}


void BulletShapeDialog::bulletSelected( int new_bullet )
{
  BufferParams & param = _view->currentBuffer()->params;
  
  param.temp_bullets[current_bullet_depth].setFont(current_bullet_panel);
  param.temp_bullets[current_bullet_depth].setCharacter(new_bullet);
  disconnect( latexED, SIGNAL( textChanged( const char* ) ),
			  this, SLOT( latexTextChanged( const char* ) ) );
  latexED->setText( param.temp_bullets[current_bullet_depth].c_str());
  connect( latexED, SIGNAL( textChanged( const char* ) ),
		   SLOT( latexTextChanged( const char* ) ) );
}



/*
 * $Log: BulletShapeDialog.C,v $
 * Revision 1.9  1998/07/31 09:47:00  kuepper
 * Increased version number to 0.9.7pre to make it consistent with releases,
 * since 0.9.6 is available already.
 * Changed several C-style casts to C++-style casts.
 * Renamed KLYX_CHANGES to ChangeLog.
 * Fixes.
 *
 * Revision 1.8  1998/05/17 15:57:54  schreter
 *
 *
 * Changed label widths to fit in Slovak translations (mainly).
 * Also added character set autodetection (from /opt/kderc, General Font,
 * Charset). It only accepts iso8859-1,2,7, since only these do have
 * .cdef files for them. Use DEFCHARSET (defined in klyx.h) for defaults
 * in config reads, etc. I've changed string "iso8859-1" to DEFCHARSET
 * where appropriate.
 * TODO: fix autodetection, use some locale functions instead of kderc.
 *
 * Revision 1.7  1998/03/17 21:35:07  kalle
 * BulletShapeDialog gets better, now the correct panel and the correct
 * button is shown. The only thing that is missing is the initial display
 * of the values. Later. Much later.
 *
 * Good night!
 *
 * Revision 1.6  1998/03/17 20:55:05  kalle
 * BulletShapeDialog is usable now, but notyet perfect
 *
 * Revision 1.5  1998/03/05 19:05:40  kulow
 * okPB was declared twice. as data member and as local variable in
 * the constructor. This lead to a bus error, when init() acessed it
 *
 * Revision 1.4  1998/03/04 21:49:14  kalle
 * More Qt-ified
 *
 * Revision 1.3  1998/02/16 20:20:52  kalle
 * Kalle: First XForms-free version
 *
 * Revision 1.2  1998/02/04 22:09:12  kalle
 * BulletShapeDialog works! (Even better than in lyx!)
 *
 * Revision 1.1  1998/02/03 23:41:51  kalle
 * BulletShapeDialog sort of works
 * It took me two Maribo Pilsner to get this far!
 * Still no images in BulletShapeDialog (will add these tomorrow)
 *
 */
