/***************************************************************************
                          kashtransaction.cpp  -  description
                             -------------------
    begin                : Sun Nov 21 1999
    copyright            : (C) 1999 by Stephan Kahnt
    email                : stephan.kahnt@ipk.fhg.de
 ***************************************************************************/
// standard include
#include <vector.h>

// include files for KDE
#include <kglobal.h>
#include <klocale.h>

// application specific includes
#include "kashtransaction.h"

extern QDate stringToDate( const QString& dateString );

KashTransaction::KashTransaction() {
}

KashTransaction::KashTransaction( StringVector& dataVec ) {
  uint idx = 0;
  for ( idx = 0; idx < dataVec.size(); idx++ ) {
    setField( idx, dataVec[ idx ].latin1() );
  }
}

KashTransaction::~KashTransaction() {
}

void KashTransaction::setField( int idx, const char* aValue ) {
  QString aStrVal = aValue;
  switch ( idx ) {
  case DATE_IDX:
    date = stringToDate( aStrVal );
    break;
  case AMOUNT_IDX:
    amount = aStrVal.toDouble();
    break;
  case PAYEE_IDX:
    payee = aStrVal;
    break;      
  case CAT_IDX:
    category = aStrVal;
    break;
  case SUBCAT_IDX:
    subCategory = aStrVal;
    break;
  case MEMO_IDX:
    memo = aStrVal;
    break;
  case NO_IDX:
    number = aStrVal;
    break;
  case STATE_IDX:
    state = aStrVal;
    break;
  }
} 

void KashTransaction::getTransaction( StringVector& dataVec ) {
  dataVec.clear();
  dataVec.resize( FIELD_NO );

  dataVec[ DATE_IDX ] = KGlobal::locale()->formatDate( date, true );
  dataVec[ AMOUNT_IDX ].setNum( amount );
  dataVec[ PAYEE_IDX ] = payee;
  dataVec[ CAT_IDX ] =category;
  dataVec[ SUBCAT_IDX ] = subCategory;
  dataVec[ MEMO_IDX ] = memo;
  dataVec[ NO_IDX ] = number;
  dataVec[ STATE_IDX ] = state;
}

QString KashTransaction::getField( int idx ) {
  QString retStr = "";
  switch ( idx ) {
  case DATE_IDX:
    retStr = KGlobal::locale()->formatDate( date, true );
    break;
  case AMOUNT_IDX:
    retStr.setNum( amount );
    break;
  case PAYEE_IDX:
    retStr = payee;
    break;      
  case CAT_IDX:
    retStr = category;
    break;
  case SUBCAT_IDX:
    retStr = subCategory;
    break;
  case MEMO_IDX:
    retStr = memo;
    break;
  case NO_IDX:
    retStr = retStr;
    break;
  case STATE_IDX:
    retStr = state;
    break;
  }
  return retStr;
} 

void operator << ( QTextStream& s, KashTransaction& transaction ) {
  s << "D" << transaction.date.month() 
    << "/" << transaction.date.day()  
    << "/" << transaction.date.year() << endl;

  if ( !transaction.payee.isEmpty() ) {
    s << "P" << transaction.payee << endl;
  }

  if ( !transaction.category.isEmpty() ) {
    s << "L" << transaction.category;
    if ( !transaction.subCategory.isEmpty() ) {
      s << "/" << transaction.subCategory;
    }
    s << endl;
  }

  s  << "T";
  s.setf( QTextStream::fixed );
  s.precision( 2 );
  s << transaction.amount << endl;  

  if ( !transaction.memo.isEmpty() ) {
    s << "M" << transaction.memo << endl;
  }

  if ( !transaction.number.isEmpty() ) {
    s << "N" << transaction.number << endl;
  }

  s << "^" << endl;  
}

bool operator >> ( QTextStream& s, KashTransaction& transaction ) {
  char ch;
  QString dummy;
  int slashPos;
  int complete = 0;

  s >> ch;
  while ( !s.atEnd() && ch != '^' ) {
    switch( ch ) {
    case 'D':
      dummy = s.readLine();
      transaction.date = stringToDate( dummy );
      if ( transaction.date.isValid() ) {
	complete = complete | 1;
      }
      break;
    case 'P':
      transaction.payee = s.readLine();
      break;
    case 'L':
      dummy = s.readLine();
      if ( ( slashPos = dummy.find( '/' ) ) != -1 ) {
	transaction.category = dummy.mid( 0, slashPos );
	transaction.subCategory = dummy.right( dummy.length() - slashPos - 1 );
      }
      else {
	transaction.category = dummy;
	transaction.subCategory = "";
      }
      break;
    case 'T':
      transaction.amount = 0;
      s >> transaction.amount;
      if ( transaction.amount ) {
	complete = complete | 2;
      }
      s.readLine();
      break;
    case 'M':
      transaction.memo = s.readLine();
      break;
    case 'N':
      transaction.number = s.readLine();
      break;
    default:
      s.readLine();
      break;
    }
    
    s >> ch;
  }
  
  return complete == 3;
}



















