/***************************************************************************
                          kashaccount.h  -  description
                             -------------------
    begin                : Sun Nov 21 1999
    copyright            : (C) 1999 by Stephan Kahnt
    email                : stephan.kahnt@ipk.fhg.de
 ***************************************************************************/

#ifndef KASHACCOUNT_H
#define KASHACCOUNT_H
// standard include
#include <vector.h>

// include files for Qt
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qmap.h>
#include <qtextstream.h> 
// #include <qvector.h>

// application specific includes
#include "kashtransaction.h"

class KashBank;
class KashTransaction;

typedef vector< long > IdVector;

/**
  *@author Stephan Kahnt
  */

class KashAccount: public QObject {
 Q_OBJECT
 public: 
  KashAccount();
  
  KashAccount( const char* aName, const char* aType, 
	       const char* aNo = 0, const char* aDescr = 0 );

  ~KashAccount();
  
  void setBank( KashBank* aBank ) {
    bank = aBank;
  };
  
  void setCurrency( const char* aCurrency );

  long addTransaction();

  long addTransaction( StringVector& dataVec );

  bool updateTransaction( long transId, StringVector& dataVec );

  void getTransaction( long transId, StringVector& dataVec );

  void getIdVector( IdVector& idVec );

  bool deleteTransaction( long transId );

  friend bool operator >> ( QTextStream& s, KashAccount& account );

  friend void operator << ( QTextStream& s, KashAccount& account );

 signals:
  void sigNewTransaction( long transId, StringVector& dataVec );

 private: // Private attributes
  /** the name of the account */
  QString name;
  /** a name for the account type */
  QString type;
  /** a description of the account */
  QString description;
  /** a pointer to the bank object */
  KashBank* bank;
  /** account number */
  QString number;
  /** the currency name */
  QString currency;
  /** type for a map of transactions */
  typedef QMap< long, KashTransaction > TransMapType;
  /** map of transactions */
  TransMapType transMap;
  /** this ident is significant for each transaction */
  long newIdent;
};

#endif









