/* Implementation of the KeyValueMap class test.
 * Should report "No errors..." if everything is
 * working as intended.
 * Please report test failures with useful info-
 * rmation about the environment to me.
 * 
 * the Configuration Database library
 * copyright:  (C) Mirko Sucker, 1998
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@hamburg.netsurf.de>
 *                          <mirko.sucker@unibw-hamburg.de>
 * requires:   C++-compiler, STL, string class,
 *             Nana (only for debugging)
 * $Revision: 1.1 $
 */

#include "qconfigDB.h"
#include <iostream.h>

int main()
{
  const QString TestFileName="test.database";
  KeyValueMap map;
  QString astring; 
  long along;
  double adouble; 
  bool abool;
  list<long> alonglist;
  list<double> adoublelist;
  list<QString> astringlist;
  int errors;
  const char* pairs[]= {
    /* string values without delimiters (") may be given plain: */
    "test_1=a_string_value",
    /* bool values may be true or false: */
    "test_2=true",
    /* double: */
    "test_5=0.001345",
    /* a complex strig containing delimiters: */
    "test_7= a complex string containing \"delimiters\" "
  };
  const int Size=sizeof(pairs)/sizeof(pairs[0]);
  // ----------------------------------------------------------------
  int temp;
  cout << "Testing the handling of key-value-pairs using"
       << " the KeyValueMap class. " << endl
       << "The test file will be called " << TestFileName 
       << "." << endl << "------------------------" << endl;
  for(temp=0; temp<Size; temp++)
    {
      if(!map.insertLine(pairs[temp]))
	{
	  cout << "KeyValueMap test: unable to insert pair \""
	       << pairs[temp] << "\"." << endl;
	}
    }
  // inserting a boolean value:
  if(!map.insert("test_3", false))
    {
      cout << "KeyValueMap test: unable to insert integer value."
	   << endl;
      errors++;
    } 
  // inserting an int:
  if(!map.insert("test_4", 1127L))
    {
      cout << "KeyValueMap test: unable to insert integer value."
	   << endl;
      errors++;
    } 
  // inserting a list of ints
  alonglist.push_back(1); 
  alonglist.push_back(2); 
  alonglist.push_back(3); 
  if(!map.insert("test_9", alonglist))
    {
      cout << "KeyValueMap test: unable to insert integer list."
	   << endl;
    }
  alonglist.erase(alonglist.begin(), alonglist.end());
  // inserting a list of doubles
  adoublelist.push_back(1.5); 
  adoublelist.push_back(2.5); 
  adoublelist.push_back(3.5); 
  if(!map.insert("test_10", adoublelist))
    {
      cout << "KeyValueMap test: unable to insert double list."
	   << endl;
    }
  adoublelist.erase(adoublelist.begin(), adoublelist.end());
  // inserting a list of strings
  astringlist.push_back("Montag");
  astringlist.push_back("Dienstag");
  astringlist.push_back("Mittwoch");
  if(!map.insert("test_8", astringlist))
    {
      cout << "KeyValueMap test: unable to insert string list."
	   << endl;
    }
  astringlist.erase(astringlist.begin(), astringlist.end());
  // ----------------------------------------------------------------
  cout << "KeyValueMap test: inserted all key-value-pairs," 
       << endl
       << "                  now saving and reloading the database."
       << endl << "This is to find failures in coding and decoding."
       << endl << "------------------------" << endl;
  map.save(TestFileName, true);
  map.clear();
  if(!map.empty())
    {
      cout << "KeyValueMap test: could not erase map contents."
	   << endl;
    }
  map.fill(TestFileName);
  // ----------------------------------------------------------------
  cout << "KeyValueMap test: done," << endl
       << "                  now testing get-methods." << endl
       << "------------------------" << endl;
  errors=0;
  // ----------------------------------------------------------------
  if(!map.get("test_1", astring))
    {
      cout << "KeyValueMap test: unable to retrieve string value."
	   << endl;
      errors++;
    }
  if(!map.get("test_2", abool))
    {
      cout << "KeyValueMap test: unable to retrieve boolean value."
	   << endl;
      errors++;
    }
  if(!map.get("test_3", abool))
    {
      cout << "KeyValueMap test: unable to retrieve second "
	   << "boolean value." << endl;
      errors++;
    } else {
      if(abool!=false)
	{
	  cout << "KeyValueMap test: bool value is wrong."
	       << endl;
	  errors++;
	}
    }
  if(!map.get("test_4", along))
    {
      cout << "KeyValueMap test: unable to retrieve int value."
	   << endl;
      errors++;
    } else {
      if(along!=1127L)
	{
	  cout << "KeyValueMap test: int value is wrong."
	       << endl;
	  errors++;
	}
    }
  if(!map.get("test_5", adouble))
    {
      cout << "KeyValueMap test: unable to retrieve double value."
	   << endl;
      errors++;
    }
  if(!map.get("test_7", astring))
    {
      cout << "KeyValueMap test: unable to retrieve complex string."
	   << endl;
      errors++;
    }
  if(astring!=" a complex string containing \"delimiters\" ")
    {
      cout << "KeyValueMap test: error parsing the complex string."
	   << endl << "Should be --> a complex "
	   << "string containing \"delimiters\" <--," << endl
	   << "but is -->" << astring << "<--." << endl;
      errors++;
    }
  if(!map.get("test_8", astringlist))
    {
      cout << "KeyValueMap test: unable to parse string list.\n"
	   << endl;
      errors++;
    } else {
      list<QString>::iterator pos; 
      cout << "KeyValueMap test: contents of string list:" << endl
	   << "                  ";
      for(pos=astringlist.begin(); pos!=astringlist.end(); pos++)
	{
	  cout << (*pos) << "; ";
	}
      cout << endl;
    }
  if(!map.get("test_9", alonglist))
    {
      cout << "KeyValueMap test: unable to parse int list.\n"
	   << endl;
      errors++;
    } else {
      list<long>::iterator pos; 
      cout << "KeyValueMap test: contents of int list:" << endl
	   << "                  ";
      for(pos=alonglist.begin(); pos!=alonglist.end(); ++pos)
	{
	  cout << (*pos) << "; ";
	}
      cout << endl;
    }
  if(!map.get("test_10", adoublelist))
    {
      cout << "KeyValueMap test: unable to parse double list.\n"
	   << endl;
      errors++;
    } else {
      list<double>::iterator pos; 
      cout << "KeyValueMap test: contents of double list:" << endl
	   << "                  ";
      for(pos=adoublelist.begin(); pos!=adoublelist.end(); pos++)
	{
	  cout << (*pos) << "; ";
	}
      cout << endl;
    }
  // ----------------------------------------------------------------
  cout << "------------------------" << endl;
  if(errors==0)
    { cout << "No"; } else { cout << errors; }
  cout << " errors occured during \"get\" tests." << endl;
  return 0;
}

  
  
