#ifndef _ICQ_H_
#define _ICQ_H_

#include <time.h>

#define ICQ_LOG_OFF     0
#define ICQ_LOG_FATAL		1
#define ICQ_LOG_ERROR		2
#define ICQ_LOG_WARNING	3
#define ICQ_LOG_MESSAGE	4

#define STATUS_OFFLINE		(-1L)
#define STATUS_ONLINE		0x00
#define STATUS_INVISIBLE	0x100
#define STATUS_INVISIBLE_2	0x10
#define STATUS_NA           0x05
#define STATUS_FREE_CHAT	0x20
#define STATUS_OCCUPIED		0x11
#define STATUS_AWAY         0x01
#define STATUS_DND          0x13

typedef void (*cback)(void);

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern unsigned long icq_Status;
extern unsigned char icq_Russian;
extern unsigned char icq_LogLevel;

extern void (*icq_Logged)(void);
extern void (*icq_Disconnected)(void);
extern void (*icq_RecvMessage)(unsigned long uin, time_t time, const char *data);
extern void (*icq_RecvUrl)(unsigned long uin, const char *descr, const char *data);
extern void (*icq_RecvAdded)(unsigned long uin, const char *nick, const char *first, const char *last, const char *email);
extern void (*icq_RecvAuthReq)(unsigned long uin, const char *nick, const char *first, const char *last, const char *email, const char *reason);
extern void (*icq_UserFound)(unsigned long uin, const char *nick, const char *first, const char *last, const char *email, char auth);
extern void (*icq_SearchDone)(void);
extern void (*icq_UserOnline)(unsigned long uin, unsigned long status);
extern void (*icq_UserOffline)(unsigned long uin);
extern void (*icq_UserStatusUpdate)(unsigned long uin, unsigned long status);
extern void (*icq_InfoReply)(unsigned long uin, const char *nick, const char *first, const char *last, const char *email, char auth);
extern void (*icq_ExtInfoReply)(unsigned long uin, const char *city, unsigned short country_code, char country_stat, const char *state, unsigned short age, char gender, const char *phone, const char *hp, const char *about);
extern void (*icq_Log)(time_t time, unsigned char level, const char *str);
extern void (*icq_SrvAck)(unsigned short seq);

void icq_Init(unsigned long uin, const char *password);
int icq_Connect(const char *hostname, int port);
void icq_Main();
void icq_KeepAlive();
void icq_Login(unsigned long status);
void icq_Quit();
void icq_SendContactList();
unsigned short icq_SendMessage(unsigned long uin, const char *text);
void icq_ChangeStatus(unsigned long status);
unsigned short icq_SendInfoReq(unsigned long uin);
unsigned short icq_SendExtInfoReq(unsigned long uin);
void icq_SendAuthMsg(unsigned long uin);
void icq_StartSearch(const char *email, const char *nick, const char* first, const char* last);

const char *icq_GetCountryName(int code);
void icq_RegNewUser(const char *pass);

void icq_ContAddUser(unsigned long cuin);
void icq_ContDelUser(unsigned long cuin);
void icq_ContClear();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _ICQ_H_ */
