/**********************************************************************
 mainDlg
 
 (C) 1998 Kling Dietmar
 *********************************************************************/

#include "mainDlg.h"
#include "mainDlg.moc"
#define Inherited QDialog

#include <qpushbt.h>
#include <qlined.h>
#include <qmlined.h>

#include <kapp.h>

#include <setupDlg.h>
KApplication *TemplateApplication;

mainDlg::mainDlg
(
	QWidget* parent,
	const char* name
) 
	: KTopLevelWidget( name )
{
  view = new mainView (this);
  setView (view);

  setupMenuBar ();
  setupToolBar ();
  setupStatusBar ();

  resize (690, 400);
  setMinimumSize (0, 0);
  setMaximumSize (32767, 32767);

  show ();
}
void
mainDlg::setupMenuBar()
{
  /* First Setup all Menus */
  file = new QPopupMenu ();
  file->insertItem (i18n ("&Exit"),
		    this, SLOT (Exit ()));

  options = new QPopupMenu ();
  options->insertItem( i18n("&Options"),
  		    this, SLOT( Options()));
  
  /* Help Menu is special */
  help = TemplateApplication->getHelpMenu (FALSE, "kzilla "
  						   VERSION
  						   "\n\n"
			 			   "(c) Dietmar Kling (dietmar.kling@usa.net) \n");
  /* Now attach menus to menubar */
  menubar = new KMenuBar (this, "menubar");
  menubar->insertItem (i18n ("&File"), file);
  menubar->insertItem (i18n ("&Options"), options);
  menubar->insertItem (i18n ("&Help"), help);
  setMenu (menubar);
  menubar->show ();
}
void 
mainDlg::setupToolBar()
{
  toolbar = new KToolBar (this);
  KIconLoader *loader = TemplateApplication->getIconLoader ();
  toolbar->setBarPos (KToolBar::Top);
  toolbarID = addToolBar (toolbar);
  enableToolBar (KToolBar::Show, toolbarID);
}

void
mainDlg::setupStatusBar()
{
  statusbar = new KStatusBar (this);
  statusbar->insertItem (i18n("(C) 1998 with GPL by Kling Dietmar (dietmar.kling@usa.net)"), ID_LINE_COLUMN);
  statusbar->insertItem (i18n("   "), ID_INS_OVR);
  statusbar->insertItem (i18n("Welcome to KZILLA..."), ID_GENERAL);

  statusbar->setInsertOrder (KStatusBar::RightToLeft);
  statusbar->setAlignment (ID_INS_OVR, AlignCenter);

  setStatusBar (statusbar);

}
void
mainDlg::Exit()
{
  TemplateApplication->quit();
}
void
mainDlg::Options()
{
  /* Tell us something about you */
  QDialog *dlg = new setupDlg (0);
  QPoint point = this->mapToGlobal (QPoint (0, 0));
  QRect pos = this->geometry ();
  dlg->setGeometry (point.x () + pos.width () / 2 - dlg->width () / 2,
		    point.y () + pos.height () / 2 - dlg->height () / 2,
		    dlg->width (), dlg->height ());

  dlg->exec ();
  delete dlg;

}

mainDlg::~mainDlg()
{
	// FIXME Delete all menus here

}

void
main(int argc, char **argv)
{
  TemplateApplication = new KApplication (argc, argv);
  mainDlg *TemplateWidget = new mainDlg;

  TemplateApplication->setMainWidget (TemplateWidget);
  TemplateApplication->exec ();

  delete TemplateWidget;
  delete TemplateApplication;
  return 0;
}
