/****************************************************************************
** $Id: table.h,v 1.5 1998/06/16 11:39:34 warwick Exp $
**
** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef USERVIEW_H
#define USERVIEW_H

#include <qtableview.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

#define VIEW_ONLINE 1
#define VIEW_OFFLINE 2

#define UIN unsigned int

class userView : public QTableView
{
        Q_OBJECT
    public:
        userView( int type, QWidget* parent = 0, const char* name = 0 );
        ~userView();

        const char* cellContent( int row, int col ) const;
        void setCellContent( int row, int col, const char* );

        void changeItem( UIN uin );
        void setupConfig();


        int type;
        QLineEdit *userEdit;
        QPopupMenu *menu;
    protected:
        void paintCell( QPainter*, int row, int col );
        void mousePressEvent( QMouseEvent* );
        void keyPressEvent( QKeyEvent* );
        void focusInEvent( QFocusEvent* );
        void focusOutEvent( QFocusEvent* );
        void resizeEvent( QResizeEvent *e );
        void mouseMoveEvent( QMouseEvent * );

    public slots:
        void updateUserInfo();
        void showMessage();
        void askAway();
        void sendMessage();
        void sendUrl();
        void sendChatRequest();
        void showInfo();
        void deleteUser();
        void renameSlot();
    private:
        int indexOf( int row, int col ) const;
        QString* contents;
        int curRow;
        int curCol;
};

#endif  // TABLE_H
