/*
   $Id: kxicq.cpp,v 2.25.4.6.2.7 1998/12/20 21:01:59 herwinjs Exp $
 
 
   KXicq, the ICQ client for the K Desktop Enviroment.
   (C) 1998 Herwin Jan Steehouwer (steehouwer@kde.org)
   The source in under the GPL licence.
*/

#ifdef USE_SOCKS5
#include <socks.h>
#endif
#include "xautolock.h"

#include <mediatool.h>
#include <kaudio.h>
#include <qaccel.h>
#include <qkeycode.h>
#include <qlabel.h>
#include <qbttngrp.h>
#include <qpushbt.h>
#include <qprogbar.h>
#include <qlayout.h>
#include <qpopmenu.h>
#include <unistd.h>
#include <stdlib.h>
#include <qwindow.h>
#include <qlabel.h>
#include <qbitmap.h>
#include <qfont.h>
#include <qcolor.h>

#include <kprogress.h>
#include <qpushbt.h>
#include <qpainter.h>
#include <qpicture.h>
#include <qwidget.h>
#include <qpaintd.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <qcolor.h>
#include <kiconloader.h>
#include <ctype.h>
#include <kstatusbar.h>
#include <kmenubar.h>
#include <ktreelist.h>
#include <qdatetm.h>
#include <ktablistbox.h>
#include <qmsgbox.h>
#include <kmsgbox.h>
#include "kxicq.moc"
#include "dialogs.h"
#include "optionsdlg.h"
#include "structs.h"
#include "sendDialog.h"
#include "message.h"

#include "wmkxicq.h"

#include <qtooltip.h>

int KXDEBUG=0;

extern int OldStyle;
bool reinit = FALSE;
struct COLORS color;
QString origConfig, origLog;

struct kxicqConfig KxicqConfig;
KConfig *totalConfig;
extern int stopAll;
mainWin *mainW;
KApplication *mainApp;
extern viewSearch *viewS;
extern int isViewSearch ;
extern int isDoSearch ;
searchDialog *searchD;
extern userInfo *userI;
USER_CONFIGURATION user_cfg;
CALLBACK_FUNCTIONS callback_functions;
void saveConfig();
extern int showOffline;
int userConfigure( USER_CONFIGURATION *user_cfg );
int logged_on = 0;
int loginTry = 1;
time_t login_time, login_begin;
QString statlogin;
void readMsgs();
QList < MSG > userMsg;
//extern ReadFile readFile;
ReadFile readFile;
DockView *dockView;
KIconLoader *iconL;
bool newUserInfo = FALSE;
bool newUser = FALSE;
char *awayMsg;
bool sendLogin = FALSE;
int con, dis;
bool autoChange = FALSE;
bool messageBlink=FALSE;


void autoaway()
{
//    if ( logged_on > 0 )
//    {
        if ( KxicqConfig.autoAway )
        {
	    int move;
	    
            unsigned int status = mainW->currentStatus;
	    autoChange = TRUE;

            // must be working NOW ;-)
            if ( checkTimeOut(move) )
            {
                if ( ( status == STATUS_ONLINE ) || ( status == STATUS_FFC ) )
                {
                    mainW->setAway( 0 );
		    initTimeOut ( KxicqConfig.naTime );
                }
                else if ( status == STATUS_AWAY )
                {
                    mainW->setNA( 0 );
		    if (KxicqConfig.autoUnAway) initTimeOut ( 60 ); else freeTimeOut();
                }
		// else if ( status != STATUS_NA ) freeTimeOut();
            }
            if ( move && ( (status == STATUS_NA) || (status == STATUS_AWAY) ) )
            {
		mainW->setBack(0);
		initTimeOut ( KxicqConfig.awayTime );
            }
	
	    autoChange = FALSE;
        }
//    }
}

void loggedon()
{
    KMsgBox::message( mainW, i18n( "Not connected !!" ), i18n( "You have to wait till you are connected !" ), 4, i18n( "OK" ) );
}

MSG *askAnyRead()
{
    MSG *tmp;
    for ( tmp = userMsg.first(); tmp != 0; tmp = userMsg.next() )
    {
        if ( tmp->getRead() == 0 )
        {
            return tmp;
        }
    }
    return 0;
}

int askRead( UIN uin )
{
    MSG * tmp;

    if ( uin == TYPE_SERVER )
    {
        //      printf("SERVER DEBUG\n");
        for ( tmp = userMsg.first(); tmp != 0; tmp = userMsg.next() )
        {
            if ( !contact_isuin( tmp->getUin() ) )
            {
                if ( tmp->getRead() == 0 )
                {
                    return 1;
                }
            }
        }
        return 0;
    }
    else
    {
        for ( tmp = userMsg.first(); tmp != 0; tmp = userMsg.next() )
        {
            if ( tmp->getUin() == uin )
            {
                if ( tmp->getRead() == 0 )
                {
                    return 1;
                }
            }
        }
    }
    return 0;
}

int ifMsg( UIN uin )
{
    MSG * tmp;

    if ( uin == TYPE_SERVER )
    {
        //      printf("SERVER DEBUG\n");
        for ( tmp = userMsg.first(); tmp != 0; tmp = userMsg.next() )
        {
            //if (tmp->getUin()==(UIN)atoi(contact_uin2nick(tmp->getUin())))
            if ( contact_isuin( tmp->getUin() ) == 0 )
            {
                return 1;
            }
        }
        return 0;
        
    }
    else
    {
        for ( tmp = userMsg.first(); tmp != 0; tmp = userMsg.next() )
        {
            if ( tmp->getUin() == uin )
            {
                return 1;
            }
        }
    }
    return 0;
}

void dos2config( char *txt )
{
    char * tmp;
    tmp = ( char * ) malloc( 65536 );
    unsigned int l = 0;
    for ( unsigned int t = 0; t <= strlen( txt ); t++ )
    {
        if ( txt[ t ] == '\r' )
        {
            tmp[ l++ ] = '#';
            tmp[ l++ ] = '1';
            tmp[ l++ ] = '3';
            tmp[ l ] = 0;
        }
        else
        {
            if ( txt[ t ] == '\n' )
            {
                tmp[ l++ ] = '#';
                tmp[ l++ ] = '1';
                tmp[ l++ ] = '0';
                tmp[ l ] = 0;
            }
            else
            {
                tmp[ l++ ] = txt[ t ];
                tmp[ l ] = 0;
            }
        }
    }
    strcpy( txt, tmp );
    if (tmp) free( tmp );
}
void config2dos( char *txt, unsigned int len )
{
    char * tmp;
    tmp = ( char * ) malloc( ( strlen( txt ) *2 ) );
    unsigned int l = 0;
    for ( unsigned int t = 0; t <= len; t++ )
    {
        if ( txt[ t ] == '#' && txt[ t + 1 ] == '1' && txt[ t + 2 ] == '3' )
        {
            tmp[ l++ ] = '\r';
            tmp[ l ] = 0;
            t += 2;
        }
        else
        {
            if ( txt[ t ] == '#' && txt[ t + 1 ] == '1' && txt[ t + 2 ] == '0' )
            {
                tmp[ l++ ] = '\n';
                tmp[ l ] = 0;
                t += 2;
            }
            else
            {
                if ( txt[ t ] != '\n' && txt[ t ] != '\r' )
                {
                    tmp[ l++ ] = txt[ t ];
                    tmp[ l ] = 0;
                }
            }
        }
    }
    strcpy( txt, tmp );
    if (tmp) free( tmp );
}

void unix2dos( char *txt )
{
    char * tmp;
    tmp = ( char * ) malloc( 65535 );
    unsigned int l = 0;
    for ( unsigned int t = 0; t <= strlen( txt ); t++ )
    {
        if ( txt[ t ] == '\n' )
        {
            tmp[ l++ ] = '\r';
            tmp[ l++ ] = '\n';
            tmp[ l ] = 0;
        }
        else
        {
            tmp[ l++ ] = txt[ t ];
            tmp[ l ] = 0;
        }
    }
    strcpy( txt, tmp );
    if (tmp) free( tmp );
}

/* ***************************************************************************************** */

void unknownReply( int type )
{
    switch ( type )
    {
        case PASSWD:
            mainW->Wdisconnected();
            logged_on = -1;
            if ( QMessageBox::warning( mainW, i18n( "Server reply" ),
                                       i18n( "You have enterd a wrong password or UIN!" ), i18n( "OK" ) ) == 0 )
                mainW->configShow();
            break;
        case UUIN:
            mainW->Wdisconnected();
            logged_on = -1;
            if ( QMessageBox::warning( mainW, i18n( "Server reply" ),
                                       i18n( "You have enterd a wrong UIN or Password!" ), i18n( "OK" ) ) == 0 )
                mainW->configShow();
            break;
    }
    mainW->fileMenu->setItemEnabled( con, TRUE );
    mainW->fileMenu->setItemEnabled( dis, FALSE );
}

void chatRequest( UIN uin, char *mesg )
{
    CONTACT c;
    for ( int t = 0; t < contact_length(); t++ )
    {
        c = contact_returnItemNum( t );
        if ( c.uin == uin )
        {
            QString txt( BUFSIZE );
            mainW->makeSound( TYPE_CHAT );
            txt.sprintf( i18n( "You have a Chat Request from %s :\n\n %s" ), c.nick, mesg );
            if ( QMessageBox::information( mainW, i18n( "Chat Request" ), txt.data(), i18n( "Accept" ), i18n( "Cancel" ) ) == 0 )
            {
                if (mesg) free( mesg );
                send_chatAccept( uin );
                return;
            }
        }
    }
    if (mesg) free( mesg );
    send_chatCancel( uin, "" );
}

void doChat( UIN uin )
{
    Chat * newChat;
    newChat = new Chat( uin, mainW );
    contact_insertClas( uin, ( void * ) newChat );
    newChat->resize( 400, 350 );
    newChat->show();
}
void putChar( UIN uin, char *data, int len )
{
    void * p;
    p = contact_getClas( uin );
    if ( p != NULL )
    {
        Chat * p1 = ( Chat * ) p;
        p1->getRecv( data, len );
    }
    else
        printf( "error\n" );
}

void closeChat( UIN uin )
{
    void * p;
    p = contact_getClas( uin );
    if ( p != NULL )
    {
        Chat * p1 = ( Chat * ) p;
        p1->closeChat();
    }
    else
        printf( "error\n" );
}


/* ***************************************************************************************** */

void mainWin::reInitICQ()
{
    if ( initICQ( 1 ) != 1 )
    {
        if ( logged_on != 0 ) send_logout();
        killTimers();
        discon();
        QString tmp( sizeof( user_cfg.nick ) + 8 );
        tmp.sprintf( "KXicq-%s", user_cfg.nick );
        setCaption( tmp.data() );
        login_time = login_begin = time( NULL );
        if ( KxicqConfig.autoConnect == 1 && sendLogin == FALSE )
        {
            send_login();
            sendLogin = TRUE;
            fileMenu->setItemEnabled( dis, TRUE );
            fileMenu->setItemEnabled( con, FALSE );
        }
        startTimer( 250 );
    }
}

int mainWin::initICQ( int old )
{
    if ( !old )
    {
        readMsgs();
        availList = new Users( this, "list" );
        CONTACT contact;
        availList->insertItem( STATUS_ONLINE, i18n( "Server/Unknown" ), TYPE_SERVER, askRead( TYPE_SERVER ), ifMsg( TYPE_SERVER ) );
        availList->setUpdatesEnabled(FALSE);
        for ( int t = 0; t < contact_length(); t++ )
        {
            contact = contact_returnItemNum( t );
            availList->insertItem( contact.status, contact_uin2nick( contact.uin ), contact.uin, askRead( contact.uin ),
                                   ifMsg( contact.uin ) );
        }
        availList->setUpdatesEnabled(TRUE);
        return 0;
    }
    else
    {
        reinit = TRUE;
        QString tmpa = user_cfg.serverAddr;
        int tmpp = user_cfg.serverPort;
        loadKxicqConfig();
        reinit = FALSE;
        setupNewConfig();
        if ( strcmp( tmpa.data(), user_cfg.serverAddr ) == 0 && tmpp == user_cfg.serverPort )
        {
            send_change_info( user_cfg.email, user_cfg.nick, user_cfg.firstName, user_cfg.lastName );
            newUserInfo = FALSE;
            return 1;
        }
        else
            newUserInfo = TRUE;
    }
    return 0;
}

void addnewUser( UIN uin )
{
    CONTACT contact;
    mainW->availList->setUpdatesEnabled(FALSE);
    for ( int t = 0; t < contact_length(); t++ )
    {
        contact = contact_returnItemNum( t );
        if ( uin == contact.uin )
        {
            mainW->availList->insertItem( contact.status, contact.nick, uin, askRead( uin ),
                                          ifMsg( uin ) );
        }
    }
    mainW->availList->setUpdatesEnabled(TRUE);
}

int mainWin::addUser( const char *nick, UIN uin )
{
    contact_add( nick, uin );
    availList->addItem(uin);
    return 0;
}

mainWin::mainWin( QWidget *, const char *name ) : KTopLevelWidget( name )
{

    blinkIcons = new QTimer(this);
    connect(blinkIcons, SIGNAL(timeout()), this, SLOT(BlinkIcons()));
    
    
    animatedLogoCounter = 0;
    animatedLogoTimer = new QTimer( this );

    connect( animatedLogoTimer, SIGNAL( timeout() ), this, SLOT( slotAnimatedLogoTimeout() ) );
    animatedLogoTimer->start( 50 );

    timerRun = 1;
    play = new KAudio();
    tijd = QDate::currentDate();
    viewS = NULL;
    searchD = NULL;
    userI = NULL;
    currentStatus = STATUS_OFFLINE;
    totalConfig = mainApp->getConfig();

    connect(mainApp, SIGNAL(shutDown()), SLOT(shutDown()));
    
    stopAll = 0;

    callbackSetup( callback_functions );
    setupCallbacks( callback_functions );
    initICQ( 0 );
    QString tmp( sizeof( user_cfg.nick ) + 8 );
    tmp.sprintf( "KXicq-%s", user_cfg.nick );
    setCaption( tmp.data() );

    userMsg.setAutoDelete( TRUE );
    //////////////

    sb = new KStatusBar( this );
    sb->insertItem( i18n( "Offline      " ), 0 );
    sb->insertItem( i18n( "Connecting                            " ), 1 );
    statlogin = i18n( "Connecting" );

    setStatusBar( sb );
    sb->show();

    setView( availList );

    iconL = kapp->getIconLoader();

    //tb=new KToolBar(this);
    QPixmap pixmap;
    QString dir;


    fileMenu = new QPopupMenu();
    CHECK_PTR( fileMenu );

    pixmap = iconL->loadIcon( "connected.xpm" );
    con = fileMenu->insertItem( pixmap, "&Connect", this, SLOT( conn() ) );
    //   fileMenu->setItemEnabled(ID_MENU_CONNECT,FALSE);
    pixmap = iconL->loadIcon( "disconnected.xpm" );
    dis = fileMenu->insertItem( pixmap, "&Disconnect", this, SLOT( discon() ) );

    fileMenu->setItemEnabled( con, TRUE );
    fileMenu->setItemEnabled( dis, FALSE );


    fileMenu->insertSeparator();
    //   fileMenu->insertItem("&Status",ID_MENU_STATUS);
    fileMenu->insertItem( i18n( "Search &User" ), this, SLOT( searchUsers() ) );

//    fileMenu->insertSeparator();
    fileMenu->insertItem( i18n( "&Configure" ), this, SLOT( configShow() ) );
    fileMenu->insertSeparator();
    fileMenu->insertItem( i18n( "&Quit" ), this, SLOT( quit() ) );
    helpMenu = new QPopupMenu();
    CHECK_PTR( helpMenu );
    helpMenu->insertItem( i18n( "&About KXicq" ), this, SLOT( help_about() ) );
    helpMenu->insertItem( i18n( "About &KDE" ) );
    helpMenu->insertItem( i18n( "About &Qt" ), this, SLOT( help_aboutQT() ) );


    viewMenu = new QPopupMenu();
    CHECK_PTR( viewMenu );
    pixmap = iconL->loadIcon( "onlineview.xpm" );
    viewMenu->insertItem( pixmap, i18n( "Online only" ), availList, SLOT( setOnlineOnly() ) );
    pixmap = iconL->loadIcon( "kxicqview.xpm" );
    viewMenu->insertItem( pixmap, i18n( "KXicq style" ), availList, SLOT( setOldStyle() ) );
    pixmap = iconL->loadIcon( "verticalview.xpm" );
    viewMenu->insertItem( pixmap, i18n( "Vertical style" ), availList, SLOT( setMSStyle() ) );

    menuBar = new KMenuBar( this );
    CHECK_PTR( menuBar );
    menuBar->insertItem( i18n( "&File" ), fileMenu );
    menuBar->insertItem( i18n( "&View" ), viewMenu );
    menuBar->insertItem( i18n( "&Help" ), helpMenu );
    setMenu( menuBar );

    menuBar->show();

    toolBar = new KToolBar( this );

    pixmap = iconL->loadIcon( "away.xpm" );
    toolBar->insertButton( pixmap, 0, SIGNAL( clicked( int ) ), this, SLOT( setAway( int ) ), TRUE, i18n( "Set AWAY" ) );
    pixmap = iconL->loadIcon( "back.xpm" );
    toolBar->insertButton( pixmap, 1, SIGNAL( clicked( int ) ), this, SLOT( setBack( int ) ), TRUE, i18n( "Set Available" ) );
    pixmap = iconL->loadIcon( "DND.xpm" );
    toolBar->insertButton( pixmap, 2, SIGNAL( clicked( int ) ), this, SLOT( setDND( int ) ), TRUE, i18n( "Set Do Not Disturb" ) );
    pixmap = iconL->loadIcon( "NA.xpm" );
    toolBar->insertButton( pixmap, 3, SIGNAL( clicked( int ) ), this, SLOT( setNA( int ) ), TRUE, i18n( "Set N/A" ) );
    pixmap = iconL->loadIcon( "occupied.xpm" );
    toolBar->insertButton( pixmap, 4, SIGNAL( clicked( int ) ), this, SLOT( setOccu( int ) ), TRUE, i18n( "Set Occupied" ) );
    pixmap = iconL->loadIcon( "ffc.xpm" );
    toolBar->insertButton( pixmap, 5, SIGNAL( clicked( int ) ), this, SLOT( setFFC( int ) ), TRUE, i18n( "Set Free for Chat" ) );
    pixmap = iconL->loadIcon( "invisible.xpm" );
    toolBar->insertButton( pixmap, 6, SIGNAL( clicked( int ) ), this, SLOT( setInvi( int ) ), TRUE, i18n( "Set Invisible" ) );

/*    toolBar->insertSeparator(7);
    QStrList l;
    l.append("Everybody");
    l.append("Friends");
    l.append("School");
    l.append("DSM");
    l.append("Grils!");
    toolBar->insertCombo(&l,8,FALSE,SIGNAL(activated(int)),this,SLOT(doGroup(int)), TRUE, i18n("Set the Group to display"),100);
//    toolBar->setItemAutoSized(8,TRUE);
*/
    pixmap = iconL->loadIcon( "kde1.xpm" );
    toolBar->insertButton( pixmap, 9, TRUE, "" );
    toolBar->alignItemRight( 9, true );
    QString path;
    path = kapp->kde_datadir() + "/kxicq/pics/";

    animatedLogo = new QList < QPixmap > ;
    if ( animatedLogo->count() == 0 )
    {
        animatedLogo->setAutoDelete( true );
        for ( int i = 1; i <= 9; i++ )
        {
            QString n;
            n.sprintf( "kde%i.xpm", i );
            QPixmap *p = new QPixmap();
            p->load( path + n );
            if ( p->isNull() )
            {
                printf( i18n( "error loading icon...\n" ) );
            }
            else animatedLogo->append( p );
        }
    }

    toolBar->setItemEnabled( 0, FALSE );
    toolBar->setItemEnabled( 1, FALSE );
    toolBar->setItemEnabled( 2, FALSE );
    toolBar->setItemEnabled( 3, FALSE );
    toolBar->setItemEnabled( 4, FALSE );
    toolBar->setItemEnabled( 5, FALSE );
    toolBar->setItemEnabled( 6, FALSE );

    //   connect(tb,SIGNAL(clicked(int)),this,SLOT(setAway(int)));

    addToolBar( toolBar );
    toolBar->show();

    //accelKeys=new QAccel(this);
    //   accelKeys->insertItem(CTRL+Key_W,ID_VIEW_WEEK);
    //   accelKeys->insertItem(CTRL+Key_M,ID_VIEW_MONTH);
    //   accelKeys->insertItem(CTRL+Key_D,ID_VIEW_DAY);
    //   connect(accelKeys,SIGNAL(activated(int)),SLOT(menuCallBack(int)));

    //  connect(fileMenu,SIGNAL(activated(int)),SLOT(menuCallBack(int)));

    if ( showOffline == 1 )
    {
        resize( 385, 200 );
        setMinimumSize( 385, 200 );
    }
    else
    {
        resize( 195, 200 );
        setMinimumSize( 195, 200 );
    }

    login_time = login_begin = time( NULL );
    availList->setFocus();

    availList->show();
    availList->repaint();

    //availList->setNewView(1);
    startTimer( 250 );

}

void mainWin::searchUsers()
{
    if ( !searchD )
    {
        if ( !isViewSearch )
        {
            isViewSearch = 1;
            searchD = new searchDialog( mainW, "searchD" );
            searchD->show();
        }
    }
}

void mainWin::setAwayMsg()
{
    if ( !autoChange && KxicqConfig.askAway )
    {
        awayDialog * myMsgWin;

        myMsgWin = new awayDialog( mainW, "setAway" );
        myMsgWin->setCaption( i18n( "Set Away Message" ) );
        if ( !myMsgWin->exec() )
        {
            return;
        }
        mainApp->processEvents();
        mainApp->flushX();
        if (myMsgWin) delete myMsgWin;
    }
    else
        setawaymsg( awayMsg );
}

void mainWin::paintEvent( QPaintEvent * )
{
}

void mainWin::quit()
{
    close();
}

void mainWin::shutDown()
{
    freeTimeOut();
}

mainWin::~mainWin()
{
    if (availList) delete availList;
    if (viewFrame) delete viewFrame;
    if (sb) delete sb;
    if (fileMenu) delete fileMenu;
    //   printf("Save the shit !\n");

}

//////////////////////////

void mainWin::configShow()
{
    OptionsDialog *configDlg = new OptionsDialog( "KXicq Configuration", this );
    connect( configDlg, SIGNAL( configChanged() ), this, SLOT( reInitICQ() ) );
    configDlg->show();
}

void mainWin::doGroup(int)
{
}

void mainWin::setAway( int )
{
    setAwayMsg();
    currentStatus = STATUS_AWAY;
    sb->changeItem( i18n( "Away" ), 0 );
    toolBar->setItemEnabled( 0, FALSE );
    toolBar->setItemEnabled( 1, TRUE );
    toolBar->setItemEnabled( 2, TRUE );
    toolBar->setItemEnabled( 3, TRUE );
    toolBar->setItemEnabled( 4, TRUE );
    toolBar->setItemEnabled( 5, TRUE );
    toolBar->setItemEnabled( 6, TRUE );
    user_cfg.status = STATUS_AWAY;
    MSG *tmp;
    tmp = 0;
    tmp = askAnyRead();
    if ( !tmp ) 
        dockView->setStatus( STATUS_AWAY );
    else
        dockView->setStatus( STATUS_NEWMSG );

    if ( logged_on ) {
	send_statusChange( STATUS_AWAY ); 
    } else {
	if (!autoChange) loggedon();
    }
    if (!autoChange) freeTimeOut();
}
void mainWin::setDND( int )
{
    setAwayMsg();
    currentStatus = STATUS_DND;
    sb->changeItem( i18n( "DND" ), 0 );
    toolBar->setItemEnabled( 1, TRUE );
    toolBar->setItemEnabled( 0, TRUE );
    toolBar->setItemEnabled( 2, FALSE );
    toolBar->setItemEnabled( 3, TRUE );
    toolBar->setItemEnabled( 4, TRUE );
    toolBar->setItemEnabled( 5, TRUE );
    toolBar->setItemEnabled( 6, TRUE );
    user_cfg.status = STATUS_DND;
    MSG *tmp;
    tmp = 0;
    tmp = askAnyRead();
    if ( !tmp ) 
        dockView->setStatus( STATUS_DND );
    else
        dockView->setStatus( STATUS_NEWMSG );

    if ( logged_on ) {
	send_statusChange( STATUS_DND ); 
    } else {
	if (!autoChange) loggedon();
    }
    if (!autoChange) freeTimeOut();
}
void mainWin::setNA( int )
{
    setAwayMsg();
    currentStatus = STATUS_NA;
    sb->changeItem( i18n( "N\\A" ), 0 );
    toolBar->setItemEnabled( 1, TRUE );
    toolBar->setItemEnabled( 0, TRUE );
    toolBar->setItemEnabled( 2, TRUE );
    toolBar->setItemEnabled( 3, FALSE );
    toolBar->setItemEnabled( 4, TRUE );
    toolBar->setItemEnabled( 5, TRUE );
    toolBar->setItemEnabled( 6, TRUE );
    user_cfg.status = STATUS_NA;
    MSG *tmp;
    tmp = 0;
    tmp = askAnyRead();
    if ( !tmp ) 
        dockView->setStatus( STATUS_NA );
    else
        dockView->setStatus( STATUS_NEWMSG );

    if ( logged_on ) {
	send_statusChange( STATUS_NA ); 
    } else {
	if (!autoChange) loggedon();
    }
    if (!autoChange) freeTimeOut();
}
void mainWin::setOccu( int )
{
    setAwayMsg();
    currentStatus = STATUS_OCCUPIED;
    sb->changeItem( i18n( "Uccupied" ), 0 );
    toolBar->setItemEnabled( 1, TRUE );
    toolBar->setItemEnabled( 0, TRUE );
    toolBar->setItemEnabled( 2, TRUE );
    toolBar->setItemEnabled( 3, TRUE );
    toolBar->setItemEnabled( 4, FALSE );
    toolBar->setItemEnabled( 5, TRUE );
    toolBar->setItemEnabled( 6, TRUE );
    user_cfg.status = STATUS_OCCUPIED;
    MSG *tmp;
    tmp = 0;
    tmp = askAnyRead();
    if ( !tmp ) {
        dockView->setStatus( STATUS_OCCUPIED );
    } else
        dockView->setStatus( STATUS_NEWMSG );

    if ( logged_on ) {
	send_statusChange( STATUS_OCCUPIED ); 
    } else {
	if (!autoChange) loggedon();
    }
    if (!autoChange) freeTimeOut();
}

void mainWin::setFFC( int )
{
    currentStatus = STATUS_FFC;
    sb->changeItem( i18n( "Free for Chat" ), 0 );
    toolBar->setItemEnabled( 1, TRUE );
    toolBar->setItemEnabled( 0, TRUE );
    toolBar->setItemEnabled( 2, TRUE );
    toolBar->setItemEnabled( 3, TRUE );
    toolBar->setItemEnabled( 4, TRUE );
    toolBar->setItemEnabled( 5, FALSE );
    toolBar->setItemEnabled( 6, TRUE );
    user_cfg.status = STATUS_FFC;
    MSG *tmp;
    tmp = 0;
    tmp = askAnyRead();
    if ( !tmp ) {
        dockView->setStatus( STATUS_FFC );
    } else
        dockView->setStatus( STATUS_NEWMSG );

    if ( logged_on ) {
	send_statusChange( STATUS_FFC ); 
    } else {
	if (!autoChange) loggedon();
    }
    if ( (!autoChange) && KxicqConfig.autoAway ) initTimeOut( KxicqConfig.awayTime );
}
void mainWin::setInvi( int )
{
    currentStatus = STATUS_INVISIBLE;
    sb->changeItem( i18n( "Invisible" ), 0 );
    toolBar->setItemEnabled( 1, TRUE );
    toolBar->setItemEnabled( 0, TRUE );
    toolBar->setItemEnabled( 2, TRUE );
    toolBar->setItemEnabled( 3, TRUE );
    toolBar->setItemEnabled( 4, TRUE );
    toolBar->setItemEnabled( 5, TRUE );
    toolBar->setItemEnabled( 6, FALSE );
    user_cfg.status = STATUS_INVISIBLE;
    MSG *tmp;
    tmp = 0;
    tmp = askAnyRead();
    if ( !tmp ) 
        dockView->setStatus( STATUS_INVISIBLE );        
    else
        dockView->setStatus( STATUS_NEWMSG );

    if ( logged_on ) {
	send_statusChange( STATUS_INVISIBLE ); 
    } else {
	if (!autoChange) loggedon();
    }
    if (!autoChange) freeTimeOut();
}

void mainWin::setBack( int )
{
    currentStatus = STATUS_ONLINE;
    sb->changeItem( i18n( "Available" ), 0 );
    toolBar->setItemEnabled( 0, TRUE );
    toolBar->setItemEnabled( 1, FALSE );
    toolBar->setItemEnabled( 2, TRUE );
    toolBar->setItemEnabled( 3, TRUE );
    toolBar->setItemEnabled( 4, TRUE );
    toolBar->setItemEnabled( 5, TRUE );
    toolBar->setItemEnabled( 6, TRUE );
    user_cfg.status = STATUS_ONLINE;
    MSG *tmp;
    tmp = 0;
    tmp = askAnyRead();
    if ( !tmp ) {
        dockView->setStatus( STATUS_ONLINE );
    } else
        dockView->setStatus( STATUS_NEWMSG );

    if ( logged_on ) {
	send_statusChange( STATUS_ONLINE ); 
    } else {
	if (!autoChange) loggedon();
    }
    if ( (!autoChange) && KxicqConfig.autoAway ) initTimeOut( KxicqConfig.awayTime );
}


/* ************************************************************************ */

void mainWin::makeSound( int t )
{
    if ( KxicqConfig.sound == TRUE )
    {
        if ( KxicqConfig.alwaysSound == TRUE || currentStatus == STATUS_ONLINE || currentStatus == STATUS_FFC )
        {
            QString path;
            path = kapp->kde_datadir() + "/kxicq/wav/";
            if ( play->serverStatus() != 0 || KxicqConfig.playWav == FALSE )
            {
                if ( KXDEBUG ) printf( "Sound not enabled ! (%d)\n", play->serverStatus() );
                QApplication::beep();
            }
            else
            {
                switch ( t )
                {
                    case TYPE_MSG:
                        play->play( path + "message.wav" );
                        break;
                    case TYPE_URL:
                        play->play( path + "url.wav" );
                        break;
                    case TYPE_ADDED:
                        play->play( path + "message.wav" );
                        break;
                    case TYPE_SEARCH:
                        play->play( path + "notify.wav" );
                        break;
                    case TYPE_CHAT:
                        play->play( path + "chat.wav" );
                        break;
                    default:
                        play->play( path + "message.wav" );
                        break;
                }
            }
        }
    }
}

void mainWin::resizeEvent( QResizeEvent *e )
{
    KTopLevelWidget::resizeEvent( e );
}

int KDEDockStatus=1;
void mainWin::BlinkIcons()
{
    
    if (KxicqConfig.blink && getIconStatus()!=2)
    {
        if (KxicqConfig.wmaker)
        {
                if (getIconStatus()==1)
                    DrawIcon(0);
                else
                    DrawIcon(1);
        }
        if (KxicqConfig.showDock)
        {
            KDEDockStatus=KDEDockStatus==1?0:1;
            dockView->repaint();
        }
    }
}

void mainWin::timerEvent( QTimerEvent * )
{
    if ( !stopAll )
    {
        icq_main();
        autoaway();
        if (KxicqConfig.wmaker)
        {
            wmkxicq_loop();
            
        }
    }
    if ( logged_on == 0 )
    {
        animatedLogoTimer->start( 50 );
        timerRun = 1;
        //dockView->setStatus(STATUS_OFFLINE);
        if ( login_time < time( NULL ) )
        {
            login_time = time( NULL );
            statlogin += ".";
            sb->changeItem( statlogin.data(), 1 );
        }
        if ( login_begin + 20 < time( NULL ) )
        {
            statlogin = i18n( "Connecting" );
            sb->changeItem( statlogin.data(), 1 );
            login_time = login_begin = time( NULL );
            //send_logout();
            fileMenu->setItemEnabled( dis, TRUE );
            fileMenu->setItemEnabled( con, FALSE );
            sendLogin = TRUE;
            send_login();
        }
    }
}

void mainWin::slotAnimatedLogoTimeout()
{
    animatedLogoCounter++;
    if ( ( int ) animatedLogo->count() == ( int ) animatedLogoCounter )
    {
        animatedLogoCounter = 0;
    }
    toolBar->setButtonPixmap( 9, *( animatedLogo->at( animatedLogoCounter ) ) );
}

void mainWin::callbackSetup( CALLBACK_FUNCTIONS &callback_functions )
{
    callback_functions.loggedIn = loggedIn;
    callback_functions.disconnected = disconnected;
    callback_functions.updateContact = updateContact;
    callback_functions.message = message;
    callback_functions.url = url;
    callback_functions.added = added;
    callback_functions.searchResult = searchResult;
    callback_functions.infoResult = infoResult;
    callback_functions.extInfoResult = extInfoResult;
    callback_functions.showAway = showAway;
    callback_functions.newUin = newUin;
    callback_functions.addnewUser = addnewUser;
    callback_functions.nickChange = nickChange;
    callback_functions.putChar = putChar;
    callback_functions.doChat = doChat;
    callback_functions.closeChat = closeChat;
    callback_functions.chatRequest = chatRequest;
    callback_functions.unknownReply = unknownReply;
}

void nickChange( UIN uin, char *nick, int status )
{
    mainW->availList->changeNick( uin, nick, status );
}
void showAway( char *away, UIN uin )
{
    QString tmp;
    CONTACT con = contact_returnContact( uin );
    tmp.sprintf( i18n( "%s is %s:\n\n%s" ), con.nick, contact_status2str( con.status ), away );
    KMsgBox::message( mainW, i18n( "Away Message" ), tmp.data(), 1, i18n( "OK" ) );
}

void mainWin::WloggedIn()
{

    toolBar->setItemEnabled( 0, TRUE );
    toolBar->setItemEnabled( 1, FALSE );
    toolBar->setItemEnabled( 2, TRUE );
    toolBar->setItemEnabled( 3, TRUE );
    toolBar->setItemEnabled( 4, TRUE );
    toolBar->setItemEnabled( 5, TRUE );
    toolBar->setItemEnabled( 6, TRUE );

    sb->changeItem( returnMyStatus(), 0 );
    QString tmp;
    tmp.sprintf( i18n( "Connected to %s on port %d" ), user_cfg.serverAddr, user_cfg.serverPort );
    sb->changeItem( tmp.data(), 1 );

    logged_on = 1;
    autoChange = TRUE;
    //sendLogin=FALSE;
    switch ( user_cfg.status )
    {
        case STATUS_ONLINE:
	    autoChange = ((int)currentStatus != (int)STATUS_OFFLINE);
            setBack ( 0 );
            break;

        case STATUS_AWAY:
            setAway( 0 );
            break;

        case STATUS_DND:
            setDND( 0 );
            break;

        case STATUS_NA:
            setNA( 0 );
            break;

        case STATUS_OCCUPIED:
            setOccu( 0 );
            break;

        case STATUS_FFC:
	    autoChange = ((int)currentStatus != (int)STATUS_OFFLINE);
            setFFC( 0 );
            break;

        case STATUS_INVISIBLE:
            setInvi( 0 );
            break;
    }
    autoChange = FALSE;
    currentStatus = user_cfg.status;
}

void loggedIn()
{
    if (logged_on>=0)
    {
    logged_on=1;
    //  printf("loggedin\n");
    mainW->WloggedIn();
    mainW->animatedLogoTimer->stop();
    mainW->timerRun = 0;
    
    //   dockView->setStatus(user_cfg.status);
    if ( newUserInfo )
    {
        send_change_info( user_cfg.email, user_cfg.nick, user_cfg.firstName, user_cfg.lastName );
        newUserInfo = FALSE;
    }
    if (KxicqConfig.web) send_web();
    }
    else
    {
        send_logout();
    }
}
void mainWin::conn()
{
    if (KXDEBUG) printf("entering conn()\n");
    if ( !newUser && sendLogin == FALSE )
    {
        if ( logged_on < 0 )
        {
            logged_on = 0;
            login_time = login_begin = time( NULL );
            if ( icq_init( &user_cfg ) == -1 )
            {
                printf( i18n( "ERROR: Couldn't initialize library !!\n" ) );
                fileMenu->setItemEnabled( dis, FALSE );
                fileMenu->setItemEnabled( con, TRUE );
		logged_on = -1;
                dockView->setStatus( STATUS_OFFLINE );
                //killTimers();
                discon();
                mainW->animatedLogoTimer->stop();
                //exit( 1 );
            }
            else
            {
                sendLogin = TRUE;
                send_login();
                fileMenu->setItemEnabled( dis, TRUE );
                fileMenu->setItemEnabled( con, FALSE );
                dockView->setStatus( STATUS_OFFLINE );
            }
        }
        else
        {
            if (logged_on==0)
            {
                login_time = login_begin = time( NULL );
                sendLogin = TRUE;
                send_login();
                fileMenu->setItemEnabled( dis, TRUE );
                fileMenu->setItemEnabled( con, FALSE );
                dockView->setStatus( STATUS_OFFLINE );
            }
        }
    }
}
void mainWin::discon()
{
        if (KXDEBUG) printf("entering discon()\n");
    sendLogin = FALSE;
    if ( logged_on )
    {
        send_logout();
    }
    mainW->animatedLogoTimer->stop();
    fileMenu->setItemEnabled( con, TRUE );
    fileMenu->setItemEnabled( dis, FALSE );
    Wdisconnected();
    currentStatus = STATUS_OFFLINE;
    logged_on = -1;
    //freeTimeOut();
}
void mainWin::Wdisconnected()
{
    currentStatus = STATUS_OFFLINE;
    sendLogin = FALSE;
    CONTACT contact;
    availList->setUpdatesEnabled(FALSE);
    for ( int t = 0; t < contact_length(); t++ )
    {
        contact = contact_returnItemNum( t );
        //      printf("UIN : %d, STATUS: %d\n",contact.uin, contact.status);
        availList->changeItem( contact.uin );
        //insertItem(contact.status, contact_uin2nick(contact.uin),contact.uin,askRead(contact.uin));
    }
    availList->setUpdatesEnabled(TRUE);
    toolBar->setItemEnabled( 0, FALSE );
    toolBar->setItemEnabled( 1, FALSE );
    toolBar->setItemEnabled( 2, FALSE );
    toolBar->setItemEnabled( 3, FALSE );
    toolBar->setItemEnabled( 4, FALSE );
    toolBar->setItemEnabled( 5, FALSE );
    toolBar->setItemEnabled( 6, FALSE );


    //   fileMenu->setItemEnabled(ID_MENU_CONNECT,TRUE);
    //   fileMenu->setItemEnabled(ID_MENU_DISCONNECT,FALSE);

    logged_on = -1;
    sb->changeItem( i18n( "Offline" ), 0 );
    sb->changeItem( i18n( "Disconnected" ), 1 );
    timerRun = 0;
    dockView->setStatus( STATUS_OFFLINE );
    freeTimeOut ();
}

void disconnected()
{
/*    sendLogin = FALSE;
    send_logout();
    mainW->Wdisconnected();
    logged_on=-1;
    QString tmp;
    if (KxicqConfig.autoConnect)
            tmp=i18n("We have been disconnected !\n\nPress OK to reconnect");
    else
            tmp=i18n("We have been disconnected !\n\nPress File->Connect to reconnect");

    KMsgBox::message( mainW, i18n( "KXicq, Server message" ), tmp.data(), 1, i18n( "OK" ) );
    if (KxicqConfig.autoConnect)
    {
    if ( icq_init( &user_cfg ) == -1 )
    {
        printf( i18n( "ERROR: Couldn't initialize library !!\n" ) );
        mainW->fileMenu->setItemEnabled( dis, FALSE );
        mainW->fileMenu->setItemEnabled( con, TRUE );
	logged_on = -1;
        dockView->setStatus( STATUS_OFFLINE );
                //killTimers();
        mainW->discon();
        mainW->animatedLogoTimer->stop();
        return;
        //exit( 1 );
    }
    mainW->fileMenu->setItemEnabled( dis, TRUE );
    mainW->fileMenu->setItemEnabled( con, FALSE );
    logged_on = 0;
    dockView->setStatus (mainW->currentStatus);
    
    send_login();
    sendLogin = TRUE;
    mainW->timerRun = 0;
    }*/
}


void newUin( UIN uin )
{
    user_cfg.uin = uin;
    totalConfig->setGroup( "Personal Settings" );
    totalConfig->writeEntry( "UserUIN", user_cfg.uin );
    totalConfig->sync();
    newUserInfo = TRUE;
    newUser = FALSE;
    send_logout();
    mainW->fileMenu->setItemEnabled( con, TRUE );
    mainW->fileMenu->setItemEnabled( dis, FALSE );
    mainW->conn();
}

void mainWin::WupdateContact( unsigned int uin )
{
    availList->changeItem( uin );
}

void updateContact( unsigned int uin )
{
    mainW->WupdateContact( uin );
}

void message( MESSAGE *message )
{
    mainW->Wmessage( message );
    dockView->setStatus( STATUS_NEWMSG );
}
void mainWin::Wmessage( MESSAGE *message )
{
    if (message->online!=2) makeSound( TYPE_MSG );

    UIN num;
    char *string;
    string = ( char * ) malloc( BUFSIZE + 1 );

    QString path;
    path = kapp->localkdedir() + "/share/apps/kxicq/received.kxicq";

    char *tmp;
    char *tmpp;
    tmp = ( char * ) malloc( BUFSIZE );
    QFile msgFile( path.data() );
    num = 0;
    if ( !msgFile.open( IO_ReadWrite ) )
    {
        printf( i18n( "Error writing MSG file !!\n" ) );
    }
    else
    {
        //      msgFile.at(0);
        if ( msgFile.readLine( string, BUFSIZE ) == 0 || msgFile.size() == 0 || msgFile.atEnd() == TRUE )
        {
            num = 1;
            sprintf(string, "Count=%d\n",num);
            msgFile.writeBlock( string, strlen( string ) );
        }
        else
        {
            tmpp = strtok( string, "=" );
            if ( !strcmp( tmpp, "Count" ) )
            {
                num = atoi( strtok( NULL, "" ) ) + 1;
                msgFile.at( 0 );
                sprintf( string, "Count=%d\n", num );
                msgFile.writeBlock( string, strlen( string ) );
            }
            else
            {
                num = 1;
                sprintf(string, "Count=%d\n",num);
                msgFile.writeBlock( string, strlen( string ) );
            }
        }
        msgFile.flush();
        msgFile.at( msgFile.size() );
        int at=msgFile.size();
        int on=0;
        if (message->online==2)
            on=2;
        else
            on=0;
            
        sprintf( string, "[Message %d]\nUIN=%d\nType=message\nRead=%d\nYear=%d\nMonth=%d\nDay=%d\n"
                 "Hour=%d\nMinute=%d\nOnline=%d\nLength=%d\nMessage=",
                 num, message->sender, on,message->time.year, message->time.month, message->time.day,
                 message->time.hour, message->time.min, message->online, message->length );
        msgFile.writeBlock( string, strlen( string ) );
        strcpy( tmp, message->message );
        dos2config( tmp );
        strcat( tmp, "\n" );
        msgFile.writeBlock( tmp, strlen( tmp ) );


        msgFile.flush();
        // msgFile.close();
        MSG *tmp1;
        userMsg.append( new MSG( message->sender ) );
        tmp1 = userMsg.current();
        tmp1->setPos(at);
        if (message->online==2)
            tmp1->setRead(2);
        else
        {
            tmp1->setRead(0);
            availList->changeItem( message->sender );
        }
    }
    if (tmp) free( tmp );
    if (string) free( string );
}
void mainWin::Wurl( URL *message )
{
    if (message->online!=2) makeSound( TYPE_MSG );
    char *string;
    string = ( char * ) malloc( BUFSIZE + 1 );

    QString path;
    path = kapp->localkdedir() + "/share/apps/kxicq/received.kxicq";
    char *tmp, *tmpp;
    tmp = ( char * ) malloc( BUFSIZE + 1 );
    UIN num;
    num = 0;
    QFile msgFile( path.data() );
    if ( !msgFile.open( IO_ReadWrite ) )
    {
        printf( "Error writing MSG file !!\n" );
    }
    else
    {
        //      msgFile.at(0);
        if ( msgFile.readLine( string, BUFSIZE ) == 0 || msgFile.size() == 0 || msgFile.atEnd() == TRUE )
        {
            num = 1;
            sprintf( string, "Count=%d\n", num );
            msgFile.writeBlock( string, strlen( string ) );
        }
        else
        {
            tmpp = strtok( string, "=" );
            if ( !strcmp( tmpp, "Count" ) )
            {
                num = atoi( strtok( NULL, "" ) ) + 1;
                msgFile.at( 0 );
                sprintf( string, "Count=%d\n", num );
                msgFile.writeBlock( string, strlen( string ) );

            }
            else
            {
                num = 1;
                sprintf(string, "Count=%d\n",num);
                msgFile.writeBlock( string, strlen( string ) );
            }
        }
        msgFile.flush();
        msgFile.at( msgFile.size() );
        int at=msgFile.size();
        int on=0;
        if (message->online==2)
            on=2;
        else
            on=0;
        
        sprintf( string, "[Message %d]\nUIN=%d\nType=url\nRead=%d\nYear=%d\nMonth=%d\nDay=%d\n"
                 "Hour=%d\nMinute=%d\nOnline=%d\nMessage=",
                 num, message->sender, on, message->time.year, message->time.month, message->time.day,
                 message->time.hour, message->time.min, message->online );
        msgFile.writeBlock( string, strlen( string ) );
        strcpy( tmp, message->desc );
        dos2config( tmp );
        strcat( tmp, "\n" );
        msgFile.writeBlock( tmp, strlen( tmp ) );
        strcpy( tmp, "Url=" );
        strcat( tmp, message->url );
        dos2config( tmp );
        strcat( tmp, "\n" );
        msgFile.writeBlock( tmp, strlen( tmp ) );



        msgFile.flush();
    // msgFile.close();
        MSG *tmp1;
        userMsg.append( new MSG( message->sender ) );
        tmp1 = userMsg.current();
        tmp1->setnRead(0);
        tmp1->setPos(at);
        
/*    tmp1->setUrl( message );
    tmp1->setrUrl( message->url );
    tmp1->setrMsg( message->desc );*/
    
    }
    //availList->changeItem( message->sender );
    if (tmp) free( tmp );
    if (string) free( string );
}
void url( URL *url )
{
    mainW->Wurl( url );
    dockView->setStatus( STATUS_NEWURL );
}
void mainWin::Wadded( ADDED *message )
{
    makeSound( TYPE_ADDED );
    UIN num;
    num = 0;
    int at=0;
    char *string;
    string = ( char * ) malloc( BUFSIZE + 1 );

    QString path;
    path = kapp->localkdedir() + "/share/apps/kxicq/received.kxicq";
    char *tmp, *tmpp;
    tmp = ( char * ) malloc( BUFSIZE + 1 );
    QFile msgFile( path.data() );
    if ( !msgFile.open( IO_ReadWrite ) )
    {
        printf( "Error writing MSG file !!\n" );
    }
    else
    {
        //      msgFile.at(0);
        if ( msgFile.readLine( string, BUFSIZE ) == 0 || msgFile.size() == 0 || msgFile.atEnd() == TRUE )
        {
            num = 1;
            sprintf( string, "Count=%d\n", num );
            msgFile.writeBlock( string, strlen( string ) );
        }
        else
        {
            tmpp = strtok( string, "=" );
            if ( !strcmp( tmpp, "Count" ) )
            {
                num = atoi( strtok( NULL, "" ) ) + 1;
                msgFile.at( 0 );
                sprintf( string, "Count=%d\n", num );
                msgFile.writeBlock( string, strlen( string ) );

            }
            else
            {
                num = 1;
                sprintf(string, "Count=%d\n",num);
                msgFile.writeBlock( string, strlen( string ) );
            }
        }
        msgFile.flush();
        msgFile.at( msgFile.size() );
        at=msgFile.size();
        if ( message->auth_req)
        {
            sprintf( string, "[Message %d]\nUIN=%d\nType=request\nRead=0\nYear=%d\nMonth=%d\nDay=%d\n"
                     "Hour=%d\nMinute=%d\nOnline=%d\nNick=%s\nFirstname=%s\nLastname=%s\nEmail=%s\nAuth=%d\nText=%s\n",
                     num, message->sender, message->time.year, message->time.month, message->time.day,
                     message->time.hour, message->time.min, message->online, message->nick, message->firstName,
                     message->lastName, message->email, message->auth, message->auth_text);
        }
        else
        {
            sprintf( string, "[Message %d]\nUIN=%d\nType=added\nRead=0\nYear=%d\nMonth=%d\nDay=%d\n"
                     "Hour=%d\nMinute=%d\nOnline=%d\nNick=%s\nFirstname=%s\nLastname=%s\nEmail=%s\nAuth=%d\n",
                     num, message->sender, message->time.year, message->time.month, message->time.day,
                     message->time.hour, message->time.min, message->online, message->nick, message->firstName,
                     message->lastName, message->email, message->auth);
        }
        msgFile.writeBlock( string, strlen( string ) );
            msgFile.flush();
    // msgFile.close();
            MSG *tmp1;
            userMsg.append( new MSG( message->sender ) );
    
            tmp1 = userMsg.current();
            tmp1->setnRead(0);
            tmp1->setPos(at);


    }
/*    tmp1->setText( message->auth_text );
    tmp1->setAdded( message );
    tmp1->setrNick( message->nick );
    tmp1->setFirstName( message->firstName );
    tmp1->setLastName( message->lastName );
    tmp1->setEmail( message->email );*/
    

    availList->changeItem( message->sender );
    if (tmp) free( tmp );
    if (string) free( string );
}
void added( ADDED *added )
{
    mainW->Wadded( added );
    dockView->setStatus( STATUS_NEWMSG );
}

void infoRequest( UIN uin )
{
    if ( !isDoSearch )
    {
        isDoSearch = 1;
        send_infoReply( uin );
    }
}

void mainWin::WsearchResult( SEARCH_RESULT *result )
{
    QString tmp;
    // if (viewS) printf("view: %d <-> %d\n",result->seq, viewS->seq);
    if ( viewS )
    {
        if ( viewS->seq == result->seq )
        {
            // printf("found: %s\n",result->nick);
            viewS->addItem( result->uin, result->nick, result->firstName, result->lastName, result->email );
        }
    }
    else
    {
        makeSound( TYPE_SEARCH );
        tmp.sprintf( i18n( "Info on : %s\nUIN : %d\nfirst: %s\nlast : %s\nemail: %s\nauth :%s\n" ), result->nick,
                     result->uin,
                     result->firstName, result->lastName, result->email, result->auth == 0 ? i18n( "Yes" ) : i18n( "No" ) );
        KMsgBox::message( this, i18n( "Search Result" ), tmp.data(), 1, i18n( "OK" ) );
    }
}

void searchResult( SEARCH_RESULT *result )
{
    mainW->WsearchResult( result );
}
void infoResult( SEARCH_RESULT *result )
{
    // printf("result\n");
    if ( !userI )
    {
        userI = new userInfo( mainW, "userinfo" );
        userI->insertInfo( result );
        //printf("UIN: %d\n",result->uin);
        send_extInfoReply( result->uin );
        userI->show();
    }
    //   mainW->WsearchResult(result);
}
void extInfoResult( EXT_SEARCH_RESULT *result )
{
    //printf("extinfo\n");
    if ( userI )
        userI->insertExtInfo( result );
}

////////////////////////////

void mainWin::help_about()
{
    QMessageBox a;
    QString t;
    t = i18n( "KXicq v " );
    t += KXICQ_version;
    t += i18n( " .\n\nThe KDE ICQ client.\n(C) 1998/1999 Herwin Jan Steehouwer\n"
               "This source code is under the GPL licence.\n\n" );
#ifdef USE_SOCKS5
    t += i18n( "Compiled using the SOCKS 5 library.\n\n" );
#endif
    t += i18n (
               "e-mail   : steehouwer@kde.org\n"
               "www      : http://www.caiw.nl/~herwinjs\n\n\n");
    t+=
        "Tanx to:\n"
        " Fester for KPropDlg 0.6\n"
        " Andreas Gerstlauer for some patches";

    a.information( this, i18n( "About KXicq" ), t.data(), i18n( "&OK" ) );
}
void mainWin::help_aboutXlib()
{

}

void mainWin::help_aboutQT()
{
    QMessageBox a;
    a.aboutQt( this );
}


//////////////////////////////////////////////////////////////////////////////////
// Save and load MSG and config
//////////////////////////////////////////////////////////////////////////////////


void readMsgs()
{
    char *string, *st1;
    //UIN num, uin;
    //int r;
    string = ( char * ) malloc( BUFSIZE + 1 );
    st1 = ( char * ) malloc( BUFSIZE + 1 );
    QFile msgFile;
    QString path;
    path = kapp->localkdedir() + "/share/apps/kxicq/received.kxicq";

    if ( KxicqConfig.first && msgFile.exists( path.data() ) == FALSE )
    {
        strcpy( string, getenv( "HOME" ) );
        strcat( string, "/.xicq/recieved.kxicq" );
        msgFile.setName( string );
        QString path;
        path = "mkdir " + kapp->localkdedir() + "/share/apps/kxicq >/dev/null 2>&1";
        system( path.data() );
    }
    else
    {
//        msgFile.setName(  );
        readFile.setFileName(path.data());
        readFile.scanMessages();
        
    }
}


void saveMsgs()
{


}

void setupNewConfig()
{
    if ( !KxicqConfig.showDock)
        dockView->hide();
    else
        dockView->show();


    if ( KxicqConfig.autoConnect == 1 )
    {
        mainW->conn();
    }
    else
    {
        mainW->animatedLogoTimer->stop();
        logged_on = -1;
        mainW->sb->changeItem( i18n( "Disconnected" ), 1 );
    }
    mainW->availList->setupConfig();
//    mainW->availList->setNewView( OldStyle );
}

void setupBeginConfig()
{
    int old=OldStyle;
    if (OldStyle==3)
        mainW->availList->setNewView(2);
    if (!KxicqConfig.geom.isEmpty() && KxicqConfig.saveGeom )
    {
        mainW->setGeometry(KWM::setProperties(mainW->winId(),KxicqConfig.geom));
        mainW->update();
    }
    else
    {
        switch(OldStyle)
        {
        case 1:
            mainW->resize( 385, 300 );
            mainW->repaint();
            break;
        case 2:
            mainW->resize( 195, 300 );
            mainW->repaint();
            break;
        case 3:
            mainW->resize( 195, 300 );
            mainW->repaint();
            break;
        }
    }
    if (old==3)
    {
        mainW->availList->setNewView(2);
        mainW->update();
    }
    mainW->availList->setNewView( old );
    
    if ( KxicqConfig.hideWindow )
        mainW->hide();
    else
        mainW->show();

}

void loadKxicqConfig()
{

    user_cfg.uin	= 0;
    if ( user_cfg.password	!= NULL ) free( user_cfg.password );
    user_cfg.password	= NULL;
    if ( user_cfg.nick	!= NULL ) free( user_cfg.nick );
    user_cfg.nick	= NULL;
    if ( user_cfg.firstName	!= NULL ) free( user_cfg.firstName );
    user_cfg.firstName	= NULL;
    if ( user_cfg.lastName	!= NULL ) free( user_cfg.lastName );
    user_cfg.lastName	= NULL;
    if ( user_cfg.email	!= NULL ) free( user_cfg.email );
    user_cfg.email	= NULL;
    if ( user_cfg.logfile	!= NULL ) free( user_cfg.logfile );
    user_cfg.logfile	= NULL;
    user_cfg.defaultStatus	= 0;
    if ( user_cfg.contactList	!= NULL ) free( user_cfg.contactList );
    user_cfg.contactList	= NULL;
    if ( user_cfg.serverAddr	!= NULL ) free( user_cfg.serverAddr );
    user_cfg.serverAddr	= NULL;
    user_cfg.serverPort	= 0;
    user_cfg.clientPort	= 0;

    QString str;
    totalConfig->setGroup( "Personal Settings" );
    // printf("group\n");
    if ( !reinit ) KxicqConfig.first = totalConfig->readBoolEntry( "FirstTime", TRUE );
    user_cfg.uin = ( UIN ) atoi( totalConfig->readEntry( "UserUIN", "0" ).data() );

    QString file;
    file.sprintf( "%s/share/apps/kxicq/contact", kapp->localkdedir().data() );
    QFile f;
    QString path;

    if ( f.exists( file.data() ) == FALSE )
    {
            path = "mkdir " + kapp->localkdedir() + " >/dev/null 2>&1";
            system( path.data() );
            path = "mkdir " + kapp->localkdedir() + "/share >/dev/null 2>&1";
            system( path.data() );
            path = "mkdir " + kapp->localkdedir() + "/share/config >/dev/null 2>&1";
            system( path.data() );
            path = "mkdir " + kapp->localkdedir() + "/share/apps >/dev/null 2>&1";
            system( path.data() );
            path = "mkdir " + kapp->localkdedir() + "/share/apps/kxicq >/dev/null 2>&1";
            system( path.data() );

        path = "echo 677536:Gompy >" + kapp->localkdedir() + "/share/apps/kxicq/contact 2>&1";
        system( path.data() );
    }

    if ( ( user_cfg.uin <= 0 || KxicqConfig.first ) && !reinit )
    {
        //  printf("old config\n");
        if ( userConfigure( &user_cfg ) < 0 )
        {
            char * home;
            home = ( char * ) malloc( BUFSIZE + 1 );
            strcpy( home, getenv( "HOME" ) );
            // new config

            path = "mkdir " + kapp->localkdedir() + " >/dev/null 2>&1";
            system( path.data() );
            path = "mkdir " + kapp->localkdedir() + "/share >/dev/null 2>&1";
            system( path.data() );
            path = "mkdir " + kapp->localkdedir() + "/share/config >/dev/null 2>&1";
            system( path.data() );
            path = "mkdir " + kapp->localkdedir() + "/share/apps >/dev/null 2>&1";
            system( path.data() );
            path = "mkdir " + kapp->localkdedir() + "/share/apps/kxicq >/dev/null 2>&1";
            system( path.data() );
            registerDialog *regW;
            regW = new registerDialog();
            regW->show();
            mainApp->processEvents();
            mainApp->flushX();
            regW->getInfo( &user_cfg.uin, &user_cfg.nick, &user_cfg.firstName, &user_cfg.lastName, &user_cfg.email,
                           &user_cfg.password );
            asprintf( &user_cfg.serverAddr, "icq.mirabilis.com" );
            user_cfg.serverPort = 4000;
            user_cfg.status = 0;
            user_cfg.showoffline = 1;
            asprintf( &user_cfg.logfile, "%s/share/apps/kxicq/log", kapp->localkdedir().data() );
            asprintf( &user_cfg.contactList, "%s/share/apps/kxicq/contact", kapp->localkdedir().data() );

            contact_init( user_cfg.contactList );
            if ( user_cfg.uin <= 0 )
            {
                send_request_new_user( user_cfg.password, &user_cfg );
                newUserInfo = TRUE;
                newUser = TRUE;
            }
            if (regW) delete regW;
            if (home) free( home );
        }
        // save new config
        //   printf("save new config\n");
        totalConfig->setGroup( "Personal Settings" );
        totalConfig->writeEntry( "UserUIN", user_cfg.uin );
        totalConfig->writeEntry( "UserNick", user_cfg.nick );
        totalConfig->writeEntry( "UserPassword", user_cfg.password );
        totalConfig->writeEntry( "UserLastName", user_cfg.lastName );
        totalConfig->writeEntry( "UserFirstName", user_cfg.firstName );
        totalConfig->writeEntry( "UserEmail", user_cfg.email );
        KxicqConfig.first = FALSE;
        totalConfig->writeEntry( "FirstTime", KxicqConfig.first );
        totalConfig->setGroup( "Server" );
        totalConfig->writeEntry( "ServerAddress", user_cfg.serverAddr );
        totalConfig->writeEntry( "ServerPort", user_cfg.serverPort );
        totalConfig->sync();
        KxicqConfig.autoConnect = FALSE;
    }
    else
    {
        asprintf( &user_cfg.nick, "%s", totalConfig->readEntry( "UserNick", "" ).data() );
        user_cfg.uin = ( UIN ) atoi( totalConfig->readEntry( "UserUIN", "0" ).data() );
        asprintf( &user_cfg.password, "%s", totalConfig->readEntry( "UserPassword", "" ).data() );
        asprintf( &user_cfg.firstName, "%s", totalConfig->readEntry( "UserFirstname", "" ).data() );
        asprintf( &user_cfg.lastName, "%s", totalConfig->readEntry( "UserLastname", "" ).data() );
        asprintf( &user_cfg.email, "%s", totalConfig->readEntry( "UserEmail", "" ).data() );
    }
        totalConfig->setGroup( "Server" );
        asprintf( &user_cfg.serverAddr, "%s", totalConfig->readEntry( "ServerAddress", "icq.mirabilis.com" ).data() );
        user_cfg.serverPort = atoi( totalConfig->readEntry( "ServerPort", "4000" ).data() );

        asprintf( &user_cfg.logfile, "%s/share/apps/kxicq/log", kapp->localkdedir().data() );
        asprintf( &user_cfg.contactList, "%s/share/apps/kxicq/contact", kapp->localkdedir().data() );
    
	totalConfig->setGroup( "Docking Settings" );


        KxicqConfig.wmaker = totalConfig->readBoolEntry( "WindowMaker Dock", FALSE );
        KxicqConfig.kdestyle = totalConfig->readBoolEntry( "KDEStyle", TRUE );
        KxicqConfig.showNewMesg = totalConfig->readBoolEntry( "ShowNewMesg", TRUE );
        KxicqConfig.showDock = totalConfig->readBoolEntry( "ShowDocking", TRUE );
        KxicqConfig.hideWindow = totalConfig->readBoolEntry( "HideWindow", FALSE );
        KxicqConfig.blink = totalConfig->readBoolEntry( "Blink Icon", FALSE );

        totalConfig->writeEntry( "WindowMaker Dock", KxicqConfig.wmaker );
        totalConfig->writeEntry( "KDEStyle", KxicqConfig.kdestyle );
        totalConfig->writeEntry( "ShowNewMesg", KxicqConfig.showNewMesg );
        totalConfig->writeEntry( "ShowDocking", KxicqConfig.showDock );
        totalConfig->writeEntry( "HideWindow", KxicqConfig.hideWindow );
        totalConfig->writeEntry( "Blink Icon", KxicqConfig.blink );

        //   printf("[%s] [%s] [%s]n",user_cfg.contactList, user_cfg.serverAddr, user_cfg.nick);

        totalConfig->setGroup( "Startup" );
        OldStyle = totalConfig->readNumEntry( "ViewStartup", 1 );
        KxicqConfig.saveGeom = totalConfig->readBoolEntry( "saveGeometry", TRUE );
        totalConfig->writeEntry( "saveGeometry", KxicqConfig.saveGeom );
        if (KxicqConfig.saveGeom)
        {
            KxicqConfig.geom = totalConfig->readEntry( "Geometry");
        }
        
        KxicqConfig.autoConnect = totalConfig->readBoolEntry( "AutoConnect", FALSE );
        totalConfig->writeEntry( "AutoConnect", KxicqConfig.autoConnect );
        QString st = totalConfig->readEntry( "StartupStatus", "" );
        if ( st == "Available" )
        {
            user_cfg.status = STATUS_ONLINE;
        }
        else
        {
            if ( st == "Away" )
            {
                user_cfg.status = STATUS_AWAY;
            }
            else
            {
                if ( st == "DND" )
                {
                    user_cfg.status = STATUS_DND;
                }
                else
                {
                    if ( st == "N/A" )
                    {
                        user_cfg.status = STATUS_NA;
                    }
                    else
                    {
                        if ( st == "Occupied" )
                        {
                            user_cfg.status = STATUS_OCCUPIED;
                        }
                        else
                        {
                            if ( st == "Free for Chat" )
                            {
                                user_cfg.status = STATUS_FFC;
                            }
                            else
                            {
                                if ( st == "Invisible" )
                                {
                                    user_cfg.status = STATUS_INVISIBLE;
                                }
                                else
                                {
                                    user_cfg.status = STATUS_ONLINE;
                                }
                            }
                        }
                    }
                }
            }
        }

        totalConfig->setGroup( "Message Settings" );
        KxicqConfig.playWav = totalConfig->readBoolEntry( "PlayWavFile", TRUE );
        KxicqConfig.sound = totalConfig->readBoolEntry( "MessageBeep", TRUE );
        KxicqConfig.alwaysSound = totalConfig->readBoolEntry( "MessageBeepWhenAway", FALSE );
        KxicqConfig.showLastUnread = totalConfig->readBoolEntry( "ShowLastUnread", TRUE );
        QString br=totalConfig->readEntry( "Browser", "kfmclient %u" );
        KxicqConfig.browser = br.data();
        
        totalConfig->writeEntry( "PlayWavFile", KxicqConfig.playWav );
        totalConfig->writeEntry( "MessageBeep", KxicqConfig.sound );
        totalConfig->writeEntry( "MessageBeepWhenAway", KxicqConfig.alwaysSound );
        totalConfig->writeEntry( "ShowLastUnread", KxicqConfig.showLastUnread );

        totalConfig->setGroup( "AutoAway Settings" );
        if ( awayMsg )
            free( awayMsg );
        awayMsg = ( char * ) malloc( 200 );
        QString st1 = totalConfig->readEntry( "awayMsg", i18n( "I'm away for a while !#13#10Cya later !!" ) );
        strcpy( awayMsg, st1.data() );
        totalConfig->writeEntry( "awayMsg", st1.data() );
        config2dos( awayMsg, strlen( awayMsg ) );
        //strcpy(awayMsg, "I'm away for a while !\n\rCya later !!");
        setawaymsg( awayMsg );

        KxicqConfig.autoUnAway = totalConfig->readBoolEntry( "autoUnAway", TRUE );
        KxicqConfig.autoAway = totalConfig->readBoolEntry( "autoAway", TRUE );
        KxicqConfig.askAway = totalConfig->readBoolEntry( "askAway", TRUE );
        KxicqConfig.awayTime = totalConfig->readNumEntry( "awayTime", 10 );
        KxicqConfig.naTime = totalConfig->readNumEntry( "naTime", 10 );

        totalConfig->writeEntry( "autoUnAway", KxicqConfig.autoUnAway );
        totalConfig->writeEntry( "askAway", KxicqConfig.askAway );
        totalConfig->writeEntry( "autoAway", KxicqConfig.autoAway );
        totalConfig->writeEntry( "awayTime", KxicqConfig.awayTime );
        totalConfig->writeEntry( "naTime", KxicqConfig.naTime );

        KxicqConfig.awayTime *= 60;
        KxicqConfig.naTime *= 60;

        totalConfig->setGroup( "Chat Settings" );
        KxicqConfig.autoRaise = totalConfig->readBoolEntry( "autoRaise", TRUE );
        totalConfig->writeEntry( "autoRaise", KxicqConfig.autoRaise );

        totalConfig->setGroup( "Web Settings" );
        KxicqConfig.web = totalConfig->readBoolEntry( "Web Presence", FALSE );
        totalConfig->writeEntry( "Web Presence", KxicqConfig.web );

        totalConfig->setGroup( "User View Settings" );
        KxicqConfig.rightStatus = totalConfig->readBoolEntry( "Show Status Right", TRUE );
        KxicqConfig.showUIN = totalConfig->readBoolEntry( "Show UIN", TRUE );
        KxicqConfig.showTextStatus = totalConfig->readBoolEntry( "Show Status as Text", FALSE );

        totalConfig->writeEntry( "Show Status Right", KxicqConfig.rightStatus );
        totalConfig->writeEntry( "Show UIN", KxicqConfig.showUIN );
        totalConfig->writeEntry( "Show Status as Text", KxicqConfig.showTextStatus );

        KxicqConfig.viewSmall = totalConfig->readBoolEntry( "Small View", FALSE );
        totalConfig->writeEntry( "Small View", KxicqConfig.viewSmall );

        QFont f1( "Helvetica", 13, QFont::Bold );
        KxicqConfig.onlineF = totalConfig->readFontEntry( "Online Font", &f1 );
        totalConfig->writeEntry( "Online Font", KxicqConfig.onlineF );
        KxicqConfig.offlineF = totalConfig->readFontEntry( "Offline Font", &f1 );
        totalConfig->writeEntry( "Offline Font", KxicqConfig.offlineF );
        QFont fs( "Helvetica", 10 );
        KxicqConfig.uinF = totalConfig->readFontEntry( "UIN Font", &fs );
        totalConfig->writeEntry( "UIN Font", KxicqConfig.uinF );

        KxicqConfig.onlineT = totalConfig->readColorEntry("Online Text Color",&kapp->textColor);
        totalConfig->writeEntry("Online Text Color",KxicqConfig.onlineT);
        KxicqConfig.offlineT = totalConfig->readColorEntry("Offline Text Color",&kapp->textColor);
        totalConfig->writeEntry("Offline Text Color",KxicqConfig.offlineT);

        KxicqConfig.onlineB = totalConfig->readColorEntry("Online Background Color",&kapp->windowColor);
        totalConfig->writeEntry("Online Background Color",KxicqConfig.onlineB);
        KxicqConfig.offlineB = totalConfig->readColorEntry("Offline Background Color",&kapp->windowColor);
        totalConfig->writeEntry("Offline Background Color",KxicqConfig.offlineB);

        KxicqConfig.onlineST = totalConfig->readColorEntry("Online Select Text Color",&kapp->selectTextColor);
        totalConfig->writeEntry("Online Select Text Color",KxicqConfig.onlineST);
        KxicqConfig.offlineST = totalConfig->readColorEntry("Offline Select Text Color",&kapp->selectTextColor);
        totalConfig->writeEntry("Offline Select Text Color",KxicqConfig.offlineST);

        KxicqConfig.onlineSB = totalConfig->readColorEntry("Online Select Background Color",&kapp->selectColor);
        totalConfig->writeEntry("Online Select Background Color",KxicqConfig.onlineSB);
        KxicqConfig.offlineSB = totalConfig->readColorEntry("Offline Select Background Color",&kapp->selectColor);
        totalConfig->writeEntry("Offline Select Background Color",KxicqConfig.offlineSB);

        QColor color;
        color.setRgb(255,0,0);
        KxicqConfig.messageSendText = totalConfig->readColorEntry("Send Message Text Color",&color);
        totalConfig->writeEntry("Send Message Text Color",KxicqConfig.messageSendText);
        color.setRgb(0,0,0);
        KxicqConfig.messageSendBack = totalConfig->readColorEntry("Send Message Background Color",&color);
        totalConfig->writeEntry("Send Message Background Color",KxicqConfig.messageSendBack);

        totalConfig->sync();

    
}


void saveConfig()
{
    totalConfig->setGroup( "Startup" );
    totalConfig->writeEntry( "ViewStartup", OldStyle );
    if (KxicqConfig.saveGeom)
    {
        totalConfig->writeEntry( "Geometry", KWM::getProperties(mainW->winId()) );
    }
    else
    {
        totalConfig->writeEntry( "Geometry", "" );
    }
    totalConfig->sync();
    if ( user_cfg.contactList	!= NULL ) free( user_cfg.contactList );
    user_cfg.contactList	= NULL;
    asprintf( &user_cfg.contactList, "%s/share/apps/kxicq/contact", kapp->localkdedir().data() );
    contact_save( user_cfg.contactList );
}
// *******************************************************
// * Dock view
// *******************************************************

DockView::DockView()
        : QWidget()
{
    showM = 1;
    showPixmap = iconL->loadIcon( "offline.xpm" );
    status = user_cfg.status;
    menu = new QPopupMenu;
    menu->insertItem( i18n( "About &KXicq" ), mainW, SLOT( help_about() ) );
    menu->insertItem( i18n( "&Show Window" ), this, SLOT( showWindow() ) );
    menu->insertItem( i18n( "Conf&igure" ), mainW, SLOT( configShow() ) );
    menu->insertSeparator();
    menu->insertItem( i18n( "&Exit" ), mainW, SLOT( quit() ) );
    menu->insertSeparator();
    menu->insertItem("&Connect", mainW, SLOT(conn()), 0, 11);
    menu->insertItem("&Disconnect", mainW, SLOT(discon()), 0, 10);
    menu->insertSeparator();
    menu->insertItem( i18n( "Set &Available" ), this, SLOT( setBack() ), 0, 0 );
    menu->insertItem( i18n( "Set A&way" ), this, SLOT( setAway() ), 0, 1 );
    menu->insertItem( i18n( "Set D&ND" ), this, SLOT( setDND() ), 0, 2 );
    menu->insertItem( i18n( "Set &N/A" ), this, SLOT( setNA() ), 0, 3 );
    menu->insertItem( i18n( "Set &Occupied" ), this, SLOT( setOccu() ), 0, 4 );
    menu->insertItem( i18n( "Set &Free For Chat" ), this, SLOT( setFFC() ), 0, 5 );
    menu->insertItem( i18n( "Set &Invisible" ), this, SLOT( setInvi() ), 0, 6 );
    QString tooltip;
    tooltip.sprintf( "KXicq %s", VERSION );
    QToolTip::add( this, tooltip.data() );
    
    menu->setItemEnabled (0, FALSE);
    menu->setItemEnabled (1, FALSE);
    menu->setItemEnabled (2, FALSE);
    menu->setItemEnabled (3, FALSE);
    menu->setItemEnabled (4, FALSE);
    menu->setItemEnabled (5, FALSE);
    menu->setItemEnabled (6, FALSE);
    menu->setItemEnabled (10, FALSE);
    menu->setItemEnabled (11, TRUE);

    
}

void DockView::showWindow()
{
    //setStatus( status );
    if ( mainW->isVisible() )
        {
            mainW->hide();
        }
        else
        {
            mainW->show();
            KWM::activate( mainW->winId() );
        }
}
void DockView::doDockPress()
{
    MSG *tmp;
    tmp = 0;
    tmp = askAnyRead();
    //setStatus( status );
    if ( tmp )
    {
        dockView->setStatus( mainW->currentStatus );
        Read * tmpR;
        tmpR = new Read( tmp->getUin(), mainW );
        if ( !tmpR->exec() )
        {
            return;
        }
        mainApp->processEvents();
        mainApp->flushX();
        //delete newOneMsg;
        if (tmpR) delete tmpR;

        mainW->availList->doSetUnRead( tmp->getUin() );
        dockView->setStatus( mainW->currentStatus );

    }
    else
    {
        if ( mainW->isVisible() )
        {
            mainW->hide();
        }
        else
        {
            mainW->show();
            KWM::activate( mainW->winId() );
        }
    }
    tmp = 0;

    tmp = askAnyRead();
    if ( tmp )
    {
        status = STATUS_NEWMSG;
        setStatus( status );
    }
    else
    {
        status = mainW->currentStatus;
        setStatus( status );
    }
    dockView->setStatus( mainW->currentStatus );
}

void DockView::mouseDoubleClickEvent( QMouseEvent * )
{
    setStatus( status );
    if ( !KxicqConfig.kdestyle )
        doDockPress();
}
void DockView::mousePressEvent( QMouseEvent *e )
{
    setStatus( status );
    if ( e->button() == LeftButton )
    {
        if ( KxicqConfig.kdestyle )
        {
            doDockPress();
        }
    }
    else
    {
        if ( e->button() == RightButton )
        {
            showMenu(e->x() + this->x(),e->y() + this->y());
        }
    }
}
void DockView::showMenu(int x,int y)
{
            menu->popup( QPoint( x, y ) );
}

void DockView::setStatus( int s )
{
    if ( sendLogin || (logged_on >= 0) || ((int)s != (int)STATUS_OFFLINE) ) {
	menu->setItemEnabled (0, TRUE);
	menu->setItemEnabled (1, TRUE);
	menu->setItemEnabled (2, TRUE);
	menu->setItemEnabled (3, TRUE);
	menu->setItemEnabled (4, TRUE);
	menu->setItemEnabled (5, TRUE);
	menu->setItemEnabled (6, TRUE);
	menu->setItemEnabled (10, TRUE);
	menu->setItemEnabled (11, FALSE);
    }
    else {
	menu->setItemEnabled (0, FALSE);
	menu->setItemEnabled (1, FALSE);
	menu->setItemEnabled (2, FALSE);
	menu->setItemEnabled (3, FALSE);
	menu->setItemEnabled (4, FALSE);
	menu->setItemEnabled (5, FALSE);
	menu->setItemEnabled (6, FALSE);
	menu->setItemEnabled (10, FALSE);
	menu->setItemEnabled (11, TRUE);
    }

        MSG *tmp;
        tmp = 0;
        tmp = askAnyRead();
        if ( tmp )
        {
            if (KxicqConfig.blink)
                mainW->blinkIcons->start(650);
            s=STATUS_NEWMSG;
            KDEDockStatus=1;
        }
        else
        {
            if (KxicqConfig.blink)
                mainW->blinkIcons->stop();
            if (KxicqConfig.wmaker)
            {
                DrawMessage("-");
            }
            KDEDockStatus=1;
        }


    iconL = kapp->getIconLoader();
    switch ( s )
    {
    case STATUS_OFFLINE:
        if (KxicqConfig.wmaker)
        {
            DrawStatus("offline");
            DrawIcon(2);
        }
        
            showPixmap = iconL->loadIcon( "offline.xpm" );
   	    menu->setItemEnabled (0, FALSE);
	    menu->setItemEnabled (1, FALSE);
	    menu->setItemEnabled (2, FALSE);
	    menu->setItemEnabled (3, FALSE);
	    menu->setItemEnabled (4, FALSE);
	    menu->setItemEnabled (5, FALSE);
	    menu->setItemEnabled (6, FALSE);
            break;
    case STATUS_AWAY:
        if (KxicqConfig.wmaker)
        {
            DrawStatus("away");
            DrawIcon(1);
        }
            showPixmap = iconL->loadIcon( "away.xpm" );
	    menu->setItemEnabled (1, FALSE);
            break;
    case STATUS_DND:
        if (KxicqConfig.wmaker)
        {
            DrawStatus("DND");
            DrawIcon(1);
        }
            showPixmap = iconL->loadIcon( "DND.xpm" );
	    menu->setItemEnabled (2, FALSE);
            break;
    case STATUS_NA:
        if (KxicqConfig.wmaker)
        {
            DrawStatus("NA");
            DrawIcon(1);
        }
        showPixmap = iconL->loadIcon( "NA.xpm" );
	    menu->setItemEnabled (3, FALSE);
            break;
    case STATUS_OCCUPIED:
        if (KxicqConfig.wmaker)
        {
            DrawStatus("occupied");
            DrawIcon(1);
        }
            showPixmap = iconL->loadIcon( "occupied.xpm" );
	    menu->setItemEnabled (4, FALSE);
            break;
    case STATUS_FFC:
        if (KxicqConfig.wmaker)
        {
            DrawStatus("ffchat");
            DrawIcon(1);
        }
            showPixmap = iconL->loadIcon( "ffc.xpm" );
	    menu->setItemEnabled (5, FALSE);
            break;
    case STATUS_INVISIBLE:
        if (KxicqConfig.wmaker)
        {
            DrawStatus("inivisible");
            DrawIcon(1);
        }
            showPixmap = iconL->loadIcon( "invisible.xpm" );
            
	    menu->setItemEnabled (6, FALSE);
            break;
    case STATUS_NEWMSG:
        if (KxicqConfig.wmaker)
        {
            DrawMessage("new msg");
        }
        KDEDockStatus=1;
            
	    //setStatus (mainW->currentStatus);
            showPixmap = iconL->loadIcon( "filemail.xpm" );
            break;
    case STATUS_NEWURL:
        if (KxicqConfig.wmaker)
        {
            DrawMessage("new msg");
        }
        KDEDockStatus=1;
	    //setStatus (mainW->currentStatus);
            showPixmap = iconL->loadIcon( "filemail.xpm" );
            break;
        case STATUS_ONLINE:
    default:
        if (KxicqConfig.wmaker)
        {
            DrawStatus("online");
            DrawIcon(1);
        }
            showPixmap = iconL->loadIcon( "online.xpm" );
	    menu->setItemEnabled (0, FALSE);
            break;

    }
    status = s;
    //paintEvent( 0 );
    update();
}

void DockView::paintEvent( QPaintEvent * )
{
    QPixmap pm( size() );
    QPainter p;

    if ( logged_on || (status == STATUS_NEWMSG) || (status == STATUS_NEWURL) )
    {
        if (KDEDockStatus==1)
        {
            pm.fill( backgroundColor() );
            p.begin( &pm );
            p.drawPixmap( 2, 0, showPixmap );
            p.end();
        }
        else
        {
            pm.fill( backgroundColor() );
        }
    }
    else {

	QBitmap mask = showPixmap.createHeuristicMask();
	QBitmap bitmap = mask;
	bitmap.setMask (mask);
    
	pm.fill( palette().disabled().background() );

	p.begin( &pm );
	p.setPen( palette().disabled().light() );
	p.drawPixmap( 3, 1, bitmap );
	p.setPen( palette().disabled().mid() );
	p.drawPixmap( 2, 0, bitmap );
	p.end();
    }

    bitBlt( this, 0, 0, &pm );
}

void DockView::setAway()
{
    mainW->setAway( 1 );
}
void DockView::setBack()
{
    mainW->setBack( 1 );
}
void DockView::setNA()
{
    mainW->setNA( 1 );
}
void DockView::setFFC()
{
    mainW->setFFC( 1 );
}
void DockView::setOccu()
{
    mainW->setOccu( 1 );
}
void DockView::setInvi()
{
    mainW->setInvi( 1 );
}
void DockView::setDND()
{
    mainW->setDND( 1 );
}


/* ********************************************************* */
int main( int argc, char **argv )
{

    sendLogin=FALSE;
    logged_on=-1;
    
#ifdef USE_SOCKS5
    SOCKSinit( argv[ 0 ] );
#endif

    if (argc>1)
    {
        if (strcmp(argv[1],"-d")==0)
            KXDEBUG=1;
        else
            if (strcmp(argv[1],"--debug")==0)
                KXDEBUG=1;
    }

    
    mainApp = new KApplication( argc, argv, "kxicq" );
    mainApp->enableSessionManagement( TRUE );

    totalConfig = mainApp->getConfig();
    loadKxicqConfig();
    contact_init( user_cfg.contactList );
    mainW = new mainWin( 0, "kxicq" );
    mainW->hide();
    mainApp->setMainWidget( mainW );
    setupBeginConfig();
    

    KWM *kwm = new KWM;
    dockView = new DockView();

    kwm->setDecoration( dockView->winId(), KWM::noDecoration );
    kwm->setDockWindow( dockView->winId() );

    setupNewConfig();
    if (KxicqConfig.wmaker)
    {
        wmkxicq_init(argc, argv);
    }
    
    // mainW->show();
    mainW->availList->setNewView( OldStyle );
    int ret = mainApp->exec();

//    saveMsgs();
    saveConfig();
    //   writeNewConfigFile(user_cfg);
    if ( logged_on ) send_logout();
    mainW->fileMenu->setItemEnabled( con, TRUE );
    mainW->fileMenu->setItemEnabled( dis, FALSE );
    freeTimeOut();
    return ret;
}

/* ********************************************************** */
/* read old config file */
/* ********************************************************** */
int userConfigure( USER_CONFIGURATION *user_cfg )
{
    char * string;
    char *config_file;
    char *home;
    char *origTmp;
    home = ( char * ) malloc( 300 );
    config_file = ( char * ) malloc( 300 );
    strcpy( home, getenv( "HOME" ) );
    user_cfg->uin	= 0;
    if ( user_cfg->password	!= NULL ) free( user_cfg->password );
    user_cfg->password	= NULL;
    if ( user_cfg->nick	!= NULL ) free( user_cfg->nick );
    user_cfg->nick	= NULL;
    if ( user_cfg->firstName	!= NULL ) free( user_cfg->firstName );
    user_cfg->firstName	= NULL;
    if ( user_cfg->lastName	!= NULL ) free( user_cfg->lastName );
    user_cfg->lastName	= NULL;
    if ( user_cfg->email	!= NULL ) free( user_cfg->email );
    user_cfg->email	= NULL;
    if ( user_cfg->logfile	!= NULL ) free( user_cfg->logfile );
    user_cfg->logfile	= NULL;
    user_cfg->defaultStatus	= 0;
    if ( user_cfg->contactList	!= NULL ) free( user_cfg->contactList );
    user_cfg->contactList	= NULL;
    if ( user_cfg->serverAddr	!= NULL ) free( user_cfg->serverAddr );
    user_cfg->serverAddr	= NULL;
    user_cfg->serverPort	= 0;
    user_cfg->clientPort	= 0;

    asprintf( &config_file, "%s/%s", home, ".xicq/config" );
    string = ( char * ) malloc( 300 );
    ifstream configFile( config_file, ios::in );
    if ( !configFile )
    {
        if (string) free ( string );
        if (home) free( home );
        if (config_file) free( config_file );
        return - 1;
    }
    else
    {
        while ( configFile.getline( string, BUFSIZE ) )
        {
            if ( !( strlen( string ) == 1 && string[ 0 ] == '\n' ) && strlen( string ) != 0 )
            {
                if ( string[ 0 ] != '#' )
                {
                    char * tmp;
                    tmp = strtok( string, "=" );
                    if ( !strcmp( tmp, "UIN" ) )
                    {
                        user_cfg->uin = atoi( strtok( NULL, "" ) );
                    } else if ( !strcmp( tmp, "PASSWORD" ) )
                    {
                        asprintf( &user_cfg->password, "%s", strtok( NULL, "" ) );
                    } else if ( !strcmp( tmp, "NICK" ) )
                    {
                        asprintf( &user_cfg->nick, "%s", strtok( NULL, "" ) );
                    } else if ( !strcmp( tmp, "FIRSTNAME" ) )
                    {
                        asprintf( &user_cfg->firstName, "%s", strtok( NULL, "" ) );
                    } else if ( !strcmp( tmp, "LASTNAME" ) )
                    {
                        asprintf( &user_cfg->lastName, "%s", strtok( NULL, "" ) );
                    } else if ( !strcmp( tmp, "EMAIL" ) )
                    {
                        asprintf( &user_cfg->email, "%s", strtok( NULL, "" ) );
                    } else if ( !strcmp( tmp, "ICQSERVER" ) )
                    {
                        asprintf( &user_cfg->serverAddr, "%s", strtok( NULL, "" ) );
                    } else if ( !strcmp( tmp, "ICQPORT" ) )
                    {
                        user_cfg->serverPort = atoi( strtok( NULL, "" ) );
                    } else if ( !strcmp( tmp, "STATUS" ) )
                    {
                        user_cfg->status = atoi( strtok( NULL, "" ) );
                    } else if ( !strcmp( tmp, "SHOWOFFLINE" ) )
                    {
                        tmp = strtok( NULL, "" );

                        tmp[ 0 ] = toupper( tmp[ 0 ] );
                        if ( tmp[ 0 ] == '1' || tmp[ 0 ] == 'T' || tmp[ 0 ] == 'Y' )
                            user_cfg->showoffline = 1;
                        else
                            user_cfg->showoffline = 0;
                    } else if ( !strcmp( tmp, "CONTACT_FILE" ) )
                    {
                        origTmp = strtok( NULL, "" );
                        origConfig.sprintf( "%s", origTmp );
                        asprintf( &user_cfg->contactList, "%s/%s", home, origTmp );
                    }
                }
            }
        }
        configFile.close();
        if (string) free( string );
        if (home) free( home );
        if (config_file) free( config_file );
    }
    return 0;
}

